/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.DocumentToJavaBean;
import cn.xyz.commons.utils.ExcelUtil;
import cn.xyz.commons.utils.MapUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.model.PageVO;
import cn.xyz.mianshi.service.FriendsManager;
import cn.xyz.mianshi.service.impl.AuthKeysServiceImpl;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AuthKeys;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.mianshi.vo.OfflineOperation;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.FriendsRepositoryImpl;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import cn.xyz.service.RedisServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendsManagerImpl
extends MongoRepository<Friends, ObjectId>
implements FriendsManager {
    private static final String groupCode = "110";
    private static Logger Log = LoggerFactory.getLogger(FriendsManager.class);
    private static final String NEWFIREND = "shiku_newFirend";
    public static final String FANSDBNAME = "u_fans";
    public static final String FRIENDSDBNAME = "u_friends";
    private MongoDatabase friendsDB;
    @Autowired
    private AuthKeysServiceImpl authKeysService;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Friends> getEntityClass() {
        return Friends.class;
    }

    @Override
    public String getCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public String getFansCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public String getNewFriendCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    public MongoCollection<Document> getNewFriendCollection(int userId) {
        String collectionName = this.getNewFriendCollectionName(userId);
        MongoDatabase database = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(NEWFIREND);
        return database.getCollection(collectionName);
    }

    public long getFriendCount() {
        long count = 0L;
        MongoIterable listCollectionNames = this.friendsDB.listCollectionNames();
        for (String string : listCollectionNames) {
            count += this.friendsDB.getCollection(string).count();
        }
        return count;
    }

    public MongoCollection<DBObject> getDBObjectCollection(int userId) {
        String collectionName = this.getCollectionName(userId);
        if (null == this.friendsDB) {
            this.friendsDB = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(FRIENDSDBNAME);
        }
        return this.friendsDB.getCollection(collectionName, DBObject.class);
    }

    public MongoCollection<Document> getCollection(int userId) {
        String collectionName = this.getCollectionName(userId);
        if (null == this.friendsDB) {
            this.friendsDB = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(FRIENDSDBNAME);
        }
        return this.friendsDB.getCollection(collectionName);
    }

    public MongoCollection<DBObject> getFriendsMongoCollection(int userId) {
        return this.getDBObjectCollection(userId);
    }

    private static FriendsRepositoryImpl getFriendsRepository() {
        FriendsRepositoryImpl getFriendsRepository = SKBeanUtils.getFriendsRepository();
        return getFriendsRepository;
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    private RedisServiceImpl getRedisServiceImpl() {
        return SKBeanUtils.getRedisService();
    }

    @Override
    public Friends addBlacklist(Integer userId, Integer toUserId) {
        Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
        Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
        if (null == friendsAB) {
            Friends friends = new Friends((int)userId, (int)toUserId, FriendsManagerImpl.getUserManager().getNickName(toUserId), (Integer)0, (Integer)1, 0);
            FriendsManagerImpl.getFriendsRepository().saveFriends(friends);
        } else {
            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, null, (Integer)-1, (Integer)1, 0 == friendsAB.getIsBeenBlack() ? 0 : friendsAB.getIsBeenBlack()));
            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)userId, null, null, (Integer)(0 == friendsBA.getBlacklist() ? 0 : friendsBA.getBlacklist()), 1));
        }
        SKBeanUtils.getTigaseManager().deleteLastMsg(userId, toUserId.toString());
        this.deleteFriendsInfo(userId, toUserId);
        this.updateOfflineOperation(userId, toUserId);
        return FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
    }

    private void deleteAddressFriendsInfo(Integer userId, Integer toUserId) {
        this.getRedisServiceImpl().delAddressBookFriendsUserIds(userId);
        this.getRedisServiceImpl().delAddressBookFriendsUserIds(toUserId);
        this.deleteFriendsInfo(userId, toUserId);
    }

    private void deleteFriendsInfo(Integer userId, Integer toUserId) {
        this.getRedisServiceImpl().deleteFriendsUserIdsList(userId);
        this.getRedisServiceImpl().deleteFriendsUserIdsList(toUserId);
        this.getRedisServiceImpl().deleteFriends(userId);
        this.getRedisServiceImpl().deleteFriends(toUserId);
    }

    public Friends consoleAddBlacklist(final Integer userId, final Integer toUserId, int adminUserId) {
        Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
        Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
        if (null == friendsAB) {
            Friends friends = new Friends((int)userId, (int)toUserId, FriendsManagerImpl.getUserManager().getNickName(toUserId), (Integer)0, (Integer)1, 0);
            FriendsManagerImpl.getFriendsRepository().saveFriends(friends);
        } else {
            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, null, (Integer)-1, (Integer)1, 0 == friendsAB.getIsBeenBlack() ? 0 : friendsAB.getIsBeenBlack()));
            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)userId, null, null, (Integer)(0 == friendsBA.getBlacklist() ? 0 : friendsBA.getBlacklist()), 1));
        }
        SKBeanUtils.getTigaseManager().deleteLastMsg(userId, toUserId.toString());
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(513);
                messageBean.setFromUserId("10005");
                messageBean.setFromUserName("\u540e\u53f0\u7cfb\u7edf\u7ba1\u7406\u5458");
                KXMPPServiceImpl.MessageBean beanVo = new KXMPPServiceImpl.MessageBean();
                beanVo.setFromUserId(userId + "");
                beanVo.setFromUserName(FriendsManagerImpl.getUserManager().getNickName(userId));
                beanVo.setToUserId(toUserId + "");
                beanVo.setToUserName(FriendsManagerImpl.getUserManager().getNickName(toUserId));
                messageBean.setObjectId(JSONObject.toJSONString((Object)beanVo));
                messageBean.setMessageId(StringUtil.randomUUID());
                try {
                    ArrayList<Integer> userIdlist = new ArrayList<Integer>();
                    userIdlist.add(userId);
                    userIdlist.add(toUserId);
                    KXMPPServiceImpl.getInstance().send(messageBean, userIdlist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.deleteFriendsInfo(userId, toUserId);
        this.updateOfflineOperation(userId, toUserId);
        return FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
    }

    public void updateFriends(Friends friends) {
        FriendsManagerImpl.getFriendsRepository().updateFriends(friends);
    }

    public void updateFriendsNickName(int userId, String nickName) {
        MongoDatabase database = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase(this.getCollectionName());
        MongoIterable listCollectionNames = database.listCollectionNames();
        Document query = new Document();
        query.append("toUserId", (Object)userId);
        Document update = new Document("$set", (Object)new Document("toNickname", (Object)nickName));
        MongoCollection collection = null;
        for (String string : listCollectionNames) {
            collection = database.getCollection(string);
            collection.updateMany((Bson)query, (Bson)update);
        }
    }

    public boolean isBlack(Integer toUserId) {
        Friends friends = this.getFriends((int)ReqUtil.getUserId(), toUserId);
        if (friends == null) {
            return false;
        }
        return friends.getStatus() == -1;
    }

    public boolean isBlack(Integer userId, Integer toUserId) {
        Friends friends = this.getFriends((int)userId, toUserId);
        if (friends == null) {
            return false;
        }
        return friends.getStatus() == -1;
    }

    private void saveFansCount(int userId) {
        BasicDBObject q = new BasicDBObject("_id", (Object)userId);
        DBCollection dbCollection = SKBeanUtils.getTigaseDatastore().getDB().getCollection("shiku_msgs_count");
        if (0L == dbCollection.count((DBObject)q)) {
            BasicDBObject jo = new BasicDBObject("_id", (Object)userId);
            jo.put((Object)"count", (Object)0);
            jo.put((Object)"fansCount", (Object)1);
            dbCollection.insert(new DBObject[]{jo});
        } else {
            dbCollection.update((DBObject)q, (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject("fansCount", (Object)1)));
        }
    }

    @Override
    public boolean addFriends(Integer userId, Integer toUserId) {
        Friends friends;
        int toUserType = 0;
        List<Integer> toUserRoles = SKBeanUtils.getRoleManager().getUserRoles(toUserId);
        if (toUserRoles.size() > 0 && null != toUserRoles && toUserRoles.contains(2)) {
            toUserType = 2;
        }
        int userType = 0;
        List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
        if (userRoles.size() > 0 && null != userRoles && userRoles.contains(2)) {
            userType = 2;
        }
        if (null == (friends = this.getFriends((int)userId, toUserId))) {
            FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)userId, (int)toUserId, FriendsManagerImpl.getUserManager().getNickName(toUserId), (Integer)2, (Integer)0, (Integer)0, toUserRoles, toUserType, (Integer)4));
            this.saveFansCount(toUserId);
        } else {
            this.saveFansCount(toUserId);
            friends.setStatus(2);
            friends.setToUserType(toUserType);
            friends.setToFriendsRole(userRoles);
            this.updateFriends(friends);
        }
        Friends toFriends = this.getFriends((int)toUserId, userId);
        if (null == toFriends) {
            FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)toUserId, (int)userId, FriendsManagerImpl.getUserManager().getNickName(userId), (Integer)2, (Integer)0, (Integer)0, userRoles, userType, (Integer)4));
            this.saveFansCount(toUserId);
        } else {
            this.saveFansCount(toUserId);
            this.updateFriends(new Friends((int)userId, (int)toUserId, FriendsManagerImpl.getUserManager().getNickName(toUserId), (Integer)2, (Integer)0, (Integer)0, toUserRoles, toUserType, (Integer)4));
            this.updateFriends(new Friends((int)toUserId, (int)userId, FriendsManagerImpl.getUserManager().getNickName(userId), (Integer)2, (Integer)0, (Integer)0, userRoles, userType, (Integer)4));
        }
        this.deleteFriendsInfo(userId, toUserId);
        return true;
    }

    @Override
    public Friends deleteBlacklist(Integer userId, Integer toUserId) {
        Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
        Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
        if (null != friendsAB) {
            if (1 == friendsAB.getBlacklist() && 0 == friendsAB.getStatus()) {
                FriendsManagerImpl.getFriendsRepository().deleteFriends(userId, toUserId);
            } else {
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, null, (Integer)2, (Integer)0, friendsAB.getIsBeenBlack()));
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)userId, null, friendsBA.getStatus(), (Integer)(0 == friendsBA.getBlacklist() ? 0 : friendsBA.getBlacklist()), 0));
            }
            friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
            this.deleteFriendsInfo(userId, toUserId);
            this.updateOfflineOperation(userId, toUserId);
        }
        return friendsAB;
    }

    public Friends consoleDeleteBlacklist(final Integer userId, final Integer toUserId, final int adminUserId) {
        Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
        Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
        if (null != friendsAB) {
            if (1 == friendsAB.getBlacklist() && 0 == friendsAB.getStatus()) {
                FriendsManagerImpl.getFriendsRepository().deleteFriends(userId, toUserId);
            } else {
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, null, (Integer)2, (Integer)0, 0 == friendsAB.getIsBeenBlack() ? 0 : friendsAB.getIsBeenBlack()));
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)userId, null, (Integer)(2 == friendsBA.getStatus() ? 2 : friendsBA.getStatus()), (Integer)(0 == friendsBA.getBlacklist() ? 0 : friendsBA.getBlacklist()), 0));
            }
            friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
        }
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(514);
                messageBean.setFromUserId(adminUserId + "");
                messageBean.setFromUserName("\u540e\u53f0\u7cfb\u7edf\u7ba1\u7406\u5458");
                KXMPPServiceImpl.MessageBean beanVo = new KXMPPServiceImpl.MessageBean();
                beanVo.setFromUserId(userId + "");
                beanVo.setFromUserName(FriendsManagerImpl.getUserManager().getNickName(userId));
                beanVo.setToUserId(toUserId + "");
                beanVo.setToUserName(FriendsManagerImpl.getUserManager().getNickName(toUserId));
                messageBean.setObjectId(JSONObject.toJSONString((Object)beanVo));
                messageBean.setMessageId(StringUtil.randomUUID());
                try {
                    ArrayList<Integer> userIdlist = new ArrayList<Integer>();
                    userIdlist.add(userId);
                    userIdlist.add(toUserId);
                    KXMPPServiceImpl.getInstance().send(messageBean, userIdlist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.deleteFriendsInfo(userId, toUserId);
        return friendsAB;
    }

    @Override
    public boolean deleteFriends(Integer userId, Integer toUserId) {
        FriendsManagerImpl.getFriendsRepository().deleteFriends(userId, toUserId);
        FriendsManagerImpl.getFriendsRepository().deleteFriends(toUserId, userId);
        SKBeanUtils.getTigaseManager().deleteLastMsg(userId, toUserId.toString());
        SKBeanUtils.getTigaseManager().deleteLastMsg(toUserId, userId.toString());
        SKBeanUtils.getFriendGroupManager().deleteFriendToFriendGroup(userId, toUserId);
        this.deleteFriendsInfo(userId, toUserId);
        this.updateOfflineOperation(userId, toUserId);
        return true;
    }

    public boolean consoleDeleteFriends(final Integer userId, final Integer adminUserId, String ... toUserIds) {
        for (String strtoUserId : toUserIds) {
            final Integer toUserId = Integer.valueOf(strtoUserId);
            FriendsManagerImpl.getFriendsRepository().deleteFriends(userId, toUserId);
            FriendsManagerImpl.getFriendsRepository().deleteFriends(toUserId, userId);
            SKBeanUtils.getTigaseManager().deleteLastMsg(userId, toUserId.toString());
            SKBeanUtils.getTigaseManager().deleteLastMsg(toUserId, userId.toString());
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                    messageBean.setType(515);
                    messageBean.setFromUserId(adminUserId + "");
                    messageBean.setFromUserName("\u540e\u53f0\u7cfb\u7edf\u7ba1\u7406\u5458");
                    KXMPPServiceImpl.MessageBean beanVo = new KXMPPServiceImpl.MessageBean();
                    beanVo.setFromUserId(userId + "");
                    beanVo.setFromUserName(FriendsManagerImpl.getUserManager().getNickName(userId));
                    beanVo.setToUserId(toUserId + "");
                    beanVo.setToUserName(FriendsManagerImpl.getUserManager().getNickName(toUserId));
                    messageBean.setObjectId(JSONObject.toJSONString((Object)beanVo));
                    messageBean.setMessageId(StringUtil.randomUUID());
                    messageBean.setContent("\u7cfb\u7edf\u89e3\u9664\u4e86\u4f60\u4eec\u597d\u53cb\u5173\u7cfb");
                    messageBean.setMessageId(StringUtil.randomUUID());
                    try {
                        ArrayList<Integer> userIdlist = new ArrayList<Integer>();
                        userIdlist.add(userId);
                        userIdlist.add(toUserId);
                        KXMPPServiceImpl.getInstance().send(messageBean, userIdlist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FriendsManagerImpl.this.deleteFriendsInfo(userId, toUserId);
                }
            });
        }
        return true;
    }

    @Override
    public JSONMessage followUser(Integer userId, Integer toUserId, Integer fromAddType) {
        String serviceCode = "08";
        JSONMessage jMessage = null;
        User toUser = FriendsManagerImpl.getUserManager().getUser(toUserId);
        List<Integer> toUserRoles = SKBeanUtils.getRoleManager().getUserRoles(toUserId);
        if (null == toUser) {
            if (10000 == toUserId) {
                return null;
            }
            return JSONMessage.failureByErrCode(100211);
        }
        int toUserType = toUser.getUserType();
        try {
            User user = FriendsManagerImpl.getUserManager().getUser(userId);
            int userType = 0;
            List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
            if (userRoles.size() > 0 && null != userRoles && userRoles.contains(2)) {
                userType = 2;
            }
            Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
            Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
            User.UserSettings userSettingsB = FriendsManagerImpl.getUserManager().getSettings(toUserId);
            if (null != friendsAB && friendsAB.getIsBeenBlack() == 1) {
                jMessage = JSONMessage.failureByErrCode(100502);
                return jMessage;
            }
            if (null == friendsAB || 0 == friendsAB.getStatus()) {
                if (0 == userSettingsB.getAllowAtt()) {
                    jMessage = new JSONMessage(groupCode, "08", "01", "\u5173\u6ce8\u5931\u8d25\uff0c\u76ee\u6807\u7528\u6237\u62d2\u7edd\u5173\u6ce8");
                } else {
                    int statusA = 0;
                    if (1 == userSettingsB.getFriendsVerify() && 2 != toUserType) {
                        if (null == friendsBA || 0 == friendsBA.getStatus()) {
                            statusA = 1;
                        } else {
                            statusA = 2;
                            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(toUserId, user.getUserId(), user.getNickname(), 2));
                        }
                    } else {
                        statusA = 2;
                        if (null == friendsBA) {
                            FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, userType, fromAddType));
                            this.saveFansCount(toUserId);
                        } else {
                            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)userType, userRoles));
                        }
                    }
                    if (null == friendsAB) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), (Integer)statusA, (Integer)0, (Integer)0, toUserRoles, toUserType, fromAddType));
                        this.saveFansCount(toUserId);
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), (Integer)statusA, (Integer)0, 0));
                    }
                    if (statusA == 1) {
                        HashMap<String, Object> newMap = MapUtil.newMap("type", 1);
                        newMap.put("fromAddType", fromAddType);
                        jMessage = JSONMessage.success(100514, newMap);
                    } else {
                        HashMap<String, Object> newMap = MapUtil.newMap("type", 2);
                        newMap.put("fromAddType", fromAddType);
                        jMessage = JSONMessage.success(100515, newMap);
                    }
                }
            } else if (0 == friendsAB.getBlacklist()) {
                if (1 == friendsAB.getStatus()) {
                    if (0 == userSettingsB.getFriendsVerify()) {
                        Integer statusA = 2;
                        if (null == friendsBA) {
                            FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, userType, fromAddType));
                            this.saveFansCount(toUserId);
                        } else {
                            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(toUserId, user.getUserId(), user.getNickname(), 2));
                        }
                        if (null == friendsAB) {
                            FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), statusA, (Integer)0, (Integer)0, toUserRoles, toUserType, fromAddType));
                            this.saveFansCount(toUserId);
                        } else {
                            FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), statusA, (Integer)0, 0));
                        }
                        HashMap<String, Object> newMap = MapUtil.newMap("type", 2);
                        newMap.put("fromAddType", fromAddType);
                        jMessage = JSONMessage.success(100515, newMap);
                    } else if (1 == userSettingsB.getFriendsVerify()) {
                        HashMap<String, Object> newMap = MapUtil.newMap("type", 1);
                        newMap.put("fromAddType", fromAddType);
                        jMessage = JSONMessage.success(100514, newMap);
                    }
                } else {
                    HashMap<String, Object> newMap = MapUtil.newMap("type", 2);
                    newMap.put("fromAddType", fromAddType);
                    jMessage = JSONMessage.success(100515, newMap);
                }
            } else {
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(userId, toUserId, toUser.getNickname(), 0));
                jMessage = null;
            }
            this.deleteFriendsInfo(userId, toUserId);
            this.updateOfflineOperation(userId, toUserId);
        }
        catch (Exception e) {
            Log.error("\u5173\u6ce8\u5931\u8d25", (Throwable)e);
            jMessage = JSONMessage.failureByErrCode(100516);
        }
        return jMessage;
    }

    public void updateOfflineOperation(Integer userId, Integer toUserId) {
        Query query = (Query)((Query)((Query)this.getDatastore().createQuery(OfflineOperation.class).field("userId").equal((Object)userId)).field("tag").equal((Object)"friend")).field("friendId").equal((Object)String.valueOf(toUserId));
        if (null == query.get()) {
            this.getDatastore().save((Object)new OfflineOperation(userId, "friend", String.valueOf(toUserId), DateUtil.currentTimeSeconds()));
        } else {
            UpdateOperations ops = this.getDatastore().createUpdateOperations(OfflineOperation.class);
            ops.set("operationTime", (Object)DateUtil.currentTimeSeconds());
            this.getDatastore().update(query, ops);
        }
    }

    @Override
    public JSONMessage batchFollowUser(Integer userId, String toUserIds) {
        JSONMessage jMessage = null;
        if (StringUtil.isEmpty(toUserIds)) {
            return null;
        }
        int[] toUserId = StringUtil.getIntArray(toUserIds, ",");
        for (int i = 0; i < toUserId.length; ++i) {
            User toUser;
            if (userId == toUserId[i] || 10000 == toUserId[i] || null == (toUser = FriendsManagerImpl.getUserManager().getUser(toUserId[i]))) continue;
            List<Integer> toUserRoles = SKBeanUtils.getRoleManager().getUserRoles(toUserId[i]);
            int toUserType = toUser.getUserType();
            try {
                User user = FriendsManagerImpl.getUserManager().getUser(userId);
                int userType = 0;
                List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
                if (userRoles.size() > 0 && null != userRoles && userRoles.contains(2)) {
                    userType = 2;
                }
                Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId[i]);
                Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId[i], userId);
                User.UserSettings userSettingsB = FriendsManagerImpl.getUserManager().getSettings(toUserId[i]);
                if (null != friendsAB && friendsAB.getIsBeenBlack() == 1) {
                    throw new ServiceException(100517);
                }
                if (null == friendsAB || 0 == friendsAB.getStatus()) {
                    if (0 == userSettingsB.getAllowAtt()) continue;
                    int statusA = 0;
                    statusA = 2;
                    if (null == friendsBA) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends(toUserId[i], (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, userType, (Integer)4));
                        this.saveFansCount(toUserId[i]);
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(toUserId[i], user.getUserId(), user.getNickname(), 2));
                    }
                    if (null == friendsAB) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)userId, toUserId[i], toUser.getNickname(), (Integer)statusA, (Integer)0, (Integer)0, toUserRoles, toUserType, (Integer)4));
                        this.saveFansCount(toUserId[i]);
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, toUserId[i], toUser.getNickname(), (Integer)statusA, (Integer)0, 0));
                    }
                } else if (0 == friendsAB.getBlacklist()) {
                    if (1 == friendsAB.getStatus()) {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, toUserId[i], toUser.getNickname(), (Integer)2, (Integer)toUserType, toUserRoles));
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends(toUserId[i], (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, "", userType));
                    }
                } else {
                    FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(userId, toUserId[i], toUser.getNickname(), 0));
                    jMessage = null;
                }
                this.notify(userId, toUserId[i]);
                jMessage = JSONMessage.success();
                this.deleteAddressFriendsInfo(userId, toUserId[i]);
                this.updateOfflineOperation(userId, toUserId[i]);
                continue;
            }
            catch (Exception e) {
                Log.error("\u901a\u8baf\u5f55\u6dfb\u52a0\u597d\u53cb\u5931\u8d25", (Object)e.getMessage());
                jMessage = JSONMessage.failureByException(e);
            }
        }
        return jMessage;
    }

    public JSONMessage autofollowUser(Integer userId, Map<String, String> addressBook) {
        String serviceCode = "08";
        Integer toUserId = Integer.valueOf(addressBook.get("toUserId"));
        String toRemark = addressBook.get("toRemark");
        JSONMessage jMessage = null;
        User toUser = FriendsManagerImpl.getUserManager().getUser(toUserId);
        if (null == toUser) {
            return null;
        }
        int toUserType = toUser.getUserType();
        List<Integer> toUserRoles = SKBeanUtils.getRoleManager().getUserRoles(toUserId);
        if (10000 == toUser.getUserId()) {
            return null;
        }
        try {
            User user = FriendsManagerImpl.getUserManager().getUser(userId);
            int userType = 0;
            List<Integer> userRoles = SKBeanUtils.getRoleManager().getUserRoles(userId);
            if (userRoles.size() > 0 && null != userRoles && userRoles.contains(2)) {
                userType = 2;
            }
            Friends friendsAB = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
            Friends friendsBA = FriendsManagerImpl.getFriendsRepository().getFriends(toUserId, userId);
            User.UserSettings userSettingsB = FriendsManagerImpl.getUserManager().getSettings(toUserId);
            if (null != friendsAB && friendsAB.getIsBeenBlack() == 1) {
                jMessage = JSONMessage.failureByErrCode(100502);
                return jMessage;
            }
            if (null == friendsAB || 0 == friendsAB.getStatus()) {
                if (0 == userSettingsB.getAllowAtt()) {
                    jMessage = JSONMessage.failureByErrCode(100516);
                } else {
                    int statusA = 0;
                    statusA = 2;
                    if (null == friendsBA) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, "", userType));
                        this.saveFansCount(toUserId);
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(toUserId, user.getUserId(), user.getNickname(), 2));
                    }
                    if (null == friendsAB) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), (Integer)statusA, (Integer)0, (Integer)0, toUserRoles, toRemark, toUserType));
                        this.saveFansCount(toUserId);
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), (Integer)statusA, (Integer)0, 0));
                    }
                }
            } else if (0 == friendsAB.getBlacklist()) {
                if (1 == friendsAB.getStatus()) {
                    FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)userId, (int)toUserId, toUser.getNickname(), (Integer)2, (Integer)toUserType, toUserRoles));
                    if (null == friendsBA) {
                        FriendsManagerImpl.getFriendsRepository().saveFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, "", userType));
                    } else {
                        FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends((int)toUserId, (int)user.getUserId(), user.getNickname(), (Integer)2, (Integer)0, (Integer)0, userRoles, "", userType));
                    }
                }
            } else {
                FriendsManagerImpl.getFriendsRepository().updateFriends(new Friends(userId, toUserId, toUser.getNickname(), 0));
                jMessage = null;
            }
            this.notify(userId, toUserId);
            this.deleteFriendsInfo(userId, toUserId);
            jMessage = JSONMessage.success();
        }
        catch (Exception e) {
            Log.error("\u5173\u6ce8\u5931\u8d25", (Throwable)e);
            jMessage = JSONMessage.failureByErrCode(100516);
        }
        return jMessage;
    }

    public void notify(final Integer userId, final Integer toUserId) {
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(510);
                messageBean.setFromUserId(String.valueOf(userId));
                messageBean.setFromUserName(SKBeanUtils.getUserManager().getNickName(userId));
                messageBean.setToUserId(String.valueOf(toUserId));
                messageBean.setToUserName(SKBeanUtils.getUserManager().getNickName(toUserId));
                messageBean.setContent(toUserId);
                messageBean.setMsgType(0);
                messageBean.setMessageId(StringUtil.randomUUID());
                try {
                    KXMPPServiceImpl.getInstance().send(messageBean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public Friends getFriends(int userId, int toUserId) {
        return FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
    }

    public void getFriends(int userId, String ... toUserIds) {
        for (String strToUserId : toUserIds) {
            Integer toUserId = Integer.valueOf(strToUserId);
            Friends friends = FriendsManagerImpl.getFriendsRepository().getFriends(userId, toUserId);
            if (null != friends) continue;
            throw new ServiceException(100510);
        }
    }

    public List<Friends> getFansList(Integer userId) {
        List result = this.getEntityListsByKey("userId", userId);
        result.forEach(friends -> {
            User user = FriendsManagerImpl.getUserManager().getUser(friends.getToUserId());
            if (null == user) {
                return;
            }
            friends.setToNickname(user.getNickname());
        });
        return result;
    }

    @Override
    public Friends getFriends(Friends p) {
        return FriendsManagerImpl.getFriendsRepository().getFriends(p.getUserId(), p.getToUserId());
    }

    @Override
    public List<Integer> getFriendsIdList(int userId) {
        ArrayList result = Lists.newArrayList();
        try {
            List<Friends> friendsList = FriendsManagerImpl.getFriendsRepository().queryFriends(userId);
            friendsList.forEach(friends -> result.add(friends.getToUserId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<Friends> queryBlacklist(Integer userId, int pageIndex, int pageSize) {
        return FriendsManagerImpl.getFriendsRepository().queryBlacklist(userId, pageIndex, pageSize);
    }

    public PageVO queryBlacklistWeb(Integer userId, int pageIndex, int pageSize) {
        return FriendsManagerImpl.getFriendsRepository().queryBlacklistWeb(userId, pageIndex, pageSize);
    }

    @Override
    public List<Integer> queryFansId(Integer userId) {
        return FriendsManagerImpl.getFriendsRepository().queryFansId(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFriendIsNoPushMsg(Integer userId, Integer toUserId) {
        MongoCursor iterator = this.getDBObjectCollection(userId).find((Bson)new Document("userId", (Object)userId).append("toUserId", (Object)toUserId).append("offlineNoPushMsg", (Object)1)).iterator();
        DBObject dbObject = null;
        try {
            while (iterator.hasNext()) {
                dbObject = (DBObject)iterator.next();
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return null != dbObject;
    }

    @Override
    public List<Friends> queryFollow(Integer userId, int status) {
        List<Friends> userfriends = SKBeanUtils.getRedisService().getFriendsList(userId);
        if (null != userfriends && userfriends.size() > 0) {
            return userfriends;
        }
        if (0 == status) {
            status = 2;
        }
        List<Friends> result = FriendsManagerImpl.getFriendsRepository().queryFollow(userId, status);
        Iterator<Friends> iter = result.iterator();
        while (iter.hasNext()) {
            Friends friends = iter.next();
            User user = FriendsManagerImpl.getUserManager().getUser(friends.getToUserId());
            if (null == user) {
                iter.remove();
                this.deleteFansAndFriends(friends.getToUserId());
                this.deleteFriends(userId, friends.getToUserId());
                continue;
            }
            AuthKeys authks = this.authKeysService.getAuthKeys(user.getUserId());
            if (authks != null) {
                friends.setDhMsgPublicKey(authks.getMsgDHKeyPair() != null ? authks.getMsgDHKeyPair().getPublicKey() : "");
                friends.setRsaMsgPublicKey(authks.getMsgRsaKeyPair() != null ? authks.getMsgRsaKeyPair().getPublicKey() : "");
            }
            friends.setToNickname(user.getNickname());
        }
        SKBeanUtils.getRedisService().saveFriendsList(userId, result);
        return result;
    }

    public PageResult<Friends> consoleQueryFollow(Integer userId, Integer toUserId, int status, int page, int limit) throws IllegalAccessException, InvocationTargetException {
        PageResult<Object> result = new PageResult();
        result = FriendsManagerImpl.getFriendsRepository().consoleQueryFollow(userId, toUserId, status, page, limit);
        Iterator<Object> iter = result.getData().iterator();
        while (iter.hasNext()) {
            Friends friends = (Friends)iter.next();
            User user = null;
            try {
                user = FriendsManagerImpl.getUserManager().getUser(friends.getToUserId());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                continue;
            }
            friends.setNickname(FriendsManagerImpl.getUserManager().getNickName(userId));
            if (null == user) {
                iter.remove();
                this.deleteFansAndFriends(friends.getToUserId());
                continue;
            }
            friends.setToNickname(user.getNickname());
        }
        return result;
    }

    @Override
    public List<Integer> queryFollowId(Integer userId) {
        return FriendsManagerImpl.getFriendsRepository().queryFollowId(userId);
    }

    @Override
    public List<Friends> queryFriends(Integer userId) {
        List<Friends> result = FriendsManagerImpl.getFriendsRepository().queryFriends(userId);
        for (Friends friends : result) {
            User toUser = FriendsManagerImpl.getUserManager().getUser(friends.getToUserId());
            if (null == toUser) {
                this.deleteFansAndFriends(friends.getToUserId());
                continue;
            }
            friends.setToNickname(toUser.getNickname());
        }
        return result;
    }

    @Override
    public List<Integer> friendsAndAttentionUserId(Integer userId, String type) {
        List<Object> result = new ArrayList();
        if (!"friendList".equals(type) && !"blackList".equals(type)) {
            throw new ServiceException(1010101);
        }
        result = FriendsManagerImpl.getFriendsRepository().friendsOrBlackList(userId, type);
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        for (Friends friends : result) {
            userIds.add(friends.getToUserId());
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageVO queryFriends(Integer userId, int status, String keyword, int pageIndex, int pageSize) {
        ArrayList<Friends> friendList;
        long count;
        block11: {
            Document document = new Document("userId", (Object)userId);
            if (0 < status) {
                document.append("status", (Object)status);
            }
            if (!StringUtil.isEmpty(keyword)) {
                Pattern pattern = Pattern.compile("^.*" + keyword + ".*$", 2);
                ArrayList<Document> documents = new ArrayList<Document>();
                documents.add(new Document("toNickname", (Object)pattern));
                documents.add(new Document("remarkName", (Object)pattern));
                document.append("$or", documents);
            }
            MongoCollection<DBObject> friendsCollection = this.getFriendsMongoCollection(userId);
            count = friendsCollection.count((Bson)document);
            friendList = new ArrayList<Friends>();
            MongoCursor iterator = this.getFriendsMongoCollection(userId).find((Bson)document).skip(pageIndex * pageSize).limit(pageSize).iterator();
            block5: while (true) {
                while (iterator.hasNext()) {
                    DBObject dbObject = (DBObject)iterator.next();
                    try {
                        Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                        if (null == friends) continue block5;
                        AuthKeys authks = this.authKeysService.getAuthKeys(friends.getToUserId());
                        if (authks != null) {
                            friends.setDhMsgPublicKey(authks.getMsgDHKeyPair() != null ? authks.getMsgDHKeyPair().getPublicKey() : "");
                            friends.setRsaMsgPublicKey(authks.getMsgRsaKeyPair() != null ? authks.getMsgRsaKeyPair().getPublicKey() : "");
                        }
                        friendList.add(friends);
                        continue block5;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block11;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (null != iterator) {
                    iterator.close();
                }
            }
        }
        PageVO pageVO = new PageVO(friendList, count, pageIndex, pageSize);
        return pageVO;
    }

    public List<Friends> queryFriendsList(Integer userId, int status, int pageIndex, int pageSize) {
        ArrayList<Friends> friendList = new ArrayList<Friends>();
        Document document = new Document("userId", (Object)userId);
        if (0 < status) {
            document.append("status", (Object)status);
        }
        for (DBObject dbObject : this.getFriendsMongoCollection(userId).find((Bson)document).skip(pageIndex * pageSize).limit(pageSize)) {
            try {
                Friends friends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
                friendList.add(friends);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return friendList;
    }

    @Override
    public boolean unfollowUser(Integer userId, Integer toUserId) {
        FriendsManagerImpl.getFriendsRepository().deleteFriends(userId, toUserId);
        this.updateOfflineOperation(userId, toUserId);
        return true;
    }

    @Override
    public Friends updateRemark(int userId, int toUserId, String remarkName, String describe) {
        return FriendsManagerImpl.getFriendsRepository().updateFriendRemarkName(userId, toUserId, remarkName, describe);
    }

    @Override
    public void deleteFansAndFriends(int userId) {
        FriendsManagerImpl.getFriendsRepository().deleteFriends(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> newFriendList(int userId, int pageIndex, int pageSize) {
        MongoCollection<Document> collection = this.getNewFriendCollection(userId);
        ArrayList result = Lists.newArrayList();
        Document query = new Document("userId", (Object)String.valueOf(userId));
        MongoCursor cursor = collection.find((Bson)query).sort((Bson)new Document("modifyTime", (Object)-1)).skip(pageIndex * pageSize).limit(pageSize).iterator();
        Friends friends = null;
        Document newFriends = null;
        Integer toUserId = 0;
        try {
            while (cursor.hasNext()) {
                newFriends = (Document)cursor.next();
                toUserId = Integer.valueOf(newFriends.getString((Object)"toUserId"));
                friends = this.getFriends((int)Integer.valueOf(newFriends.getString((Object)"userId")), toUserId);
                newFriends.put("toNickname", (Object)FriendsManagerImpl.getUserManager().getNickName(toUserId));
                if (null != friends) {
                    newFriends.put("status", (Object)friends.getStatus());
                }
                result.add(newFriends);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageVO newFriendListWeb(int userId, int pageIndex, int pageSize) {
        MongoCollection<Document> collection = this.getNewFriendCollection(userId);
        ArrayList result = Lists.newArrayList();
        Document query = new Document("userId", (Object)String.valueOf(userId));
        MongoCursor cursor = collection.find((Bson)query).sort((Bson)new Document("modifyTime", (Object)-1)).skip(pageIndex * pageSize).limit(pageSize).iterator();
        Friends friends = null;
        Document newFriends = null;
        Integer toUserId = 0;
        try {
            while (cursor.hasNext()) {
                newFriends = (Document)cursor.next();
                toUserId = Integer.valueOf(newFriends.getString((Object)"toUserId"));
                friends = this.getFriends((int)Integer.valueOf(newFriends.getString((Object)"userId")), toUserId);
                newFriends.put("toNickname", (Object)FriendsManagerImpl.getUserManager().getNickName(toUserId));
                if (null != friends) {
                    newFriends.put("status", (Object)friends.getStatus());
                }
                result.add(newFriends);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        long count = collection.count((Bson)query);
        return new PageVO(result, count, pageIndex, pageSize);
    }

    @Override
    public Friends updateOfflineNoPushMsg(int userId, int toUserId, int offlineNoPushMsg, int type) {
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
        options.returnDocument(ReturnDocument.AFTER);
        Document value = null;
        DBObject dbObject = null;
        Friends rFriends = null;
        switch (type) {
            case 0: {
                value = new Document("offlineNoPushMsg", (Object)offlineNoPushMsg);
                break;
            }
            case 1: {
                value = new Document("isOpenSnapchat", (Object)offlineNoPushMsg);
                break;
            }
            case 2: {
                value = new Document("openTopChatTime", (Object)offlineNoPushMsg);
                break;
            }
        }
        if (null == value) {
            return null;
        }
        dbObject = (DBObject)this.getDBObjectCollection(userId).findOneAndUpdate((Bson)new Document("userId", (Object)userId).append("toUserId", (Object)toUserId), (Bson)new Document("$set", (Object)value), options);
        if (FriendsManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
            FriendsManagerImpl.getUserManager().multipointLoginUpdateUserInfo(userId, FriendsManagerImpl.getUserManager().getNickName(userId), toUserId, FriendsManagerImpl.getUserManager().getNickName(toUserId), 1);
        }
        try {
            rFriends = DocumentToJavaBean.dbObject2Bean(dbObject, new Friends());
            System.out.println("new Friends ====== > " + JSONObject.toJSONString((Object)rFriends));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rFriends;
    }

    public List<Object> getAddFriendsCount(String startDate, String endDate, short timeUnit) {
        ArrayList<Object> countData = new ArrayList();
        long startTime = 0L;
        long endTime = 0L;
        long defStartTime = timeUnit == 4 ? DateUtil.getTodayMorning().getTime() / 1000L : (timeUnit == 3 ? DateUtil.getLastMonth().getTime() / 1000L : DateUtil.getLastYear().getTime() / 1000L);
        startTime = StringUtil.isEmpty(startDate) ? defStartTime : DateUtil.toDate(startDate).getTime() / 1000L;
        endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
        BasicDBObject queryTime = new BasicDBObject("$ne", null);
        if (startTime != 0L && endTime != 0L) {
            queryTime.append("$gt", (Object)startTime);
            queryTime.append("$lt", (Object)endTime);
        }
        BasicDBObject query = new BasicDBObject("createTime", (Object)queryTime);
        DB db = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDB(this.getCollectionName());
        List collectionList = this.getCollectionList();
        HashMap<String, Double> map = new HashMap<String, Double>();
        String mapStr = "function Map() { var date = new Date(this.createTime*1000);var year = date.getFullYear();var month = (\"0\" + (date.getMonth()+1)).slice(-2);var day = (\"0\" + date.getDate()).slice(-2);var hour = (\"0\" + date.getHours()).slice(-2);var minute = (\"0\" + date.getMinutes()).slice(-2);var dateStr = date.getFullYear()+'-'+(parseInt(date.getMonth())+1)+'-'+date.getDate();";
        if (timeUnit == 1) {
            mapStr = mapStr + "var key= year + '-'+ month;";
        } else if (timeUnit == 2) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day;";
        } else if (timeUnit == 3) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour +' : 00';";
        } else if (timeUnit == 4) {
            mapStr = mapStr + "var key= year + '-'+ month + '-' + day + '  ' + hour + ':'+ minute;";
        }
        mapStr = mapStr + "emit(key,1);}";
        String reduce = "function Reduce(key, values) {return Array.sum(values);}";
        for (String str : collectionList) {
            DBCollection collection = db.getCollection(str);
            MapReduceCommand.OutputType type = MapReduceCommand.OutputType.INLINE;
            MapReduceCommand command = new MapReduceCommand(collection, mapStr, reduce, null, type, (DBObject)query);
            MapReduceOutput mapReduceOutput = collection.mapReduce(command);
            Iterable results = mapReduceOutput.results();
            Double value = null;
            String id = null;
            for (DBObject obj : results) {
                id = (String)obj.get("_id");
                value = (Double)obj.get("value");
                if (null != map.get(id)) {
                    map.put(id, (Double)map.get(id) + value);
                    continue;
                }
                map.put(id, value);
            }
        }
        countData = map.entrySet().stream().collect(Collectors.toList());
        map.clear();
        return countData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<Document> chardRecord(Integer sender, Integer receiver, Integer page, Integer limit) {
        MongoDatabase database = SKBeanUtils.getTigaseManager().getChatMsgDB();
        MongoCollection<Document> collection = this.getMongoCollection(database, sender);
        Document query = new Document();
        ArrayList<Document> queryOr = new ArrayList<Document>();
        if (0 != sender) {
            queryOr.add(new Document("sender", (Object)sender.toString()).append("receiver", (Object)receiver.toString()).append("direction", (Object)0));
        }
        if (0 != receiver) {
            queryOr.add(new Document("sender", (Object)receiver.toString()).append("receiver", (Object)sender.toString()).append("direction", (Object)0));
        }
        query.append("$or", queryOr);
        long total = collection.count((Bson)query);
        ArrayList pageData = Lists.newArrayList();
        MongoCursor iterator = collection.find((Bson)query).sort((Bson)new Document("_id", (Object)-1)).skip((page - 1) * limit).limit(limit.intValue()).iterator();
        PageResult<Document> result = new PageResult<Document>();
        try {
            while (iterator.hasNext()) {
                Document dbObj = (Document)iterator.next();
                JSONObject body = JSONObject.parseObject((String)dbObj.getString((Object)"message"));
                if (null != body.getBoolean("isEncrypt") && body.getBoolean("isEncrypt").booleanValue()) {
                    dbObj.put("isEncrypt", (Object)1);
                } else {
                    dbObj.put("isEncrypt", (Object)0);
                }
                try {
                    dbObj.put("sender_nickname", (Object)FriendsManagerImpl.getUserManager().getNickName(Integer.valueOf(dbObj.getString((Object)"sender"))));
                }
                catch (Exception e) {
                    dbObj.put("sender_nickname", (Object)"\u672a\u77e5");
                }
                try {
                    dbObj.put("receiver_nickname", (Object)FriendsManagerImpl.getUserManager().getNickName(Integer.valueOf(dbObj.getString((Object)"receiver"))));
                }
                catch (Exception e) {
                    dbObj.put("receiver_nickname", (Object)"\u672a\u77e5");
                }
                try {
                    dbObj.put("content", dbObj.get((Object)"content"));
                }
                catch (Exception e) {
                    dbObj.put("content", (Object)"--");
                }
                pageData.add(dbObj);
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        result.setData(pageData);
        result.setCount(total);
        return result;
    }

    public void delFriendsChatRecord(int sender, String ... messageIds) {
        MongoDatabase database = SKBeanUtils.getTigaseManager().getChatMsgDB();
        MongoCollection<Document> dbCollection = SKBeanUtils.getTigaseManager().getMongoCollection(database, sender);
        for (String messageId : messageIds) {
            Document query = new Document();
            query.put("messageId", (Object)messageId);
            dbCollection.deleteMany((Bson)query);
        }
    }

    public Workbook exprotExcelFriends(Integer userId, HttpServletRequest request, HttpServletResponse response) {
        String name = FriendsManagerImpl.getUserManager().getNickName(userId) + "\u7684\u597d\u53cb\u660e\u7ec6";
        String fileName = "friends.xlsx";
        List<Friends> friendsList = SKBeanUtils.getRedisService().getFriendsList(userId);
        List<Friends> friends = null != friendsList && friendsList.size() > 0 ? friendsList : SKBeanUtils.getFriendsRepository().allFriendsInfo(userId);
        ArrayList titles = Lists.newArrayList();
        titles.add("toUserId");
        titles.add("toNickname");
        titles.add("remarkName");
        titles.add("telephone");
        titles.add("status");
        titles.add("blacklist");
        titles.add("isBeenBlack");
        titles.add("offlineNoPushMsg");
        titles.add("createTime");
        ArrayList values = Lists.newArrayList();
        for (Friends friend : friends) {
            if (10000 == friend.getToUserId()) continue;
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("toUserId", friend.getToUserId());
            map.put("toNickname", friend.getToNickname());
            map.put("telephone", FriendsManagerImpl.getUserManager().getUser(friend.getToUserId()).getPhone());
            map.put("status", friend.getStatus() == -1 ? "\u9ed1\u540d\u5355" : (friend.getStatus() == 2 ? "\u597d\u53cb" : "\u5173\u6ce8"));
            map.put("blacklist", friend.getBlacklist() == 1 ? "\u662f" : "\u5426");
            map.put("isBeenBlack", friend.getIsBeenBlack() == 1 ? "\u662f" : "\u5426");
            map.put("offlineNoPushMsg", friend.getBlacklist() == 1 ? "\u662f" : "\u5426");
            map.put("createTime", DateUtil.strToDateTime(friend.getCreateTime()));
            values.add(map);
        }
        Workbook workBook = ExcelUtil.generateWorkbook(name, "xlsx", titles, values);
        response.reset();
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return workBook;
    }

    public boolean isAddressBookOrFriends(Integer userId, Integer toUserId, int type) {
        boolean flag = false;
        switch (type) {
            case -1: {
                break;
            }
            case 1: {
                flag = !flag;
                break;
            }
            case 2: {
                List<Integer> friendsUserIdsList;
                List<Integer> allFriendsUserIdsList = SKBeanUtils.getRedisService().getFriendsUserIdsList(userId);
                if (null != allFriendsUserIdsList && allFriendsUserIdsList.size() > 0) {
                    friendsUserIdsList = allFriendsUserIdsList;
                } else {
                    List<Integer> friendsUserIdsDB = SKBeanUtils.getFriendsManager().queryFansId(userId);
                    friendsUserIdsList = friendsUserIdsDB;
                    SKBeanUtils.getRedisService().saveFriendsUserIdsList(userId, friendsUserIdsList);
                }
                flag = friendsUserIdsList.contains(toUserId);
                break;
            }
            case 3: {
                List<Integer> addressBookUserIdsList;
                List<Integer> allAddressBookUserIdsList = SKBeanUtils.getRedisService().getAddressBookFriendsUserIds(userId);
                if (null != allAddressBookUserIdsList && allAddressBookUserIdsList.size() > 0) {
                    addressBookUserIdsList = allAddressBookUserIdsList;
                } else {
                    List<Integer> AddressBookUserIdsDB = SKBeanUtils.getAddressBookManger().getAddressBookUserIds(userId);
                    addressBookUserIdsList = AddressBookUserIdsDB;
                    SKBeanUtils.getRedisService().saveAddressBookFriendsUserIds(userId, addressBookUserIdsList);
                }
                flag = addressBookUserIdsList.contains(toUserId);
                break;
            }
        }
        return flag;
    }

    public void updateToFriendUserType(int toUserId, int userType, List<Integer> roles) {
        FriendsManagerImpl.getFriendsRepository().updateToFriendUserType(toUserId, userType, roles);
    }

    public void modifyEncryptType(int userId, int toUserId, byte type) {
        SKBeanUtils.getFriendsRepository().updateFriendsEncryptType(userId, toUserId, type);
        SKBeanUtils.getRedisService().deleteFriends(userId);
    }
}

