/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.FriendGroup;
import cn.xyz.mianshi.vo.OfflineOperation;
import cn.xyz.repository.mongo.MongoRepository;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.springframework.stereotype.Service;

@Service
public class FriendGroupManagerImpl
extends MongoRepository<FriendGroup, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<FriendGroup> getEntityClass() {
        return FriendGroup.class;
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    public void autoCreateGroup(Integer userId) {
        FriendGroup group = new FriendGroup();
        group.setUserId(userId);
        group.setGroupName("\u5bb6\u4eba");
        FriendGroup group1 = new FriendGroup();
        group1.setUserId(userId);
        group1.setGroupName("\u540c\u4e8b");
        this.saveGroup(group);
        this.saveGroup(group1);
    }

    public FriendGroup saveGroup(FriendGroup group) {
        if (null == group.getGroupId()) {
            group.setCreateTime(DateUtil.currentTimeSeconds());
            group.setGroupId(new ObjectId());
            this.save(group);
        } else {
            this.update((Serializable)group.getGroupId(), group);
        }
        int userId = group.getUserId();
        if (FriendGroupManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
            this.multipointLoginUpdateFriendsGroup(userId, FriendGroupManagerImpl.getUserManager().getNickName(userId));
        }
        return group;
    }

    public void multipointLoginUpdateFriendsGroup(Integer userId, String nickName) {
        Datastore datastore = SKBeanUtils.getDatastore();
        FriendGroupManagerImpl.getUserManager().multipointLoginDataSync(userId, nickName, "sync_label");
        Query query = (Query)datastore.createQuery(OfflineOperation.class).field("userId").equal((Object)userId);
        ((Query)query.field("friendId").equal((Object)String.valueOf(userId))).field("tag").equal((Object)"label");
        if (null == query.get()) {
            datastore.save((Object)new OfflineOperation(userId, "label", String.valueOf(userId), DateUtil.currentTimeSeconds()));
        } else {
            UpdateOperations ops = datastore.createUpdateOperations(OfflineOperation.class);
            ops.set("operationTime", (Object)DateUtil.currentTimeSeconds());
            datastore.update(query, ops);
        }
    }

    public FriendGroup queryGroupName(Integer userId, String groupName) {
        Query query = this.createQuery();
        query.filter("userId", (Object)userId);
        query.filter("groupName", (Object)groupName);
        return (FriendGroup)query.get();
    }

    public void updateGroupName(Integer userId, ObjectId groupId, String groupName) throws ServerException {
        this.updateAttributeByIdAndKey((Serializable)groupId, "groupName", groupName);
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("groupId").equal((Object)groupId)).field("userId").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("groupName", (Object)groupName);
        UpdateResults update = this.getDatastore().update(query, ops);
        if (update.getUpdatedCount() > 0) {
            if (FriendGroupManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
                this.multipointLoginUpdateFriendsGroup(userId, FriendGroupManagerImpl.getUserManager().getNickName(userId));
            }
        } else {
            throw new ServiceException(100702);
        }
    }

    public void updateFriendGroup(int userId, final Integer toUserId, final List<String> groupIdStrList) throws ServiceException {
        try {
            Query query = this.createQuery();
            query.filter("userId", (Object)userId);
            final List groupList = query.asList();
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    ArrayList<ObjectId> groupIdList = new ArrayList<ObjectId>();
                    for (String str : groupIdStrList) {
                        if (StringUtil.isEmpty(str) || !ObjectId.isValid((String)str)) continue;
                        groupIdList.add(new ObjectId(str));
                    }
                    UpdateOperations ops = null;
                    for (FriendGroup friendGroup : groupList) {
                        if (!friendGroup.getUserIdList().contains(toUserId)) {
                            if (!groupIdList.contains(friendGroup.getGroupId())) continue;
                            friendGroup.getUserIdList().add(toUserId);
                            ops = FriendGroupManagerImpl.this.createUpdateOperations();
                            ops.set("userIdList", friendGroup.getUserIdList());
                            FriendGroupManagerImpl.this.updateAttributeByOps((Serializable)friendGroup.getGroupId(), ops);
                            continue;
                        }
                        if (groupIdList.contains(friendGroup.getGroupId())) continue;
                        friendGroup.getUserIdList().remove(toUserId);
                        ops = FriendGroupManagerImpl.this.createUpdateOperations();
                        ops.set("userIdList", friendGroup.getUserIdList());
                        FriendGroupManagerImpl.this.updateAttributeByOps((Serializable)friendGroup.getGroupId(), ops);
                    }
                }
            });
            if (FriendGroupManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
                this.multipointLoginUpdateFriendsGroup(userId, FriendGroupManagerImpl.getUserManager().getNickName(userId));
            }
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public void updateGroupUserList(Integer userId, ObjectId groupId, List<Integer> userIdList) throws ServerException {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("groupId").equal((Object)groupId)).field("userId").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("userIdList", userIdList);
        UpdateResults update = this.getDatastore().update(query, ops);
        if (update.getUpdatedCount() > 0) {
            if (FriendGroupManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
                this.multipointLoginUpdateFriendsGroup(userId, FriendGroupManagerImpl.getUserManager().getNickName(userId));
            }
        } else {
            throw new ServiceException(100702);
        }
    }

    public void deleteGroup(Integer userId, ObjectId groupId) throws ServerException {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("groupId").equal((Object)groupId)).field("userId").equal((Object)userId);
        WriteResult deleteByQuery = this.deleteByQuery(query);
        if (deleteByQuery.getN() > 0) {
            if (FriendGroupManagerImpl.getUserManager().isOpenMultipleDevices(userId)) {
                this.multipointLoginUpdateFriendsGroup(userId, FriendGroupManagerImpl.getUserManager().getNickName(userId));
            }
        } else {
            throw new ServiceException(100702);
        }
    }

    public List<FriendGroup> queryGroupList(long userId) {
        return this.getEntityListsByKey("userId", userId);
    }

    public void deleteFriendToFriendGroup(int userId, Integer friendId) {
        List<FriendGroup> friendGroups = this.queryGroupList(userId);
        if (null == friendGroups && 0 == friendGroups.size()) {
            return;
        }
        friendGroups.forEach(friendGroup -> {
            if (friendGroup.getUserIdList().contains(friendId)) {
                friendGroup.getUserIdList().remove(friendId);
                try {
                    this.updateGroupUserList(userId, friendGroup.getGroupId(), friendGroup.getUserIdList());
                }
                catch (ServerException serverException) {
                    // empty catch block
                }
            }
        });
    }
}

