/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ErrorMessage;
import cn.xyz.repository.mongo.MongoRepository;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class ErrorMessageManageImpl
extends MongoRepository<ErrorMessage, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<ErrorMessage> getEntityClass() {
        return ErrorMessage.class;
    }

    public Map<Long, List<ErrorMessage>> findErrorMessage(String keyword, int pageIndex, int pageSize) {
        ConcurrentMap map = Maps.newConcurrentMap();
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(keyword)) {
            query.filter("code", (Object)keyword);
        }
        query.offset(pageSize * pageIndex);
        List errorMessages = query.limit(pageSize).asList();
        map.put(query.count(), errorMessages);
        return map;
    }

    public boolean deleteErrorMessage(String code) {
        Query q = this.getDatastore().createQuery(this.getEntityClass());
        q.filter("code", (Object)code);
        this.getDatastore().delete(q);
        return true;
    }

    public JSONMessage saveErrorMessage(ErrorMessage errorMessage) {
        Query q = this.getDatastore().createQuery(this.getEntityClass());
        long count = q.filter("code", (Object)errorMessage.getCode()).count();
        if (count >= 1L) {
            throw new ServiceException("\u5f53\u524dcode\u5df2\u88ab\u6ce8\u518c");
        }
        this.save(errorMessage);
        return JSONMessage.success();
    }

    public ErrorMessage updataErrorMessage(String id, ErrorMessage errorMessage) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)new ObjectId(id));
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        this.logger.info(errorMessage.toString());
        ops.set("code", (Object)(null == errorMessage.getCode() ? ((ErrorMessage)q.get()).getCode() : errorMessage.getCode()));
        ops.set("type", (Object)(null == errorMessage.getType() ? ((ErrorMessage)q.get()).getType() : errorMessage.getType()));
        ops.set("zh", (Object)(null == errorMessage.getZh() ? ((ErrorMessage)q.get()).getZh() : errorMessage.getZh()));
        ops.set("en", (Object)(null == errorMessage.getEn() ? ((ErrorMessage)q.get()).getEn() : errorMessage.getEn()));
        ops.set("big5", (Object)(null == errorMessage.getBig5() ? ((ErrorMessage)q.get()).getBig5() : errorMessage.getBig5()));
        return (ErrorMessage)this.getDatastore().findAndModify(q, ops);
    }
}

