/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.KSession;
import cn.xyz.mianshi.service.CustomerManager;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.CommonText;
import cn.xyz.mianshi.vo.Customer;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.CustomerRepositoryImpl;
import com.shiku.utils.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Service;

@Service
public class CustomerManagerImpl
implements CustomerManager {
    public static CustomerRepositoryImpl getCustomerRepository() {
        CustomerRepositoryImpl customerRepository = SKBeanUtils.getCustomerRepository();
        return customerRepository;
    }

    @Override
    public Map<String, Object> registerUser(String ip) {
        String companyId = SKBeanUtils.getAdminManager().getConfig().getCustomer_companyId();
        String departmentId = SKBeanUtils.getAdminManager().getConfig().getCustomer_departmentId();
        if (StringUtil.isEmpty(companyId) || StringUtil.isEmpty(departmentId)) {
            throw new ServiceException(100608);
        }
        Map<Object, Object> data = new HashMap();
        Integer customerId = 0;
        customerId = CustomerManagerImpl.getCustomerRepository().findUserByIp(ip);
        if (customerId != null && customerId != 0) {
            data = KSessionUtil.loginSaveAccessToken(customerId, customerId, null);
            data.put("customerId", customerId);
        } else {
            customerId = SKBeanUtils.getUserManager().createUserId();
            Customer customer = new Customer();
            customer.setCustomerId(customerId);
            customer.setIp(ip);
            customer.setCompanyId(companyId);
            data = CustomerManagerImpl.getCustomerRepository().addCustomer(customer);
        }
        Integer serviceId = this.allocation(companyId, departmentId);
        if (null != data) {
            data.put("serviceId", serviceId);
            KSession session = new KSession(customerId, "zh", "web");
            session.setAccessToken((String)data.get("access_token"));
            session.setHttpKey(Base64.encode((byte[])RandomUtils.nextBytes((int)16)));
            SKBeanUtils.getRedisService().saveUserSesson(session);
            data.put("httpKey", session.getHttpKey());
            return data;
        }
        throw new ServiceException(100206);
    }

    public synchronized Integer allocation(String companyId, String departmentId) {
        ObjectId compId = new ObjectId(companyId);
        ObjectId departId = new ObjectId(departmentId);
        Map<Integer, Integer> map = CustomerManagerImpl.getCustomerRepository().findWaiter(compId, departId);
        int minValue = -1;
        int minKey = 0;
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            if (SKBeanUtils.getUserManager().getOnlinestateByUserId(entry.getKey()) == 0) continue;
            if (minValue == -1) {
                minValue = entry.getValue();
                minKey = entry.getKey();
            }
            if (entry.getValue() == 0) {
                minValue = entry.getValue();
                minKey = entry.getKey();
                break;
            }
            if (entry.getValue() >= minValue) continue;
            minValue = entry.getValue();
            minKey = entry.getKey();
        }
        return minKey;
    }

    @Override
    public CommonText commonTextAdd(CommonText commonText) {
        if (!StringUtil.isEmpty(commonText.toString())) {
            CustomerManagerImpl.getCustomerRepository().commonTextAdd(commonText);
            return commonText;
        }
        throw new ServiceException(100803);
    }

    @Override
    public boolean deleteCommonTest(String commonTextId) {
        boolean a = CustomerManagerImpl.getCustomerRepository().deleteCommonText(commonTextId);
        if (a) {
            return true;
        }
        throw new ServiceException(100420);
    }

    @Override
    public List<CommonText> commonTextGetByCompanyId(String companyId, int pageIndex, int pageSize) {
        List<CommonText> commonTextList = CustomerManagerImpl.getCustomerRepository().commonTextGetByCommpanyId(companyId, pageIndex, pageSize);
        return commonTextList;
    }

    @Override
    public List<CommonText> commonTextGetByUserId(int userId, int pageIndex, int pageSize) {
        List<CommonText> commonTextList = CustomerManagerImpl.getCustomerRepository().commonTextGetByUserId(userId, pageIndex, pageSize);
        return commonTextList;
    }

    @Override
    public CommonText commonTextModify(CommonText commonText) {
        if (null != CustomerManagerImpl.getCustomerRepository().commonTextModify(commonText)) {
            return commonText;
        }
        throw new ServiceException(100702);
    }

    @Override
    public User getUser(String customerId) {
        return null;
    }
}

