/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.model.PageVO;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.repository.mongo.ConsumeRecordRepositoryImpl;
import cn.xyz.repository.mongo.MongoRepository;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumeRecordManagerImpl
extends MongoRepository<ConsumeRecord, ObjectId> {
    private static final Logger log = LoggerFactory.getLogger(ConsumeRecordManagerImpl.class);
    @Autowired
    ConsumeRecordRepositoryImpl repository;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getLocalSpringBeanManager().getDatastore();
    }

    @Override
    public Class<ConsumeRecord> getEntityClass() {
        return ConsumeRecord.class;
    }

    public void saveConsumeRecord(ConsumeRecord entity) {
        if (null == entity.getId()) {
            this.save(entity);
        } else {
            this.update((Serializable)entity.getId(), entity);
        }
    }

    public PageResult<ConsumeRecord> getConsumeRecordByTradeNo(String tradeNo) {
        PageResult<ConsumeRecord> result = new PageResult<ConsumeRecord>();
        Query q = this.repository.createQuery().filter("tradeNo", (Object)tradeNo);
        ConsumeRecord record = (ConsumeRecord)q.get();
        if (null == record) {
            throw new ServiceException("\u65e0\u8be5\u6d88\u8d39\u8bb0\u5f55");
        }
        record.setUserName(SKBeanUtils.getUserManager().getNickName(record.getUserId()));
        ArrayList<ConsumeRecord> records = new ArrayList<ConsumeRecord>();
        records.add(record);
        result.setData(records);
        result.setCount(q.count());
        return result;
    }

    public ConsumeRecord getConsumeRecordByNo(String tradeNo) {
        Query q = this.repository.createQuery();
        if (!StringUtil.isEmpty(tradeNo)) {
            q.filter("tradeNo", (Object)tradeNo);
        }
        return (ConsumeRecord)q.get();
    }

    public ConsumeRecord getConsumeReCord(Integer userId, ObjectId id) {
        Query query = (Query)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId)).field("_id").equal((Object)id);
        return (ConsumeRecord)query.get();
    }

    public Object reChargeList(Integer userId, int pageIndex, int pageSize) {
        Query q = this.repository.createQuery();
        q.filter("type", (Object)1);
        if (0 != userId) {
            q.filter("userId", (Object)userId);
        }
        List pageData = q.asList(this.pageFindOption(pageIndex, pageSize, 0));
        long total = q.count();
        return new PageVO(pageData, total, pageIndex, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<DBObject> consumeRecordList(Integer userId, int page, int limit, byte state, String startDate, String endDate, int type) {
        PageResult<DBObject> result = new PageResult<DBObject>();
        ArrayList<DBObject> consumeRecords = new ArrayList<DBObject>();
        ConcurrentMap totalVO = Maps.newConcurrentMap();
        DBCollection collection = SKBeanUtils.getDatastore().getDB().getCollection("ConsumeRecord");
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
        BasicDBObject basicDBObject = new BasicDBObject("userId", (Object)userId).append("status", (Object)1);
        if (0 != type) {
            basicDBObject.append("type", (Object)type);
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            long formateEndtime = DateUtil.getOnedayNextDay(endTime, 1, 0);
            basicDBObject.append("time", (Object)new BasicDBObject("$gt", (Object)startTime)).append("time", (Object)new BasicDBObject("$lt", (Object)formateEndtime));
        }
        page = page > 0 ? page - 1 : page;
        DBCursor dbCursor = this.getDatastore().getDB().getCollection("ConsumeRecord").find((DBObject)basicDBObject).sort((DBObject)new BasicDBObject("time", (Object)-1)).skip(page * limit).limit(limit);
        while (dbCursor.hasNext()) {
            DBObject obj = dbCursor.next();
            consumeRecords.add(obj);
        }
        result.setCount(dbCursor.count());
        result.setData(consumeRecords);
        BasicDBObject match = new BasicDBObject("$match", (Object)basicDBObject);
        BasicDBObject group = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$type").append("sum", (Object)new BasicDBObject("$sum", (Object)"$money")));
        pipeline.add(match);
        pipeline.add(group);
        AggregationOptions options = AggregationOptions.builder().build();
        Cursor cursor = collection.aggregate(pipeline, options);
        double totalTecharge = 0.0;
        double totalCash = 0.0;
        double totalTransfer = 0.0;
        double totalAccount = 0.0;
        double sendPacket = 0.0;
        double receivePacket = 0.0;
        try {
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                if (dbObject.get("_id").equals(1) || dbObject.get("_id").equals(3)) {
                    totalTecharge = StringUtil.addDouble(totalTecharge, (Double)dbObject.get("sum"));
                }
                if (dbObject.get("_id").equals(2) || dbObject.get("_id").equals(16)) {
                    totalCash = StringUtil.addDouble(totalCash, (Double)dbObject.get("sum"));
                }
                if (dbObject.get("_id").equals(7)) {
                    totalTransfer = StringUtil.addDouble(totalTransfer, (Double)dbObject.get("sum"));
                }
                if (dbObject.get("_id").equals(8)) {
                    totalAccount = StringUtil.addDouble(totalAccount, (Double)dbObject.get("sum"));
                }
                if (dbObject.get("_id").equals(4)) {
                    sendPacket = StringUtil.addDouble(sendPacket, (Double)dbObject.get("sum"));
                }
                if (!dbObject.get("_id").equals(5)) continue;
                receivePacket = StringUtil.addDouble(receivePacket, (Double)dbObject.get("sum"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cursor.close();
        }
        totalVO.put("totalTecharge", new DecimalFormat("#.00").format(totalTecharge));
        totalVO.put("totalCash", new DecimalFormat("#.00").format(totalCash));
        totalVO.put("totalTransfer", new DecimalFormat("#.00").format(totalTransfer));
        totalVO.put("sendPacket", new DecimalFormat("#.00").format(sendPacket));
        totalVO.put("receivePacket", new DecimalFormat("#.00").format(receivePacket));
        totalVO.put("totalAccount", new DecimalFormat("#.00").format(totalAccount));
        result.setTotalVo(JSONObject.toJSONString((Object)totalVO));
        log.info("\u5f53\u524d\u603b\u5145\u503c totalTecharge :{}  \u603b\u63d0\u73b0 totalCash :{}  \u603b\u8f6c\u51fa totalTransfer :{}  \u603b\u8f6c\u5165 totalAccount :{}  \u603b\u53d1\u9001\u7ea2\u5305 sendPacket :{}  \u603b\u63a5\u6536\u7ea2\u5305 receivePacket :{}", new Object[]{totalTecharge, totalCash, totalTransfer, totalAccount, sendPacket, receivePacket});
        return result;
    }

    public PageResult<ConsumeRecord> consumeRecordList(Integer userId, int page, int limit, byte state) {
        PageResult<ConsumeRecord> result = new PageResult<ConsumeRecord>();
        Query q = this.repository.createQuery().order("-time");
        q.filter("userId", (Object)userId);
        q.field("money").greaterThan((Object)0);
        q.filter("status", (Object)1);
        result.setData(q.asList(this.pageFindOption(page, limit, state)));
        result.setCount(q.count());
        return result;
    }

    public ConsumeRecord consumeRecordList(String tradeNo) {
        Query q = this.repository.createQuery().order("-time");
        q.filter("tradeNo", (Object)tradeNo);
        q.filter("status", (Object)1);
        return (ConsumeRecord)q.get();
    }

    public PageResult<ConsumeRecord> friendRecordList(Integer userId, int toUserId, int page, int limit, byte start) {
        PageResult<ConsumeRecord> result = new PageResult<ConsumeRecord>();
        Query q = this.repository.createQuery().order("-time");
        if (0 != userId) {
            q.filter("userId", (Object)userId);
        }
        if (0 != toUserId) {
            q.filter("toUserId", (Object)toUserId);
        }
        q.field("money").greaterThan((Object)0);
        q.filter("status", (Object)1);
        q.field("type").greaterThan((Object)3);
        result.setData(q.asList(this.pageFindOption(page, limit, start)));
        result.setCount(q.count());
        return result;
    }

    public PageResult<ConsumeRecord> recharge(int userId, int type, int page, int limit, String startDate, String endDate, String tradeNo) {
        double totalMoney = 0.0;
        PageResult<ConsumeRecord> result = new PageResult<ConsumeRecord>();
        Query query = this.getDatastore().createQuery(this.getEntityClass()).order("-time");
        if (0 == type || 1 == type) {
            query.or(new Criteria[]{(Criteria)query.criteria("type").equal((Object)1), (Criteria)query.criteria("type").equal((Object)3)});
        } else if (2 == type) {
            query.or(new Criteria[]{(Criteria)query.criteria("type").equal((Object)2), (Criteria)query.criteria("type").equal((Object)16)});
        } else if (3 == type) {
            query.field("type").equal((Object)3);
        } else if (4 == type) {
            query.field("type").equal((Object)1);
        }
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (!StringUtil.isEmpty(tradeNo)) {
            query.filter("tradeNo", (Object)tradeNo);
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            long formateEndtime = DateUtil.getOnedayNextDay(endTime, 1, 0);
            ((Query)query.field("time").greaterThan((Object)startTime)).field("time").lessThanOrEq((Object)formateEndtime);
        }
        List recordList = query.asList(this.pageFindOption(page, limit, 1));
        for (ConsumeRecord record : recordList) {
            BigDecimal bd1 = new BigDecimal(Double.toString(totalMoney));
            BigDecimal bd2 = new BigDecimal(Double.toString(record.getMoney()));
            totalMoney = bd1.add(bd2).doubleValue();
            record.setUserName(SKBeanUtils.getUserManager().getNickName(record.getUserId()));
        }
        result.setCount(query.count());
        log.info("\u5f53\u524d\u603b\u91d1\u989d\uff1a" + totalMoney);
        result.setTotal(totalMoney);
        result.setData(recordList);
        return result;
    }

    public PageResult<ConsumeRecord> payment(int userId, int type, int page, int limit, String startDate, String endDate) {
        double totalMoney = 0.0;
        PageResult<ConsumeRecord> result = new PageResult<ConsumeRecord>();
        Query query = this.getDatastore().createQuery(this.getEntityClass()).order("-time");
        if (0 != type) {
            query.filter("type", (Object)type);
        } else {
            query.or(new Criteria[]{(Criteria)query.criteria("type").equal((Object)10), (Criteria)query.criteria("type").equal((Object)12)});
        }
        if (0 != userId) {
            query.filter("userId", (Object)userId);
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            long formateEndtime = DateUtil.getOnedayNextDay(endTime, 1, 0);
            ((Query)query.field("time").greaterThan((Object)startTime)).field("time").lessThanOrEq((Object)formateEndtime);
        }
        List recordList = query.asList(this.pageFindOption(page, limit, 1));
        for (ConsumeRecord record : recordList) {
            BigDecimal bd1 = new BigDecimal(Double.toString(totalMoney));
            BigDecimal bd2 = new BigDecimal(Double.toString(record.getMoney()));
            totalMoney = bd1.add(bd2).doubleValue();
            record.setUserName(SKBeanUtils.getUserManager().getNickName(record.getUserId()));
        }
        result.setCount(query.count());
        log.info("\u5f53\u524d\u603b\u91d1\u989d\uff1a" + totalMoney);
        result.setTotal(totalMoney);
        result.setData(recordList);
        return result;
    }
}

