/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.service.CompanyManager;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Company;
import cn.xyz.mianshi.vo.Department;
import cn.xyz.mianshi.vo.Employee;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.DepartmentRepository;
import cn.xyz.repository.mongo.CompanyRepositoryImpl;
import cn.xyz.repository.mongo.DepartmentRepositoryImpl;
import cn.xyz.repository.mongo.EmployeeRepositoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Service;

@Service
public class CompanyManagerImpl
implements CompanyManager {
    private static CompanyRepositoryImpl getCompanyRepository() {
        CompanyRepositoryImpl companyRepository = SKBeanUtils.getCompanyRepository();
        return companyRepository;
    }

    private static DepartmentRepository getDepartmentRepository() {
        DepartmentRepositoryImpl companyRepository = SKBeanUtils.getDepartmentRepository();
        return companyRepository;
    }

    private static EmployeeRepositoryImpl getEmployeeRepository() {
        EmployeeRepositoryImpl employeeRepository = SKBeanUtils.getEmployeeRepository();
        return employeeRepository;
    }

    @Override
    public Company createCompany(String companyName, int createUserId) {
        if (null != CompanyManagerImpl.getCompanyRepository().findOneByName(companyName)) {
            throw new ServiceException(100602);
        }
        ObjectId rootDpartId = new ObjectId();
        Company company = CompanyManagerImpl.getCompanyRepository().addCompany(companyName, createUserId, rootDpartId);
        Department department = new Department();
        department.setCompanyId(company.getId());
        department.setParentId(null);
        department.setDepartName(companyName);
        department.setCreateUserId(createUserId);
        department.setCreateTime(DateUtil.currentTimeSeconds());
        department.setEmpNum(0);
        department.setType(1);
        rootDpartId = CompanyManagerImpl.getDepartmentRepository().addDepartment(department);
        ArrayList<ObjectId> rootList = new ArrayList<ObjectId>();
        rootList.add(rootDpartId);
        Department personDepart = new Department();
        personDepart.setCompanyId(company.getId());
        personDepart.setParentId(rootDpartId);
        personDepart.setDepartName("\u4eba\u4e8b\u90e8");
        personDepart.setCreateUserId(createUserId);
        personDepart.setCreateTime(DateUtil.currentTimeSeconds());
        personDepart.setEmpNum(1);
        ObjectId personDepartId = CompanyManagerImpl.getDepartmentRepository().addDepartment(personDepart);
        Department financeDepart = new Department();
        financeDepart.setCompanyId(company.getId());
        financeDepart.setParentId(rootDpartId);
        financeDepart.setDepartName("\u8d22\u52a1\u90e8");
        financeDepart.setCreateUserId(createUserId);
        financeDepart.setCreateTime(DateUtil.currentTimeSeconds());
        financeDepart.setEmpNum(0);
        CompanyManagerImpl.getDepartmentRepository().addDepartment(financeDepart);
        Department Customer2 = new Department();
        Customer2.setCompanyId(company.getId());
        Customer2.setParentId(rootDpartId);
        Customer2.setDepartName("\u5ba2\u670d\u90e8");
        Customer2.setCreateUserId(createUserId);
        Customer2.setCreateTime(DateUtil.currentTimeSeconds());
        Customer2.setEmpNum(0);
        Customer2.setType(6);
        CompanyManagerImpl.getDepartmentRepository().addDepartment(Customer2);
        Employee employee = new Employee();
        employee.setDepartmentId(personDepartId);
        employee.setRole((byte)3);
        employee.setUserId(createUserId);
        employee.setCompanyId(company.getId());
        employee.setPosition("\u521b\u5efa\u8005");
        CompanyManagerImpl.getEmployeeRepository().addEmployee(employee);
        company.setRootDpartId(rootList);
        CompanyManagerImpl.getCompanyRepository().modifyCompany(company);
        return company;
    }

    @Override
    public List<Company> findCompanyByUserId(int userId) {
        List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().findByUserId(userId);
        if (employees == null) {
            return null;
        }
        ArrayList<Company> companys = new ArrayList<Company>();
        for (Employee emp : employees) {
            ObjectId companyId = emp.getCompanyId();
            Company comp = CompanyManagerImpl.getCompanyRepository().findById(companyId);
            if (null == comp || comp.getDeleteUserId() != 0) continue;
            companys.add(comp);
        }
        return companys;
    }

    @Override
    public Company getCompany(ObjectId companyId) {
        return CompanyManagerImpl.getCompanyRepository().findById(companyId);
    }

    @Override
    public void setManager(ObjectId companyId, List<Integer> managerId) {
        Employee employee = new Employee();
        for (int userId : managerId) {
            employee.setUserId(userId);
            employee.setCompanyId(companyId);
            employee.setRole((byte)2);
            CompanyManagerImpl.getEmployeeRepository().modifyEmployees(employee);
        }
    }

    @Override
    public List<Employee> managerList(ObjectId companyId) {
        int role = 2;
        List<Employee> list = CompanyManagerImpl.getEmployeeRepository().findByRole(companyId, role);
        return list;
    }

    @Override
    public Company modifyCompanyInfo(Company company) {
        if (company.getCompanyName() != null && !"".equals(company.getCompanyName())) {
            if (CompanyManagerImpl.getCompanyRepository().findOneByName(company.getCompanyName()) != null) {
                throw new ServiceException(100602);
            }
            Department department = new Department();
            department.setDepartName(company.getCompanyName());
            CompanyManagerImpl.getDepartmentRepository().modifyRootDepartByCompId(company.getId(), department);
        }
        return CompanyManagerImpl.getCompanyRepository().modifyCompany(company);
    }

    @Override
    public List<Company> findCompanyByKeyworld(String keyworld) {
        List<Company> companys = CompanyManagerImpl.getCompanyRepository().findCompanyByName(keyworld);
        if (companys.size() == 0) {
            return null;
        }
        return companys;
    }

    @Override
    public void deleteCompany(ObjectId companyId, int userId) {
        Company company = CompanyManagerImpl.getCompanyRepository().findById(companyId);
        if (company.getCreateUserId() != userId) {
            throw new ServiceException(10111);
        }
        if (0 != company.getDeleteUserId()) {
            throw new ServiceException(100603);
        }
        company.setDeleteUserId(userId);
        company.setDeleteTime(DateUtil.currentTimeSeconds());
        CompanyManagerImpl.getCompanyRepository().modifyCompany(company);
    }

    @Override
    public List<Company> companyList(int pageSize, int pageIndex) {
        return CompanyManagerImpl.getCompanyRepository().companyList(pageSize, pageIndex);
    }

    @Override
    public Department createDepartment(ObjectId companyId, ObjectId parentId, String departName, int createUserId) {
        if (CompanyManagerImpl.getDepartmentRepository().findOneByName(companyId, departName) != null) {
            throw new ServiceException(100604);
        }
        Department department = new Department();
        department.setCompanyId(companyId);
        department.setParentId(parentId);
        department.setEmpNum(0);
        department.setDepartName(departName);
        department.setCreateUserId(createUserId);
        department.setCreateTime(DateUtil.currentTimeSeconds());
        ObjectId departmentId = CompanyManagerImpl.getDepartmentRepository().addDepartment(department);
        return CompanyManagerImpl.getDepartmentRepository().findDepartmentById(departmentId);
    }

    @Override
    public Department modifyDepartmentInfo(Department department) {
        if (department.getDepartName() != null && !"".equals(department.getDepartName())) {
            ObjectId companyId = CompanyManagerImpl.getDepartmentRepository().getCompanyId(department.getId());
            int departType = CompanyManagerImpl.getDepartmentRepository().findById(department.getId()).getType();
            if (departType == 1 || departType == 4 || departType == 5) {
                throw new ServiceException(10111);
            }
            if (CompanyManagerImpl.getDepartmentRepository().findOneByName(companyId, department.getDepartName()) != null) {
                throw new ServiceException(100604);
            }
        }
        Department depart = CompanyManagerImpl.getDepartmentRepository().modifyDepartment(department);
        return depart;
    }

    @Override
    public void deleteDepartment(ObjectId departmentId) {
        int departType = CompanyManagerImpl.getDepartmentRepository().findById(departmentId).getType();
        if (departType == 1 || departType == 4 || departType == 5) {
            throw new ServiceException(100606);
        }
        if (CompanyManagerImpl.getDepartmentRepository().findChildDepartmeny(departmentId).size() > 0) {
            throw new ServiceException(10101);
        }
        CompanyManagerImpl.getEmployeeRepository().delEmpByDeptId(departmentId);
        CompanyManagerImpl.getDepartmentRepository().deleteDepartment(departmentId);
    }

    @Override
    public List<Department> departmentList(ObjectId companyId) {
        List<Department> departments = CompanyManagerImpl.getDepartmentRepository().departmentList(companyId);
        for (Department department : departments) {
            List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().departEmployeeList(department.getId());
            this.setUserNickname(employees);
            department.setEmployees(employees);
        }
        return departments;
    }

    public List<Department> departmentList(List<Department> departments) {
        for (Department department : departments) {
            List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().departEmployeeList(department.getId());
            this.setUserNickname(employees);
            department.setEmployees(employees);
        }
        return departments;
    }

    @Override
    public List<Employee> addEmployee(ObjectId companyId, ObjectId departmentId, List<Integer> userId) {
        List<Employee> compEmps = CompanyManagerImpl.getEmployeeRepository().compEmployeeList(companyId);
        for (int uid : userId) {
            for (Employee emp : compEmps) {
                if (emp.getUserId() != uid) continue;
                throw new ServiceException(100509);
            }
        }
        List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().addEmployees(userId, companyId, departmentId);
        Company company = CompanyManagerImpl.getCompanyRepository().findById(companyId);
        company.setEmpNum(company.getEmpNum() + userId.size());
        CompanyManagerImpl.getCompanyRepository().modifyCompany(company);
        Department department = CompanyManagerImpl.getDepartmentRepository().findById(departmentId);
        department.setEmpNum(department.getEmpNum() + userId.size());
        CompanyManagerImpl.getDepartmentRepository().modifyDepartment(department);
        this.setUserNickname(employees);
        return employees;
    }

    @Override
    public void deleteEmployee(List<Integer> userIds, ObjectId departmentId) {
        Department department = CompanyManagerImpl.getDepartmentRepository().findById(departmentId);
        userIds.forEach(delUserId -> {
            if (delUserId.equals(department.getCreateUserId())) {
                throw new ServiceException(10111);
            }
        });
        CompanyManagerImpl.getEmployeeRepository().deleteEmployee(userIds, departmentId);
        department.setEmpNum(department.getEmpNum() - 1);
        CompanyManagerImpl.getDepartmentRepository().modifyDepartment(department);
        Company company = CompanyManagerImpl.getCompanyRepository().findById(department.getCompanyId());
        company.setEmpNum(company.getEmpNum() - 1);
        CompanyManagerImpl.getCompanyRepository().modifyCompany(company);
    }

    @Override
    public Employee changeEmployeeInfo(Employee employee) {
        if (!StringUtil.isEmpty(employee.toString())) {
            Employee employeeData = CompanyManagerImpl.getEmployeeRepository().findEmployee(employee);
            if (null != employeeData && !"".equals(employeeData)) {
                Employee employeeInfo = CompanyManagerImpl.getEmployeeRepository().findById(employeeData.getId());
                if (employeeInfo.getChatNum() == 5 && employee.getOperationType() == 1) {
                    throw new ServiceException(100607);
                }
                int num = employeeInfo.getChatNum();
                if (employee.getOperationType() == 1) {
                    employee.setChatNum(num + 1);
                } else if (employee.getOperationType() == 2) {
                    employee.setChatNum(num - 1);
                } else {
                    employee.setChatNum(employeeInfo.getChatNum());
                }
                if (employee.getOperationType() != 0 && employee.getIsPause() == 0) {
                    employee.setIsPause(employeeInfo.getIsPause());
                }
                if (employee.getChatNum() < 0) {
                    return null;
                }
                Employee emp = this.modifyEmpInfo(employee);
                return emp;
            }
            throw new ServiceException(100605);
        }
        throw new ServiceException(1010101);
    }

    @Override
    public Employee modifyEmpInfo(Employee employee) {
        Employee oldemp = CompanyManagerImpl.getEmployeeRepository().findById(employee.getId());
        Employee emp = CompanyManagerImpl.getEmployeeRepository().modifyEmployees(employee);
        String nickname = SKBeanUtils.getUserRepository().getUser(emp.getUserId()).getNickname();
        emp.setNickname(nickname);
        return emp;
    }

    @Override
    public Employee updateEmpDeft(Employee employee) {
        ObjectId oldDeptId = CompanyManagerImpl.getEmployeeRepository().getEmployeeByUserId(employee.getCompanyId(), employee.getUserId()).getDepartmentId();
        CompanyManagerImpl.getDepartmentRepository().updateDepartment(oldDeptId, -1);
        Employee emp = CompanyManagerImpl.getEmployeeRepository().modifyEmployees(employee);
        CompanyManagerImpl.getDepartmentRepository().updateDepartment(employee.getDepartmentId(), 1);
        String nickname = SKBeanUtils.getUserRepository().getUser(emp.getUserId()).getNickname();
        emp.setNickname(nickname);
        return emp;
    }

    @Override
    public List<Employee> employeeList(ObjectId companyId) {
        List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().compEmployeeList(companyId);
        this.setUserNickname(employees);
        return employees;
    }

    @Override
    public List<Employee> departEmployeeList(ObjectId departmentId) {
        List<Employee> employees = CompanyManagerImpl.getEmployeeRepository().departEmployeeList(departmentId);
        this.setUserNickname(employees);
        return employees;
    }

    @Override
    public Employee getEmployee(ObjectId employeeId) {
        Employee emp = CompanyManagerImpl.getEmployeeRepository().findById(employeeId);
        String nickname = SKBeanUtils.getUserRepository().getUser(emp.getUserId()).getNickname();
        emp.setNickname(nickname);
        return emp;
    }

    @Override
    public Department getDepartmentVO(ObjectId departmentId) {
        Department department = CompanyManagerImpl.getDepartmentRepository().findById(departmentId);
        return department;
    }

    public void setUserNickname(List<Employee> employees) {
        for (Employee employee : employees) {
            User user = SKBeanUtils.getUserRepository().getUser(employee.getUserId());
            String nickname = null != user ? user.getNickname() : "";
            employee.setNickname(nickname);
        }
    }

    @Override
    public Company autoJoinCompany(int userId) {
        Employee employee = new Employee();
        List<Company> companys = CompanyManagerImpl.getCompanyRepository().findByType(5);
        if (companys == null || companys.isEmpty()) {
            return null;
        }
        Random random = new Random();
        int comp = random.nextInt(companys.size());
        employee.setCompanyId(companys.get(comp).getId());
        List<Department> departments = CompanyManagerImpl.getDepartmentRepository().findByType(companys.get(comp).getId(), 5);
        int dept = random.nextInt(departments.size());
        employee.setDepartmentId(departments.get(dept).getId());
        employee.setUserId(userId);
        employee.setRole((byte)0);
        CompanyManagerImpl.getEmployeeRepository().addEmployee(employee);
        return CompanyManagerImpl.getCompanyRepository().findById(companys.get(comp).getId());
    }

    @Override
    public void empQuitCompany(ObjectId companyId, int userId) {
        byte employeeRole = CompanyManagerImpl.getEmployeeRepository().findRole(companyId, userId);
        if (employeeRole == 3) {
            this.deleteCompany(companyId, userId);
        } else {
            CompanyManagerImpl.getEmployeeRepository().delEmpByCompId(companyId, userId);
        }
    }

    @Override
    public int getEmpRole(ObjectId companyId, int userId) {
        return CompanyManagerImpl.getEmployeeRepository().findRole(companyId, userId);
    }

    @Override
    public Employee modifyEmployeesByuserId(int userId) {
        Employee employee = CompanyManagerImpl.getEmployeeRepository().modifyEmployeesByuserId(userId);
        if (!StringUtil.isEmpty(employee.toString())) {
            return employee;
        }
        throw new ServiceException(100702);
    }

    @Override
    public Employee findEmployee(Employee employee, User.UserSettings userSettings) {
        if (!(StringUtil.isEmpty(String.valueOf(employee.getCompanyId())) && StringUtil.isEmpty(String.valueOf(employee.getDepartmentId())) && StringUtil.isEmpty(String.valueOf(employee.getCompanyId())))) {
            Employee employeeInfo = CompanyManagerImpl.getEmployeeRepository().findEmployee(employee, userSettings);
            if (null != employeeInfo && !"".equals(employeeInfo)) {
                if (employeeInfo.getChatNum() > 0) {
                    throw new ServiceException("\u5f53\u524d\u8fd8\u6709" + employeeInfo.getChatNum() + "\u4e2a\u5ba2\u6237\u6b63\u5728\u4f1a\u8bdd\uff0c\u8bf7\u7ed3\u675f\u4f1a\u8bdd\u518d\u8bd5!");
                }
                if (userSettings.getOpenService() == 0 || userSettings.getOpenService() == 1) {
                    User user = SKBeanUtils.getUserRepository().updateSettings(employee.getUserId(), userSettings);
                    employeeInfo.setIsCustomer(user.getSettings().getOpenService());
                    if (userSettings.getOpenService() == 0) {
                        CompanyManagerImpl.getEmployeeRepository().modifyEmployees(employee);
                    }
                } else {
                    throw new ServiceException(1010101);
                }
                return employeeInfo;
            }
            throw new ServiceException(100605);
        }
        throw new ServiceException(1010101);
    }

    public boolean verifyAuthByCompanyId(ObjectId companyId, int userId, byte type) {
        return CompanyManagerImpl.getEmployeeRepository().findRole(companyId, userId) >= type;
    }

    public boolean verifyAuthByDepartmentId(ObjectId departmentId, int userId, byte type) {
        return CompanyManagerImpl.getEmployeeRepository().findRoleByDepartmentId(departmentId, userId) >= type;
    }
}

