/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.WXUserUtils;
import cn.xyz.mianshi.model.KeyPairParam;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AuthKeys;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthKeysServiceImpl
extends MongoRepository<AuthKeys, Integer> {
    @Autowired
    private UserManagerImpl userManager;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<AuthKeys> getEntityClass() {
        return AuthKeys.class;
    }

    public AuthKeys getAuthKeys(int userId) {
        AuthKeys authKeys = SKBeanUtils.getRedisService().getAuthKeys(userId);
        if (null == authKeys) {
            Query query = this.createQuery();
            query.project("dhMsgKeyList", false);
            query.filter("_id", (Object)userId);
            authKeys = (AuthKeys)this.findOne(query);
            if (null != authKeys) {
                SKBeanUtils.getRedisService().saveAuthKeys(userId, authKeys);
            }
        }
        return authKeys;
    }

    public synchronized void updateLoginPassword(int userId, String password) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            userKeys.setPassword(password);
            this.save(userKeys);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("password", (Object)password);
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
        SKBeanUtils.getUserRepository().updatePassowrd(userId, password);
        if (userKeys.getMsgDHKeyPair() != null && userKeys.getMsgRsaKeyPair() != null) {
            this.sendUpdatePublicKeyMsgToFriends(userKeys.getMsgDHKeyPair().getPublicKey(), userKeys.getMsgRsaKeyPair().getPublicKey(), userId);
        }
        SKBeanUtils.getRedisService().deleteAuthKeys(userId);
        KSessionUtil.deleteUserByUserId(userId);
        this.updateLoginPasswordCleanKeyPair(userId);
    }

    public String queryLoginPassword(int userId) {
        Object dbObj = this.queryOneFieldById("password", Integer.valueOf(userId));
        if (null == dbObj) {
            return null;
        }
        return dbObj.toString();
    }

    public String getPayPassword(int userId) {
        Object key = this.queryOneFieldById("payPassword", Integer.valueOf(userId));
        if (null == key) {
            return null;
        }
        return String.valueOf(key);
    }

    public synchronized void updatePayPassword(int userId, String payPassword) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            userKeys.setPayPassword(payPassword);
            this.save(userKeys);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("payPassword", (Object)payPassword);
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public synchronized void uploadPayKey(int userId, String publicKey, String privateKey) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            AuthKeys.KeyPair keyPair = new AuthKeys.KeyPair(publicKey, privateKey);
            keyPair.setCreateTime(userKeys.getCreateTime());
            userKeys.setPayKeyPair(keyPair);
            this.save(userKeys);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("payKeyPair.publicKey", (Object)publicKey);
        operations.set("payKeyPair.privateKey", (Object)privateKey);
        long time = DateUtil.currentTimeSeconds();
        operations.set("payKeyPair.modifyTime", (Object)time);
        operations.set("modifyTime", (Object)time);
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public synchronized void uploadLoginKeyPair(int userId, String publicKey, String privateKey) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            AuthKeys.KeyPair keyPair = new AuthKeys.KeyPair(publicKey, privateKey);
            keyPair.setCreateTime(userKeys.getCreateTime());
            userKeys.setLoginKeyPair(keyPair);
            this.save(userKeys);
            return;
        }
        if (null != userKeys.getLoginKeyPair() && !StringUtil.isEmpty(userKeys.getLoginKeyPair().getPrivateKey())) {
            this.logger.error("{}  \u767b\u9646\u516c\u79c1\u94a5 \u5df2\u7ecf\u5b58\u5728  \u4e0d\u80fd\u66f4\u65b0  ", (Object)userId);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("loginKeyPair.publicKey", (Object)publicKey);
        operations.set("loginKeyPair.privateKey", (Object)privateKey);
        long time = DateUtil.currentTimeSeconds();
        operations.set("loginKeyPair.modifyTime", (Object)time);
        operations.set("modifyTime", (Object)time);
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public void deleteLoginKeyPair(int userId) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            return;
        }
        if (null == userKeys.getLoginKeyPair() || StringUtil.isEmpty(userKeys.getLoginKeyPair().getPublicKey())) {
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("loginKeyPair.publicKey", (Object)"");
        operations.set("loginKeyPair.privateKey", (Object)"");
        long time = DateUtil.currentTimeSeconds();
        operations.set("loginKeyPair.modifyTime", (Object)time);
        operations.set("modifyTime", (Object)time);
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public void deletePayKey(int userId) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        operations.set("payKeyPair.publicKey", (Object)"");
        operations.set("payKeyPair.privateKey", (Object)"");
        long time = DateUtil.currentTimeSeconds();
        operations.set("payKeyPair.modifyTime", (Object)time);
        operations.set("modifyTime", (Object)time);
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public String getPayPublicKey(int userId) {
        BasicDBObject payPublicKey = (BasicDBObject)this.queryOneFieldById("payKeyPair", Integer.valueOf(userId));
        if (null == payPublicKey) {
            return null;
        }
        return payPublicKey.getString("publicKey");
    }

    public String getPayPrivateKey(int userId) {
        BasicDBObject payPublicKey = (BasicDBObject)this.queryOneFieldById("payKeyPair", Integer.valueOf(userId));
        if (null == payPublicKey) {
            return null;
        }
        return payPublicKey.getString("privateKey");
    }

    public String getLoginPublicKey(int userId) {
        BasicDBObject dbObject = (BasicDBObject)this.queryOneFieldById("loginKeyPair", Integer.valueOf(userId));
        if (null == dbObject) {
            return null;
        }
        return dbObject.getString("publicKey");
    }

    public String getLoginPrivateKey(int userId) {
        BasicDBObject dbObject = (BasicDBObject)this.queryOneFieldById("loginKeyPair", Integer.valueOf(userId));
        if (null == dbObject) {
            return null;
        }
        return dbObject.getString("privateKey");
    }

    public void updateLoginPasswordCleanKeyPair(int userId) {
        this.deleteLoginKeyPair(userId);
        SKBeanUtils.getRedisService().deleteAuthKeys(userId);
    }

    public synchronized boolean uploadMsgKey(int userId, KeyPairParam param) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            AuthKeys.KeyPair rsakeyPair = new AuthKeys.KeyPair(param.getRsaPublicKey(), param.getRsaPrivateKey());
            rsakeyPair.setCreateTime(userKeys.getCreateTime());
            AuthKeys.KeyPair dhkeyPair = new AuthKeys.KeyPair(param.getDhPublicKey(), param.getDhPrivateKey());
            dhkeyPair.setCreateTime(userKeys.getCreateTime());
            userKeys.setMsgRsaKeyPair(rsakeyPair);
            userKeys.setMsgDHKeyPair(dhkeyPair);
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(param.getDhPublicKey());
            puKey.setTime(userKeys.getCreateTime());
            userKeys.getDhMsgKeyList().add(puKey);
            this.save(userKeys);
            return true;
        }
        UpdateOperations operations = this.createUpdateOperations();
        if (!StringUtil.isEmpty(param.getDhPublicKey())) {
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(param.getDhPublicKey());
            puKey.setTime(DateUtil.currentTimeSeconds());
            userKeys.getDhMsgKeyList().add(puKey);
            operations.set("msgDHKeyPair.publicKey", (Object)param.getDhPublicKey());
            operations.set("dhMsgKeyList", userKeys.getDhMsgKeyList());
        }
        if (!StringUtil.isEmpty(param.getDhPrivateKey())) {
            operations.set("msgDHKeyPair.privateKey", (Object)param.getDhPrivateKey());
        }
        if (!StringUtil.isEmpty(param.getRsaPublicKey())) {
            operations.set("msgRsaKeyPair.publicKey", (Object)param.getRsaPublicKey());
        }
        if (!StringUtil.isEmpty(param.getRsaPrivateKey())) {
            operations.set("msgRsaKeyPair.privateKey", (Object)param.getRsaPrivateKey());
        }
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        SKBeanUtils.getRedisService().deleteAuthKeys(userId);
        return this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public KeyPairParam queryMsgKeyPair() {
        return null;
    }

    public synchronized void uploadDHMsgKey(int userId, String publicKey, String privateKey) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            AuthKeys.KeyPair keyPair = new AuthKeys.KeyPair(publicKey, privateKey);
            keyPair.setCreateTime(userKeys.getCreateTime());
            userKeys.setMsgDHKeyPair(keyPair);
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(publicKey);
            puKey.setTime(keyPair.getCreateTime());
            userKeys.getDhMsgKeyList().add(puKey);
            this.save(userKeys);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        if (!StringUtil.isEmpty(publicKey)) {
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(publicKey);
            puKey.setTime(DateUtil.currentTimeSeconds());
            userKeys.getDhMsgKeyList().add(puKey);
            operations.set("msgDHKeyPair.publicKey", (Object)publicKey);
            operations.set("dhMsgKeyList", userKeys.getDhMsgKeyList());
        }
        if (!StringUtil.isEmpty(privateKey)) {
            operations.set("msgDHKeyPair.privateKey", (Object)privateKey);
        }
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public String getMsgDHPublicKey(int userId) {
        BasicDBObject dbObject = (BasicDBObject)this.queryOneFieldById("msgDHKeyPair", Integer.valueOf(userId));
        if (null == dbObject) {
            return null;
        }
        return dbObject.getString("publicKey");
    }

    public List<AuthKeys.PublicKey> queryMsgDHPublicKeyList(int userId) {
        Object payPublicKey = this.queryOneFieldById("dhMsgKeyList", Integer.valueOf(userId));
        if (null == payPublicKey) {
            return null;
        }
        return (List)payPublicKey;
    }

    public Map<String, String> queryUseRSAPublicKeyList(List<Integer> userList) {
        BasicDBObject query = new BasicDBObject("_id", (Object)new BasicDBObject("$in", userList));
        BasicDBObject projection = new BasicDBObject("_id", (Object)1).append("msgRsaKeyPair", (Object)1);
        HashMap<String, String> result = new HashMap<String, String>();
        try (DBCursor dbObjects = this.getDatastore().getCollection(AuthKeys.class).find((DBObject)query, (DBObject)projection);){
            while (dbObjects.hasNext()) {
                BasicDBObject next = (BasicDBObject)dbObjects.next();
                BasicDBObject msgRsaKeyPair = (BasicDBObject)next.get("msgRsaKeyPair");
                if (null == msgRsaKeyPair) continue;
                result.put(next.getString("_id"), msgRsaKeyPair.getString("publicKey"));
            }
        }
        return result;
    }

    public synchronized void uploadMsgRSAKey(int userId, String publicKey, String privateKey) {
        AuthKeys userKeys = (AuthKeys)this.get(Integer.valueOf(userId));
        if (null == userKeys) {
            userKeys = new AuthKeys(userId);
            AuthKeys.KeyPair keyPair = new AuthKeys.KeyPair(publicKey, privateKey);
            keyPair.setCreateTime(userKeys.getCreateTime());
            userKeys.setMsgRsaKeyPair(keyPair);
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(publicKey);
            puKey.setTime(keyPair.getCreateTime());
            this.save(userKeys);
            return;
        }
        UpdateOperations operations = this.createUpdateOperations();
        if (!StringUtil.isEmpty(publicKey)) {
            AuthKeys.PublicKey puKey = new AuthKeys.PublicKey();
            puKey.setKey(publicKey);
            puKey.setTime(DateUtil.currentTimeSeconds());
            userKeys.getDhMsgKeyList().add(puKey);
            operations.set("msgRsaKeyPair.publicKey", (Object)publicKey);
        }
        if (!StringUtil.isEmpty(privateKey)) {
            operations.set("msgRsaKeyPair.privateKey", (Object)privateKey);
        }
        operations.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.updateAttributeByOps(Integer.valueOf(userId), operations);
    }

    public Object bindWxopenid(int userId, String code) {
        if (StringUtil.isEmpty(code)) {
            return null;
        }
        JSONObject jsonObject = WXUserUtils.getWxOpenId(code);
        String openid = jsonObject.getString("openid");
        if (StringUtil.isEmpty(openid)) {
            return null;
        }
        System.out.println(String.format("======> bindWxopenid  userId %s  openid  %s", userId, openid));
        this.updateAttribute(Integer.valueOf(userId), "wxOpenId", openid);
        return jsonObject;
    }

    public String getWxopenid(int userId) {
        Object openId = this.queryOneFieldById("wxOpenId", Integer.valueOf(userId));
        if (null == openId) {
            return null;
        }
        return String.valueOf(openId);
    }

    public void bindAliUserId(int userId, String aliUserId) {
        if (StringUtil.isEmpty(aliUserId)) {
            return;
        }
        this.updateAttribute(Integer.valueOf(userId), "aliUserId", aliUserId);
    }

    public String getAliUserId(int userId) {
        Object openId = this.queryOneFieldById("aliUserId", Integer.valueOf(userId));
        if (null == openId) {
            return null;
        }
        return String.valueOf(openId);
    }

    public void sendUpdatePublicKeyMsgToFriends(String dhPublicKey, String rsaPublicKey, int userId) {
        List<Integer> friendIds = SKBeanUtils.getFriendsManager().getFriendsIdList(userId);
        KXMPPServiceImpl.MessageBean mb = new KXMPPServiceImpl.MessageBean();
        mb.setContent(dhPublicKey + "," + rsaPublicKey);
        mb.setFromUserId(userId + "");
        mb.setTimeSend(DateUtil.currentTimeSeconds());
        mb.setMessageId(UUID.randomUUID().toString());
        mb.setMsgType(0);
        mb.setType(803);
        KXMPPServiceImpl.getInstance().send(mb, friendIds);
    }
}

