/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.BeanUtils;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.ExcelUtil;
import cn.xyz.commons.utils.NumberUtil;
import cn.xyz.commons.utils.RandomUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.ConfigVO;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.opensdk.entity.SkOpenApp;
import cn.xyz.mianshi.service.AdminManager;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.Admin;
import cn.xyz.mianshi.vo.AreaConfig;
import cn.xyz.mianshi.vo.CenterConfig;
import cn.xyz.mianshi.vo.ClientConfig;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.InviteCode;
import cn.xyz.mianshi.vo.MusicInfo;
import cn.xyz.mianshi.vo.SdkLoginInfo;
import cn.xyz.mianshi.vo.ServerListConfig;
import cn.xyz.mianshi.vo.TotalConfig;
import cn.xyz.mianshi.vo.Transfer;
import cn.xyz.mianshi.vo.UrlConfig;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.AdminRepositoryImpl;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.message.Message;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class AdminManagerImpl
extends MongoRepository<Config, ObjectId>
implements AdminManager {
    private DefaultMQProducer pushProducer;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Config> getEntityClass() {
        return Config.class;
    }

    private static AdminRepositoryImpl getAdminRepository() {
        return SKBeanUtils.getAdminRepository();
    }

    private static UserManagerImpl getUserManager() {
        UserManagerImpl userManager = SKBeanUtils.getUserManager();
        return userManager;
    }

    @Override
    public Config getConfig() {
        Config config = null;
        try {
            config = KSessionUtil.getConfig();
            if (null == config) {
                config = (Config)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").notEqual(null)).get();
                if (null == config) {
                    config = this.initConfig();
                }
                KSessionUtil.setConfig(config);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            config = (Config)((Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").notEqual(null)).get();
        }
        return config;
    }

    @Override
    public ClientConfig getClientConfig() {
        ClientConfig clientconfig = null;
        try {
            clientconfig = KSessionUtil.getClientConfig();
            if (null == clientconfig) {
                clientconfig = (ClientConfig)((Query)this.getDatastore().createQuery(ClientConfig.class).field("_id").equal((Object)10000)).get();
                if (null == clientconfig) {
                    clientconfig = this.initClientConfig();
                }
                KSessionUtil.setClientConfig(clientconfig);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            clientconfig = (ClientConfig)((Query)this.getDatastore().createQuery(ClientConfig.class).field("_id").equal((Object)10000)).get();
        }
        return clientconfig;
    }

    @Override
    public Config initConfig() {
        Config config = new Config();
        try {
            config.setShareUrl("");
            config.setSoftUrl("");
            config.setHelpUrl("");
            config.setVideoLen("20");
            config.setAudioLen("20");
            this.getDatastore().save((Object)config);
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null == config ? null : config;
        }
    }

    @Override
    public void setConfig(Config config) {
        Config dest = this.getConfig();
        BeanUtils.copyProperties(config, dest);
        this.getDatastore().save((Object)dest);
        KSessionUtil.setConfig(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageResult<Document> apiLogList(String keyWorld, int page, int limit) {
        long count;
        MongoDatabase apiLogDB = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase("sysApiLog");
        MongoCollection collection = apiLogDB.getCollection(DateUtil.getY_MString());
        PageResult<Document> result = new PageResult<Document>();
        Document query = new Document();
        Pattern pattern = Pattern.compile("^.*" + keyWorld + ".*$", 2);
        if (!StringUtil.isEmpty(keyWorld)) {
            query.append("apiId", (Object)pattern);
        }
        if (0L == (count = collection.count((Bson)query))) {
            return null;
        }
        result.setCount(count);
        ArrayList<Document> dataList = new ArrayList<Document>();
        MongoCursor iterator = collection.find((Bson)query).sort((Bson)new Document("time", (Object)-1)).skip(page * limit).limit(limit).iterator();
        try {
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                dataList.add(document);
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        result.setData(dataList);
        return result;
    }

    @Override
    public void deleteApiLog(String apiLogId, int type) {
        MongoDatabase apiLogDB = SKBeanUtils.getLocalSpringBeanManager().getMongoClient().getDatabase("sysApiLog");
        if (0 == type) {
            String[] logids;
            if (StringUtil.isEmpty(apiLogId)) {
                throw new ServiceException("\u7f3a\u5c11\u5fc5\u4f20\u53c2\u6570\u6216,\u53c2\u6570\u9519\u8bef");
            }
            for (String logid : logids = StringUtil.getStringList(apiLogId)) {
                MongoCollection collection = apiLogDB.getCollection(DateUtil.getY_MString());
                Document query = new Document("_id", (Object)new ObjectId(logid));
                collection.deleteOne((Bson)query);
            }
        } else if (1 == type) {
            MongoCollection collection = apiLogDB.getCollection(DateUtil.getY_MString());
            long startTime = DateUtil.currentTimeSeconds();
            long endTime = DateUtil.getOnedayNextDay(startTime, 7, 1);
            Document query = new Document("endTime", (Object)new Document("$gt", (Object)endTime));
            collection.deleteMany((Bson)query);
        }
    }

    @Override
    public void createInviteCode(int num, int userId) {
        int totalTimes = 0;
        long curInviteCodeNo = SKBeanUtils.getUserManager().createInviteCodeNo(num).intValue();
        byte inviteCodeMode = SKBeanUtils.getAdminManager().getConfig().getRegisterInviteCode();
        if (inviteCodeMode == 0) {
            throw new ServiceException("\u7cfb\u7edf\u5f53\u524d\u6ca1\u6709\u5f00\u542f\u9080\u8bf7\u7801");
        }
        if (inviteCodeMode == 1) {
            totalTimes = 1;
        } else if (inviteCodeMode == 2) {
            if (AdminManagerImpl.getAdminRepository().findUserInviteCode(userId) != null) {
                return;
            }
            totalTimes = -1;
            num = 1;
        } else {
            throw new ServiceException("\u7cfb\u7edf\u9080\u8bf7\u7801\u6a21\u5f0f\u5f02\u5e38");
        }
        String inviteCodeStr = "";
        for (int i = 1; i <= num; ++i) {
            inviteCodeStr = RandomUtil.idToSerialCode(DateUtil.currentTimeSeconds() + curInviteCodeNo + (long)i + (long)RandomUtil.getRandomNum(100, 1000).intValue());
            InviteCode inviteCodeObj = new InviteCode(userId, inviteCodeStr, System.currentTimeMillis(), totalTimes);
            this.getDatastore().save((Object)inviteCodeObj);
        }
    }

    @Override
    public InviteCode findUserPopulInviteCode(int userId) {
        byte inviteCodeMode = SKBeanUtils.getAdminManager().getConfig().getRegisterInviteCode();
        if (inviteCodeMode != 2) {
            return null;
        }
        InviteCode inviteCode = SKBeanUtils.getAdminRepository().findUserInviteCode(userId);
        if (inviteCode == null) {
            long curInviteCodeNo = SKBeanUtils.getUserManager().createInviteCodeNo(1).intValue();
            String inviteCodeStr = RandomUtil.idToSerialCode(DateUtil.currentTimeSeconds() + curInviteCodeNo + 1L + (long)RandomUtil.getRandomNum(100, 1000).intValue());
            inviteCode = new InviteCode(userId, inviteCodeStr, System.currentTimeMillis(), -1);
            SKBeanUtils.getAdminRepository().savaInviteCode(inviteCode);
        }
        return inviteCode;
    }

    @Override
    public PageResult<InviteCode> inviteCodeList(int userId, String keyworld, short status, int page, int limit) {
        PageResult<InviteCode> result = new PageResult<InviteCode>();
        Query query = this.getDatastore().createQuery(InviteCode.class).filter("userId", (Object)userId);
        if (keyworld != "" && keyworld != null) {
            query.or(new Criteria[]{(Criteria)query.criteria("inviteCode").containsIgnoreCase(keyworld)});
        }
        if (status >= 0 && status <= 1) {
            query.filter("status", (Object)status);
        }
        query.order("status");
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(page, limit, 1)));
        return result;
    }

    @Override
    public boolean delInviteCode(int userId, String inviteCodeId) {
        if (StringUtil.isEmpty(inviteCodeId) || userId == 0) {
            throw new ServiceException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\u6216\u65e0\u6548");
        }
        ObjectId inviteCode_obId = new ObjectId(inviteCodeId);
        return SKBeanUtils.getAdminRepository().delInviteCode(userId, inviteCode_obId);
    }

    @Override
    public void addAdmin(String account, String password, byte role) {
        Admin admin = new Admin(account, password, role, 1, System.currentTimeMillis());
        this.getDatastore().save((Object)admin);
    }

    @Override
    public Admin findAdminByAccount(String account) {
        Admin admin = (Admin)this.getDatastore().createQuery(Admin.class).filter("account", (Object)account).get();
        return admin;
    }

    @Override
    public Admin findAdminById(ObjectId adminId) {
        Admin admin = (Admin)this.getDatastore().createQuery(Admin.class).filter("_id", (Object)adminId).get();
        return admin;
    }

    @Override
    public PageResult<Admin> adminList(String keyWorld, ObjectId adminId, int page, int limit) {
        PageResult<Admin> result = new PageResult<Admin>();
        Query query = this.getDatastore().createQuery(Admin.class);
        query.field("_id").notEqual((Object)adminId);
        if (!StringUtil.isEmpty(keyWorld)) {
            query.criteria("account").containsIgnoreCase(keyWorld);
        }
        result.setData(query.order("-createTime").asList(this.pageFindOption(page, limit, 1)));
        result.setCount(query.count());
        return result;
    }

    @Override
    public void delAdminById(ObjectId adminId) {
        Query query = (Query)this.getDatastore().createQuery(Admin.class).field("_id").equal((Object)adminId);
        this.getDatastore().delete(query);
    }

    @Override
    public boolean changePasswd(ObjectId adminId, String newPwd) {
        Query q = (Query)this.getDatastore().createQuery(Admin.class).field("_id").equal((Object)adminId);
        Admin admin = (Admin)q.get();
        admin.setPassword(newPwd);
        return this.getDatastore().save((Object)admin) != null;
    }

    @Override
    public Admin modifyAdmin(Admin admin) {
        Query q = (Query)this.getDatastore().createQuery(Admin.class).field("_id").equal((Object)admin.getId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(Admin.class);
        if (admin.getPassword() != null && admin.getPassword() != "") {
            ops.set("password", (Object)admin.getPassword());
        }
        if (admin.getRole() >= 0) {
            ops.set("role", (Object)admin.getRole());
        }
        if (admin.getState() >= 0) {
            ops.set("state", (Object)admin.getState());
        }
        if (0L != admin.getLastLoginTime()) {
            ops.set("lastLoginTime", (Object)admin.getLastLoginTime());
        }
        return (Admin)this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public ClientConfig initClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        try {
            clientConfig.XMPPDomain = "im.server.com";
            clientConfig.XMPPHost = "im.server.com";
            clientConfig.popularAPP = "{\"lifeCircle\":1,\"videoMeeting\":1,\"liveVideo\":1,\"shortVideo\":1,\"peopleNearby\":1,\"scan\":1}";
            this.getDatastore().save((Object)clientConfig);
            return clientConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null == clientConfig ? null : clientConfig;
        }
    }

    @Override
    public void setClientConfig(ClientConfig config) {
        ClientConfig dest = this.getClientConfig();
        BeanUtils.copyProperties(config, dest);
        this.getDatastore().save((Object)dest);
        KSessionUtil.setClientConfig(dest);
    }

    @Override
    public PageResult<ServerListConfig> getServerList(ObjectId id, int pageIndex, int limit) {
        Query query = this.getDatastore().createQuery(ServerListConfig.class);
        if (id != null) {
            query.field("_id").equal((Object)id);
        }
        PageResult<ServerListConfig> result = new PageResult<ServerListConfig>();
        result.setCount(query.count());
        result.setData(query.asList());
        return result;
    }

    @Override
    public void addServerList(ServerListConfig server) {
        ServerListConfig serverListConfig = new ServerListConfig();
        if (!StringUtil.isEmpty(server.getName())) {
            serverListConfig.setName(server.getName());
        }
        if (!StringUtil.isEmpty(server.getUrl())) {
            serverListConfig.setUrl(server.getUrl());
        }
        if (!StringUtil.isEmpty(server.getPort())) {
            serverListConfig.setPort(server.getPort());
        }
        if (!StringUtil.isEmpty(server.getArea())) {
            serverListConfig.setArea(server.getArea());
        }
        if (!StringUtil.isEmpty(server.getName())) {
            serverListConfig.setName(server.getName());
        }
        serverListConfig.setCount(server.getCount());
        serverListConfig.setMaxPeople(server.getMaxPeople());
        serverListConfig.setStatus(server.getStatus());
        serverListConfig.setType(server.getType());
        this.getDatastore().save((Object)serverListConfig);
    }

    @Override
    public void updateServer(ServerListConfig server) {
        Query q = (Query)this.getDatastore().createQuery(ServerListConfig.class).field("_id").equal((Object)server.getId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(ServerListConfig.class);
        if (!StringUtil.isEmpty(server.getName())) {
            ops.set("name", (Object)server.getName());
        }
        if (!StringUtil.isEmpty(server.getUrl())) {
            ops.set("url", (Object)server.getUrl());
        }
        if (!StringUtil.isEmpty(server.getPort())) {
            ops.set("port", (Object)server.getPort());
        }
        if (0 != server.getCount()) {
            ops.set("count", (Object)server.getCount());
        }
        if (0 != server.getMaxPeople()) {
            ops.set("maxPeople", (Object)server.getMaxPeople());
        }
        if (0 != server.getStatus()) {
            ops.set("status", (Object)server.getStatus());
        }
        this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public PageResult<AreaConfig> areaConfigList(String area, int pageIndex, int limit) {
        Query query = this.getDatastore().createQuery(AreaConfig.class);
        if (!area.equals("")) {
            query.field("area").equal((Object)area);
        }
        PageResult<AreaConfig> result = new PageResult<AreaConfig>();
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(pageIndex, limit, 0)));
        return result;
    }

    @Override
    public void addAreaConfig(AreaConfig area) {
        AreaConfig areaConfig = new AreaConfig();
        if (area.getId() != null) {
            Query q = (Query)this.getDatastore().createQuery(AreaConfig.class).field("_id").equal((Object)area.getId());
            UpdateOperations ops = this.getDatastore().createUpdateOperations(AreaConfig.class);
            if (!StringUtil.isEmpty(area.getArea())) {
                ops.set("area", (Object)area.getArea());
            }
            if (!StringUtil.isEmpty(area.getName())) {
                ops.set("name", (Object)area.getName());
            }
            this.getDatastore().findAndModify(q, ops);
        } else {
            if (!StringUtil.isEmpty(area.getArea())) {
                areaConfig.setArea(area.getArea());
            }
            areaConfig.setName(area.getName());
            this.getDatastore().save((Object)areaConfig);
        }
    }

    @Override
    public void updateAreaConfig(AreaConfig areaConfig) {
        Query q = (Query)this.getDatastore().createQuery(AreaConfig.class).field("_id").equal((Object)areaConfig.getId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(AreaConfig.class);
        if (!StringUtil.isEmpty(areaConfig.getArea())) {
            ops.set("area", (Object)areaConfig.getArea());
        }
        if (!StringUtil.isEmpty(areaConfig.getName())) {
            ops.set("name", (Object)areaConfig.getName());
        }
        this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public void addUrlConfig(UrlConfig urlConfig) {
        UrlConfig data = new UrlConfig();
        if (urlConfig.getId() != null) {
            Query query = (Query)this.getDatastore().createQuery(UrlConfig.class).field("_id").equal((Object)urlConfig.getId());
            UpdateOperations ops = this.getDatastore().createUpdateOperations(UrlConfig.class);
            if (!StringUtil.isEmpty(urlConfig.getArea())) {
                ops.set("area", (Object)urlConfig.getArea());
            }
            if (!StringUtil.isEmpty(urlConfig.getType())) {
                ops.set("type", (Object)urlConfig.getType());
            }
            if (!StringUtil.isEmpty(urlConfig.getToArea())) {
                ops.set("url", (Object)urlConfig.getToArea());
            }
            this.getDatastore().findAndModify(query, ops);
        } else {
            if (!StringUtil.isEmpty(urlConfig.getArea())) {
                data.setArea(urlConfig.getArea());
            }
            if (!StringUtil.isEmpty(urlConfig.getType())) {
                data.setType(urlConfig.getType());
            }
            if (!StringUtil.isEmpty(urlConfig.getToArea())) {
                data.setToArea(urlConfig.getToArea());
            }
            this.getDatastore().save((Object)data);
        }
    }

    @Override
    public PageResult<UrlConfig> findUrlConfig(ObjectId id, String type) {
        Query query = this.getDatastore().createQuery(UrlConfig.class);
        if (id != null) {
            query.field("_id").equal((Object)id);
        } else if (!StringUtil.isEmpty(type)) {
            query.field("type").equal((Object)type);
        } else {
            query = this.getDatastore().createQuery(UrlConfig.class);
        }
        PageResult<UrlConfig> result = new PageResult<UrlConfig>();
        result.setCount(query.count());
        result.setData(query.asList());
        return result;
    }

    @Override
    public void addCenterConfig(CenterConfig centerConfig) {
        CenterConfig data = new CenterConfig();
        if (centerConfig.getId() != null) {
            Query q = (Query)this.getDatastore().createQuery(CenterConfig.class).field("_id").equal((Object)centerConfig.getId());
            UpdateOperations ops = this.getDatastore().createUpdateOperations(CenterConfig.class);
            if (!StringUtil.isEmpty(centerConfig.getClientA())) {
                ops.set("clientA", (Object)centerConfig.getClientA());
            }
            if (!StringUtil.isEmpty(centerConfig.getClientB())) {
                ops.set("clientB", (Object)centerConfig.getClientB());
            }
            if (!StringUtil.isEmpty(centerConfig.getArea())) {
                ops.set("area", (Object)centerConfig.getArea());
            }
            if (!StringUtil.isEmpty(centerConfig.getName())) {
                ops.set("name", (Object)centerConfig.getName());
            }
            if (centerConfig.getStatus() != 0) {
                ops.set("status", (Object)centerConfig.getStatus());
            }
            if (!StringUtil.isEmpty(centerConfig.getType())) {
                ops.set("type", (Object)centerConfig.getType());
            }
            this.getDatastore().findAndModify(q, ops);
        } else {
            if (!StringUtil.isEmpty(centerConfig.getClientA())) {
                data.setClientA(centerConfig.getClientA());
            }
            if (!StringUtil.isEmpty(centerConfig.getClientB())) {
                data.setClientB(centerConfig.getClientB());
            }
            if (!StringUtil.isEmpty(centerConfig.getArea())) {
                data.setArea(centerConfig.getArea());
            }
            data.setName(centerConfig.getName());
            data.setStatus(centerConfig.getStatus());
            data.setType(centerConfig.getType());
            this.getDatastore().save((Object)data);
        }
    }

    @Override
    public PageResult<CenterConfig> findCenterConfig(String type, ObjectId id) {
        Query query = this.getDatastore().createQuery(CenterConfig.class);
        if (!StringUtil.isEmpty(type)) {
            query.field("type").equal((Object)type);
        }
        if (id != null) {
            query.field("_id").equal((Object)id);
        }
        PageResult<CenterConfig> result = new PageResult<CenterConfig>();
        result.setCount(query.count());
        result.setData(query.asList());
        return result;
    }

    @Override
    public void deleteServer(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(ServerListConfig.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    @Override
    public void addTotalConfig(TotalConfig totalConfig) {
        TotalConfig data = new TotalConfig();
        if (totalConfig.getId() != null) {
            Query q = (Query)this.getDatastore().createQuery(TotalConfig.class).field("_id").equal((Object)totalConfig.getId());
            UpdateOperations ops = this.getDatastore().createUpdateOperations(TotalConfig.class);
            if (!StringUtil.isEmpty(totalConfig.getArea())) {
                ops.set("", (Object)totalConfig.getArea());
            }
            if (!StringUtil.isEmpty(totalConfig.getHttpConfig())) {
                ops.set("", (Object)totalConfig.getHttpConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getXmppConfig())) {
                ops.set("", (Object)totalConfig.getXmppConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getLiveConfig())) {
                ops.set("", (Object)totalConfig.getLiveConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getVideoConfig())) {
                ops.set("", (Object)totalConfig.getVideoConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getName())) {
                ops.set("", (Object)totalConfig.getName());
            }
            if (totalConfig.getStatus() != 0) {
                ops.set("", (Object)totalConfig.getStatus());
            }
            this.getDatastore().findAndModify(q, ops);
        } else {
            if (!StringUtil.isEmpty(totalConfig.getArea())) {
                data.setArea(totalConfig.getArea());
            }
            if (!StringUtil.isEmpty(totalConfig.getHttpConfig())) {
                data.setHttpConfig(totalConfig.getHttpConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getXmppConfig())) {
                data.setXmppConfig(totalConfig.getXmppConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getLiveConfig())) {
                data.setLiveConfig(totalConfig.getLiveConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getVideoConfig())) {
                data.setVideoConfig(totalConfig.getVideoConfig());
            }
            if (!StringUtil.isEmpty(totalConfig.getName())) {
                data.setName(totalConfig.getName());
            }
            if (totalConfig.getStatus() != 0) {
                data.setStatus(totalConfig.getStatus());
            }
            this.getDatastore().save((Object)data);
        }
    }

    @Override
    public void deleteUrlConfig(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(UrlConfig.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    @Override
    public PageResult<ServerListConfig> findServerByArea(String area) {
        Query query = this.getDatastore().createQuery(ServerListConfig.class);
        query.field("area").equal((Object)area);
        PageResult<ServerListConfig> result = new PageResult<ServerListConfig>();
        result.setCount(query.count());
        result.setData(query.asList());
        return result;
    }

    @Override
    public void deleteAreaConfig(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(AreaConfig.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    @Override
    public UrlConfig findUrlConfig(String area) {
        Query query = (Query)this.getDatastore().createQuery(UrlConfig.class).field("area").equal((Object)area);
        return (UrlConfig)query.get();
    }

    public String getArea(String area) {
        return area.split(",")[0];
    }

    public synchronized ConfigVO serverDistribution(String area, ConfigVO configVO) {
        area = this.getArea(area);
        UrlConfig urlconfig = SKBeanUtils.getAdminManager().findUrlConfig(area);
        PageResult<Object> result = new PageResult();
        result = urlconfig != null ? SKBeanUtils.getAdminManager().findServerByArea(urlconfig.getArea()) : SKBeanUtils.getAdminManager().findServerByArea("*");
        ArrayList<String> xmppList = new ArrayList<String>();
        ArrayList<String> httpList = new ArrayList<String>();
        ArrayList<String> videoList = new ArrayList<String>();
        ArrayList<String> liveList = new ArrayList<String>();
        for (ServerListConfig serverListConfig : result.getData()) {
            if (serverListConfig.getType() == 1) {
                xmppList.add(serverListConfig.getUrl());
                continue;
            }
            if (serverListConfig.getType() == 2) {
                httpList.add(serverListConfig.getUrl());
                continue;
            }
            if (serverListConfig.getType() == 3) {
                videoList.add(serverListConfig.getUrl());
                continue;
            }
            if (serverListConfig.getType() != 4) continue;
            liveList.add(serverListConfig.getUrl());
        }
        int random = 0;
        if (0 < xmppList.size()) {
            if (1 == xmppList.size()) {
                configVO.setXMPPHost((String)xmppList.get(0));
            } else {
                random = NumberUtil.getNum(0, xmppList.size() - 1);
                configVO.setXMPPHost((String)xmppList.get(random));
            }
        }
        if (0 < httpList.size()) {
            if (1 == httpList.size()) {
                configVO.setApiUrl((String)httpList.get(0));
            } else {
                random = NumberUtil.getNum(0, httpList.size() - 1);
                configVO.setApiUrl((String)httpList.get(random));
            }
        }
        if (0 < videoList.size()) {
            if (1 == videoList.size()) {
                configVO.setJitsiServer((String)videoList.get(0));
            } else {
                random = NumberUtil.getNum(0, videoList.size() - 1);
                configVO.setJitsiServer((String)videoList.get(random));
            }
        }
        if (0 < liveList.size()) {
            if (1 == liveList.size()) {
                configVO.setLiveUrl((String)liveList.get(0));
            } else {
                random = NumberUtil.getNum(0, liveList.size() - 1);
                configVO.setLiveUrl((String)liveList.get(random));
            }
        }
        return configVO;
    }

    @Override
    public void deleteCenter(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(CenterConfig.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    @Override
    public CenterConfig findCenterCofigByArea(String clientA, String clientB) {
        Query query;
        if (null == clientB) {
            clientB = "CN";
        }
        if ((query = this.getDatastore().createQuery(CenterConfig.class).filter("clientA", (Object)this.getArea(clientA)).filter("clientB", (Object)this.getArea(clientB))).get() == null) {
            query = this.getDatastore().createQuery(CenterConfig.class).filter("clientA", (Object)this.getArea(clientB)).filter("clientB", (Object)this.getArea(clientA));
        }
        return (CenterConfig)query.get();
    }

    @Override
    public PageResult<SkOpenApp> openAppList(int status, int type, int pageIndex, int limit, String keyword) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appType").equal((Object)type);
        if (status == 0) {
            query.field("status").equal((Object)status);
        }
        if (!StringUtil.isEmpty(keyword)) {
            query.or(new Criteria[]{(Criteria)query.criteria("appName").contains(keyword)});
        }
        PageResult<SkOpenApp> result = new PageResult<SkOpenApp>();
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(pageIndex, limit, 1)));
        return result;
    }

    public PageResult<MusicInfo> queryMusicInfo(int pageIndex, int pageSize, String keyword) {
        PageResult<MusicInfo> result = new PageResult<MusicInfo>();
        Query query = this.getDatastore().createQuery(MusicInfo.class);
        if (!StringUtil.isEmpty(keyword)) {
            query.or(new Criteria[]{(Criteria)query.criteria("name").contains(keyword), (Criteria)query.criteria("nikeName").contains(keyword)});
        }
        query.order("-useCount");
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return result;
    }

    public PageResult<Transfer> queryTransfer(int pageIndex, int pageSize, String keyword, String startDate, String endDate) {
        PageResult<Transfer> result = new PageResult<Transfer>();
        Query query = this.getDatastore().createQuery(Transfer.class);
        if (!StringUtil.isEmpty(keyword)) {
            query.field("userId").equal((Object)Integer.valueOf(keyword));
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            ((Query)query.field("createTime").greaterThan((Object)startTime)).field("createTime").lessThanOrEq((Object)endTime);
        } else {
            query.order("-createTime");
        }
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return result;
    }

    public PageResult<SdkLoginInfo> getSdkLoginInfoList(int pageIndex, int pageSize, String keyword) {
        PageResult<SdkLoginInfo> result = new PageResult<SdkLoginInfo>();
        Query query = this.getDatastore().createQuery(SdkLoginInfo.class);
        if (!StringUtil.isEmpty(keyword)) {
            query.field("userId").equal((Object)Integer.valueOf(keyword));
        }
        query.order("-createTime");
        result.setCount(query.count());
        result.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return result;
    }

    public void deleteSdkLoginInfo(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(SdkLoginInfo.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    public void sendSysNotice(Integer type, String body, String title, String url) throws UnsupportedEncodingException {
        JSONObject bodyObj = new JSONObject();
        if (type == 1) {
            bodyObj.put("objectId", (Object)url);
        }
        bodyObj.put("content", (Object)body);
        bodyObj.put("title", (Object)title);
        bodyObj.put("type", (Object)type);
        Message message = new Message("fullPushMessage", bodyObj.toJSONString().getBytes("utf-8"));
        try {
            SendResult result = this.getPushProducer().send(message);
            if (SendStatus.SEND_OK != result.getSendStatus()) {
                System.out.println(result.toString());
            }
        }
        catch (Exception e) {
            System.err.println("send  push Exception " + e.getMessage());
            this.restartProducer();
        }
    }

    public DefaultMQProducer getPushProducer() {
        if (null != this.pushProducer) {
            return this.pushProducer;
        }
        try {
            this.pushProducer = new DefaultMQProducer("pushProducer");
            this.pushProducer.setNamesrvAddr(SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getMqConfig().getNameAddr());
            this.pushProducer.setVipChannelEnabled(false);
            this.pushProducer.setCreateTopicKey("fullPushMessage");
            this.pushProducer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.pushProducer;
    }

    public void restartProducer() {
        System.out.println("pushProducer restartProducer ===\u300b " + SKBeanUtils.getLocalSpringBeanManager().getApplicationConfig().getMqConfig().getNameAddr());
        try {
            if (null != this.pushProducer && null != this.pushProducer.getDefaultMQProducerImpl()) {
                if (ServiceState.CREATE_JUST == this.pushProducer.getDefaultMQProducerImpl().getServiceState()) {
                    try {
                        this.pushProducer.start();
                    }
                    catch (Exception e) {
                        this.pushProducer = null;
                        this.getPushProducer();
                    }
                }
            } else {
                this.pushProducer = null;
                this.getPushProducer();
            }
        }
        catch (Exception e) {
            System.err.println("restartProducer Exception " + e.getMessage());
        }
    }

    public Workbook exprotExcelPhone(String startDate, String endDate, String onlinestate, String keyWord, HttpServletRequest request, HttpServletResponse response) {
        String name = "\u624b\u673a\u53f7\u660e\u7ec6";
        String fileName = DateUtil.getMDString() + ".xlsx";
        Query query = this.getDatastore().createQuery(User.class);
        if (!StringUtil.isEmpty(onlinestate)) {
            query.filter("onlinestate", (Object)Integer.valueOf(onlinestate));
        }
        if (!StringUtil.isEmpty(keyWord)) {
            boolean flag = NumberUtil.isNum(keyWord);
            if (flag) {
                Integer length = keyWord.length();
                if (length > 9) {
                    query.or(new Criteria[]{(Criteria)query.criteria("nickname").containsIgnoreCase(keyWord), (Criteria)query.criteria("telephone").containsIgnoreCase(keyWord)});
                } else {
                    query.or(new Criteria[]{(Criteria)query.criteria("nickname").containsIgnoreCase(keyWord), (Criteria)query.criteria("telephone").containsIgnoreCase(keyWord), (Criteria)query.criteria("_id").equal((Object)Integer.valueOf(keyWord))});
                }
            } else {
                query.or(new Criteria[]{(Criteria)query.criteria("nickname").containsIgnoreCase(keyWord), (Criteria)query.criteria("telephone").containsIgnoreCase(keyWord)});
            }
        }
        if (!StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {
            fileName = new StringBuffer(startDate).substring(5) + "~" + new StringBuffer(endDate).substring(5) + ".xlsx";
            long startTime = 0L;
            long endTime = 0L;
            startTime = StringUtil.isEmpty(startDate) ? 0L : DateUtil.toDate(startDate).getTime() / 1000L;
            endTime = StringUtil.isEmpty(endDate) ? DateUtil.currentTimeSeconds() : DateUtil.toDate(endDate).getTime() / 1000L;
            long formateEndtime = DateUtil.getOnedayNextDay(endTime, 1, 0);
            ((Query)query.field("createTime").greaterThan((Object)startTime)).field("createTime").lessThanOrEq((Object)formateEndtime);
        }
        List users = query.asList();
        ArrayList titles = Lists.newArrayList();
        titles.add("telephone");
        titles.add("phone");
        titles.add("createTime");
        ArrayList values = Lists.newArrayList();
        for (User user : users) {
            if (StringUtil.isEmpty(user.getPhone()) || !StringUtil.isMobile(user.getPhone())) continue;
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("telephone", user.getTelephone());
            map.put("phone", user.getPhone());
            map.put("createTime", DateUtil.timestamp2Date(String.valueOf(user.getCreateTime()), "yyyy-MM-dd"));
            values.add(map);
        }
        Workbook workBook = ExcelUtil.generateWorkbook(name, "xlsx", titles, values);
        response.reset();
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return workBook;
    }

    public void sendMsgToUser(int toUserId, int msgType, String content) {
        User user = SKBeanUtils.getUserManager().getUser(toUserId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setFromUserId("10000");
        messageBean.setFromUserName("\u5ba2\u670d\u516c\u4f17\u53f7");
        messageBean.setToUserId(String.valueOf(toUserId));
        messageBean.setToUserName(user.getNickname());
        messageBean.setType(msgType);
        messageBean.setTimeSend(DateUtil.currentTimeSeconds());
        messageBean.setContent(content);
        messageBean.setMessageId(StringUtil.randomUUID());
        SKBeanUtils.getXmppService().send(messageBean);
    }
}

