/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.service.impl;

import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.service.impl.FriendsManagerImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.AddressBook;
import cn.xyz.mianshi.vo.Config;
import cn.xyz.mianshi.vo.Friends;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.MappedClass;
import org.springframework.stereotype.Service;

@Service
public class AddressBookManagerImpl
extends MongoRepository<AddressBook, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getLocalSpringBeanManager().getDatastore();
    }

    @Override
    public String getCollectionName() {
        MappedClass mappedClass = this.morphia.getMapper().getMappedClass(AddressBook.class);
        if (null == mappedClass) {
            return null;
        }
        return mappedClass.getCollectionName();
    }

    @Override
    public String getCollectionName(int userId) {
        int remainder = 0;
        if (userId > 100000) {
            remainder = userId / 10000;
        }
        return String.valueOf(remainder);
    }

    @Override
    public Class<AddressBook> getEntityClass() {
        return AddressBook.class;
    }

    private static Config getSystemConfig() {
        return SKBeanUtils.getSystemConfig();
    }

    private static FriendsManagerImpl getFriendsManager() {
        return SKBeanUtils.getFriendsManager();
    }

    public List<AddressBook> uploadTelephone(User user, String deleteStr, String uploadStr, String uploadJsonStr) {
        List<AddressBook> books = null;
        if (!StringUtil.isEmpty(deleteStr)) {
            this.deleteByStrs(user.getUserId(), deleteStr);
        } else if (!StringUtil.isEmpty(uploadStr)) {
            books = this.uploadTelephone(user.getUserId(), user.getTelephone(), uploadStr);
        } else if (!StringUtil.isEmpty(uploadJsonStr)) {
            books = this.uploadJsonTelephone(user.getUserId(), user.getTelephone(), uploadJsonStr);
        }
        return books;
    }

    private List<AddressBook> uploadJsonTelephone(Integer userId, String telephone, String uploadJsonStr) {
        List address = JSONObject.parseArray((String)uploadJsonStr, AddressBook.class);
        ArrayList<AddressBook> bookList = new ArrayList<AddressBook>();
        for (int i = 0; i < address.size(); ++i) {
            String repPhone = ((AddressBook)address.get(i)).getToTelephone();
            String toTelephone = repPhone.replace(" ", "");
            toTelephone = toTelephone.replace("-", "");
            User user = null;
            if (0L < this.queryByUserIdAndToTelephone(userId, toTelephone) || toTelephone.equals(telephone)) continue;
            user = SKBeanUtils.getUserManager().getUser(toTelephone);
            AddressBook saveBook = this.saveBook(telephone, toTelephone, user, userId, ((AddressBook)address.get(i)).getToRemarkName());
            bookList.add(saveBook);
        }
        return bookList.stream().filter(book -> 1 == book.getRegisterEd()).collect(Collectors.toList());
    }

    private List<AddressBook> uploadTelephone(Integer userId, String telephone, String strs) {
        strs = strs.replace(" ", "");
        strs = strs.replace("-", "");
        String[] array = strs.split(",");
        User user = null;
        ArrayList<AddressBook> bookList = new ArrayList<AddressBook>();
        for (String str : array) {
            if (0L < this.queryByUserIdAndToTelephone(userId, str)) continue;
            user = SKBeanUtils.getUserManager().getUser(str);
            if (str.equals(telephone)) continue;
            AddressBook saveBook = this.saveBook(telephone, str, user, userId);
            bookList.add(saveBook);
        }
        return bookList.stream().filter(book -> 1 == book.getRegisterEd()).collect(Collectors.toList());
    }

    private AddressBook saveBook(String telephone, String str, User user, Integer userId, String toRemark) {
        AddressBook book = null;
        book = new AddressBook();
        book.setTelephone(telephone);
        book.setToTelephone(str);
        book.setRegisterEd(null == user ? 0 : 1);
        book.setUserId(userId);
        book.setToUserId(null == user ? null : user.getUserId());
        book.setRegisterTime(null == user ? 0L : user.getCreateTime());
        book.setToUserName(null == user ? null : user.getNickname());
        book.setToRemarkName(toRemark);
        if (null != user) {
            Friends friends = AddressBookManagerImpl.getFriendsManager().getFriends((int)userId, user.getUserId());
            if (null == friends && 0 == AddressBookManagerImpl.getSystemConfig().getIsAutoAddressBook()) {
                book.setStatus(0);
            } else if (null != friends && 2 == friends.getStatus()) {
                book.setStatus(2);
            } else if (0 == AddressBookManagerImpl.getSystemConfig().getIsAutoAddressBook()) {
                book.setStatus(0);
            } else if (1 == AddressBookManagerImpl.getSystemConfig().getIsAutoAddressBook()) {
                book.setStatus(1);
            }
        } else {
            book.setStatus(0);
        }
        DBObject dbObj = this.objectToDBObject(book);
        this.getDBObjectCollection(userId).insertOne((Object)dbObj);
        if (null != user && AddressBookManagerImpl.getSystemConfig().getIsAutoAddressBook() == 1) {
            ConcurrentMap bookMap = Maps.newConcurrentMap();
            bookMap.put("toUserId", String.valueOf(user.getUserId()));
            bookMap.put("toRemark", toRemark);
            this.logger.info("===\u300b       \u81ea\u52a8\u6dfb\u52a0\u597d\u53cb\uff1a     " + JSONObject.toJSONString((Object)bookMap));
            this.autofollowUser(userId, bookMap);
        }
        return book;
    }

    private AddressBook buildAddressBook(String telephone, String str, User user, Integer userId) {
        AddressBook book = new AddressBook();
        book.setTelephone(telephone);
        book.setToTelephone(str);
        book.setRegisterEd(user == null ? 0 : 1);
        book.setUserId(userId);
        book.setToUserId(user == null ? null : user.getUserId());
        book.setRegisterTime(user == null ? 0L : user.getCreateTime());
        book.setToUserName(user == null ? null : user.getNickname());
        return book;
    }

    private AddressBook saveBook(String telephone, String str, User user, Integer userId) {
        AddressBook book = null;
        book = new AddressBook();
        book.setTelephone(telephone);
        book.setToTelephone(str);
        book.setRegisterEd(user == null ? 0 : 1);
        book.setUserId(userId);
        book.setToUserId(user == null ? null : user.getUserId());
        book.setRegisterTime(user == null ? 0L : user.getCreateTime());
        book.setToUserName(user == null ? null : user.getNickname());
        DBObject dbObj = this.objectToDBObject(book);
        this.getDBObjectCollection(userId).insertOne((Object)dbObj);
        return book;
    }

    public void autofollowUser(Integer userId, Map<String, String> addressBook) {
        SKBeanUtils.getFriendsManager().autofollowUser(userId, addressBook);
    }

    public void notifyBook(final String telephone, Integer userId, String nickName, Long registerTime) {
        System.out.println("\u6ce8\u518c\u65f6\u4fee\u6539\u6570\u636e\uff1atelephone:" + telephone + "   toUserId:" + userId + "    nickName:" + nickName + "   registerTime:" + registerTime);
        DBCollection lastdbCollection = null;
        List collectionList = this.getCollectionList();
        for (String dbname : collectionList) {
            lastdbCollection = this.getDatastore().getDB().getCollection(dbname);
            BasicDBObject lastquery = new BasicDBObject();
            lastquery.put((Object)"registerEd", (Object)0);
            lastquery.put((Object)"toTelephone", (Object)telephone);
            BasicDBObject values = new BasicDBObject();
            values.put((Object)"registerEd", (Object)1);
            values.put((Object)"toUserName", (Object)nickName);
            values.put((Object)"registerTime", (Object)registerTime);
            values.put((Object)"toUserId", (Object)userId);
            values.put((Object)"status", (Object)(0 == AddressBookManagerImpl.getSystemConfig().getIsAutoAddressBook() ? 0 : 1));
            lastdbCollection.update((DBObject)lastquery, (DBObject)new BasicDBObject("$set", (Object)values), false, true);
        }
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                AddressBookManagerImpl.this.notifyBook(telephone);
            }
        });
    }

    public void notifyBook(String telephone) {
        System.out.println("\u63a8\u9001\u4f7f\u7528\u7684\u7535\u8bdd\u53f7\u7801\uff1a" + telephone);
        List collectionList = this.getCollectionList();
        for (String dbname : collectionList) {
            Iterator<Document> iterator = this.queryByToTelephone(dbname, telephone);
            while (iterator.hasNext()) {
                Document dbObject = iterator.next();
                KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
                messageBean.setType(511);
                messageBean.setFromUserId(dbObject.getInteger((Object)"toUserId").toString());
                messageBean.setFromUserName(dbObject.getString((Object)"toUserName"));
                int userId = dbObject.getInteger((Object)"userId");
                messageBean.setToUserId(userId + "");
                messageBean.setContent(JSONObject.toJSON((Object)dbObject));
                try {
                    KXMPPServiceImpl.getInstance().send(messageBean);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void deleteByStrs(Integer userId, String strs) {
        strs = strs.replace(" ", "");
        strs = strs.replace("-", "");
        String[] deleteArray = strs.split(",");
        Document query = new Document();
        query.put("userId", (Object)userId);
        query.put("toTelephone", (Object)new BasicDBObject("$in", (Object)deleteArray));
        this.getCollection(userId.intValue()).deleteMany((Bson)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> findRegisterList(int userId, int pageIndex, int pageSize) {
        Document query = new Document();
        query.put("registerEd", (Object)1);
        query.put("userId", (Object)userId);
        MongoCursor iterator = this.getCollection(userId).find((Bson)query).iterator();
        ArrayList<Document> list = new ArrayList<Document>();
        Document dbObj = null;
        try {
            while (iterator.hasNext()) {
                dbObj = (Document)iterator.next();
                dbObj.put("toUserName", (Object)SKBeanUtils.getUserManager().getNickName((Integer)dbObj.get((Object)"toUserId")));
                list.add(dbObj);
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return list;
    }

    public Iterator<Document> queryByToTelephone(String dbName, String toTelephone) {
        Document query = new Document("toTelephone", (Object)toTelephone);
        return this.getMongoCollection(dbName).find((Bson)query).iterator();
    }

    public long queryByUserIdAndToTelephone(Integer userId, String toTelephone) {
        Document query = new Document("userId", (Object)userId);
        query.put("toTelephone", (Object)toTelephone);
        return this.getCollection(userId.intValue()).count((Bson)query);
    }

    public void deleteByUserId(Integer userId, String toTelephone) {
        Document query = new Document("userId", (Object)userId);
        if (!StringUtil.isEmpty(toTelephone)) {
            query.put("toTelephone", (Object)toTelephone);
        }
        this.getCollection(userId.intValue()).deleteMany((Bson)query);
    }

    public Iterator<Document> getAll(Integer userId, int pageIndex, int pageSize) {
        Document query = new Document("userId", (Object)userId);
        return this.getCollection(userId.intValue()).find((Bson)query).iterator();
    }

    public void checkAddressBook(String toTelephone, Integer toUserId) {
        BasicDBObject q = new BasicDBObject("toTelephone", (Object)toTelephone);
        List list = this.distinct("telephone", (DBObject)q);
        BasicDBObject query = null;
        BasicDBObject obj = null;
        BasicDBObject value = null;
        for (Object telephone : list) {
            query = new BasicDBObject("telephone", (Object)telephone.toString());
            query.append("toTelephone", (Object)toTelephone);
            obj = (BasicDBObject)this.findOne((DBObject)query);
            if (1 == obj.getInt("registerEd")) continue;
            query.append("registerEd", (Object)0);
            value = new BasicDBObject("registerEd", (Object)1);
            long registerTime = DateUtil.currentTimeSeconds();
            value.append("registerTime", (Object)registerTime);
            value.append("toUserId", (Object)toUserId);
        }
    }

    public void writeOffUser(Integer userId) {
        BasicDBObject value = new BasicDBObject("registerEd", (Object)0);
        value.append("registerTime", (Object)0);
        this.updateAttributeSet("AddressBook", "userId", userId, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getAddressBookUserIds(Integer userId) {
        Document query = new Document("userId", (Object)userId);
        ArrayList<Document> orList = new ArrayList<Document>();
        orList.add(new Document("status", (Object)1));
        orList.add(new Document("status", (Object)2));
        query.append("$or", orList);
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        Document projection = new Document("toUserId", (Object)1);
        MongoCursor iterator = this.getCollection(userId.intValue()).find((Bson)query).projection((Bson)projection).iterator();
        Document dbObj = null;
        try {
            while (iterator.hasNext()) {
                dbObj = (Document)iterator.next();
                resultList.add(dbObj.getInteger((Object)"toUserId"));
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return resultList;
    }
}

