/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.scheduleds;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.constants.MsgType;
import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.service.impl.ConsumeRecordManagerImpl;
import cn.xyz.mianshi.service.impl.UserManagerImpl;
import cn.xyz.mianshi.utils.ConstantUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.ConsumeRecord;
import cn.xyz.mianshi.vo.LiveRoom;
import cn.xyz.mianshi.vo.RedPacket;
import cn.xyz.mianshi.vo.SysApiLog;
import cn.xyz.mianshi.vo.Transfer;
import cn.xyz.mianshi.vo.User;
import cn.xyz.mianshi.vo.UserStatusCount;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class CommTask
implements ApplicationListener<ApplicationContextEvent> {
    private static final Logger log = LoggerFactory.getLogger(CommTask.class);
    @Autowired(required=false)
    private Datastore dsForRW;
    public static final int STATUS_START = 1;
    public static final int STATUS_END = 2;
    public static final int STATUS_RECEDE = -1;
    public static final int TRANSFER_START = 1;
    public static final int TRANSFER_RECEDE = -1;
    @Autowired
    private UserManagerImpl userManager;
    @Autowired
    private ConsumeRecordManagerImpl recordManager;
    @Autowired(required=false)
    private KApplicationProperties.AppConfig appConfig;
    @Resource(name="org.springframework.context.annotation.internalScheduledAnnotationProcessor")
    private ScheduledAnnotationBeanPostProcessor scheduledProcessor;

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event.getApplicationContext().getParent() != null) {
            return;
        }
        if (0 == this.appConfig.getOpenTask()) {
            ThreadUtil.executeInThread(new Callback(){

                @Override
                public void execute(Object obj) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                        CommTask.this.scheduledProcessor.destroy();
                        log.info("====\u5b9a\u65f6\u4efb\u52a1\u88ab\u5173\u95ed\u4e86=======\u300b");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            log.info("====\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f\u4e2d=======\u300b");
        }
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void executeHourTask() {
        long start = System.currentTimeMillis();
        this.autoRefreshRedPackect();
        log.info("\u5237\u65b0\u7ea2\u5305\u6210\u529f,\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        this.autoRefreshTransfer();
        log.info("\u5237\u65b0\u8f6c\u8d26\u6210\u529f,\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        this.refreshUserStatusHour();
        this.deleteChatMsgRecord();
    }

    @Scheduled(cron="0 0 4 * * ?")
    public void executeDayTask() {
        this.refreshUserStatus();
        this.deleteOutTimeMucMsg();
        this.deleteMucHistory();
        this.deleteSysLogs();
    }

    @Scheduled(cron="0 0/5 * * * ?")
    public void refreshUserStatusCount() {
        BasicDBObject q = new BasicDBObject("onlinestate", (Object)1);
        long count = this.dsForRW.getCollection(User.class).getCount((DBObject)q);
        UserStatusCount userCount = new UserStatusCount();
        userCount.setType(1);
        userCount.setCount(count);
        userCount.setTime(DateUtil.currentTimeSeconds());
        this.userManager.saveEntity(userCount);
        log.info("\u5237\u65b0\u7528\u6237\u72b6\u6001\u7edf\u8ba1======\u300b {}", (Object)count);
    }

    public void refreshUserStatusHour() {
        long currentTime = new Date().getTime() / 1000L;
        Query q = null;
        long startTime = currentTime - 3600L;
        long endTime = currentTime;
        q = this.dsForRW.createQuery(UserStatusCount.class);
        q.enableValidation();
        System.out.println("\u5f53\u524d\u65f6\u95f4:" + DateUtil.TimeToStr(new Date()));
        q.field("time").greaterThanOrEq((Object)startTime);
        q.field("time").lessThan((Object)endTime);
        q.field("type").equal((Object)1);
        UserStatusCount userStatusCount = (UserStatusCount)q.order("-count").get();
        if (null != userStatusCount) {
            UserStatusCount uCount = new UserStatusCount();
            uCount.setTime(startTime);
            uCount.setType(2);
            uCount.setCount(userStatusCount.getCount());
            this.userManager.saveEntity(uCount);
            log.info("\u6700\u9ad8\u5728\u7ebf\u7528\u6237======\u300b  {}", (Object)uCount.getCount());
        }
    }

    public void refreshUserStatus() {
        BasicDBObject q = new BasicDBObject("_id", (Object)new BasicDBObject("$gt", (Object)1000));
        q.append("onlinestate", (Object)1);
        BasicDBObject values = new BasicDBObject();
        values.put("$set", (Object)new BasicDBObject("onlinestate", (Object)0));
        this.dsForRW.getCollection(User.class).update((DBObject)q, (DBObject)values, false, true);
    }

    @Scheduled(cron="0 0 2 * * ?")
    public void refreshUserStatusDay() {
        Date yesterday = DateUtil.getYesterdayMorning();
        Query q = null;
        long startTime = yesterday.getTime() / 1000L;
        long endTime = startTime + 86400L;
        q = this.dsForRW.createQuery(UserStatusCount.class);
        q.enableValidation();
        log.info("Day_Count \u5f53\u524d\u65f6\u95f4:" + DateUtil.TimeToStr(new Date()));
        q.field("time").greaterThanOrEq((Object)startTime);
        q.field("time").lessThan((Object)endTime);
        q.field("type").equal((Object)1);
        UserStatusCount userStatusCount = (UserStatusCount)q.order("-count").get();
        if (null != userStatusCount) {
            UserStatusCount uCount = new UserStatusCount();
            uCount.setTime(startTime);
            uCount.setType(3);
            uCount.setCount(userStatusCount.getCount());
            this.userManager.saveEntity(uCount);
            log.info("Day_Count \u6700\u9ad8\u5728\u7ebf\u7528\u6237======\u300b   {}", (Object)uCount.getCount());
        }
    }

    public void deleteChatMsgRecord() {
        MongoDatabase chatMsgDB = SKBeanUtils.getTigaseManager().getChatMsgDB();
        MongoDatabase lastMsgDB = SKBeanUtils.getTigaseManager().getLastMsgDB();
        MongoCollection dbCollection = null;
        MongoCollection lastdbCollection = null;
        MongoIterable listCollectionNames = chatMsgDB.listCollectionNames();
        System.out.println("=====> deleteChatMsgRecord " + DateUtil.TimeToStr(new Date()));
        try {
            for (String str : listCollectionNames) {
                if ("system.indexes".equals(str)) continue;
                dbCollection = chatMsgDB.getCollection(str);
                lastdbCollection = lastMsgDB.getCollection(str);
                Document query = new Document();
                Document lastquery = new Document();
                query.append("deleteTime", (Object)new BasicDBObject("$gt", (Object)0).append("$lt", (Object)DateUtil.currentTimeSeconds())).append("isRead", (Object)1);
                Document base = (Document)dbCollection.find((Bson)query).first();
                ArrayList<Document> queryOr = new ArrayList<Document>();
                if (base != null) {
                    queryOr.add(new Document("jid", (Object)String.valueOf(base.get((Object)"sender"))).append("userId", (Object)base.get((Object)"receiver").toString()));
                    queryOr.add(new Document("userId", (Object)String.valueOf(base.get((Object)"sender"))).append("jid", (Object)base.get((Object)"receiver").toString()));
                    lastquery.append("$or", queryOr);
                }
                query.append("contentType", (Object)new BasicDBObject("$in", MsgType.FileTypeArr));
                DistinctIterable distinct = dbCollection.distinct("content", (Bson)query, String.class);
                for (String url : distinct) {
                    ConstantUtil.deleteFile(url);
                }
                query.remove((Object)"contentType");
                dbCollection.deleteMany((Bson)query);
                query.remove((Object)"messageId");
                query.remove((Object)"sender");
                ArrayList<Document> baslist = new ArrayList<Document>();
                if (base != null) {
                    baslist.add(new Document("receiver", base.get((Object)"sender")));
                    baslist.add(new Document("sender", base.get((Object)"sender")));
                    query.append("$or", baslist);
                }
                query.remove((Object)"sender");
                query.remove((Object)"deleteTime");
                query.remove((Object)"isRead");
                Document lastMsgObj = (Document)dbCollection.find((Bson)query).sort((Bson)new Document("timeSend", (Object)-1)).first();
                if (lastMsgObj != null) {
                    Document values = new Document();
                    values.put("messageId", (Object)lastMsgObj.getString((Object)"messageId"));
                    values.put("timeSend", (Object)new Double(lastMsgObj.get((Object)"timeSend").toString()).longValue());
                    values.put("content", lastMsgObj.get((Object)"content"));
                    if (lastquery.isEmpty()) continue;
                    lastdbCollection.updateMany((Bson)lastquery, (Bson)new Document("$set", (Object)values));
                    continue;
                }
                if (lastquery.isEmpty()) continue;
                lastdbCollection.deleteMany((Bson)lastquery);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOutTimeMucMsg() {
        DBCollection dbCollection = null;
        DBCollection lastdbCollection = null;
        BasicDBObject query = null;
        BasicDBObject lastquery = null;
        try {
            System.out.println("=====> deleteMucMsgRecord " + DateUtil.TimeToStr(new Date()));
            Set set = SKBeanUtils.getImRoomDatastore().getDB().getCollectionNames();
            for (String s : set) {
                if (!s.startsWith("mucmsg_")) continue;
                lastquery = new BasicDBObject();
                query = new BasicDBObject();
                query.append("deleteTime", (Object)new BasicDBObject("$gt", (Object)0).append("$lt", (Object)DateUtil.currentTimeSeconds()));
                dbCollection = SKBeanUtils.getImRoomDatastore().getDB().getCollection(s);
                lastdbCollection = SKBeanUtils.getTigaseDatastore().getDB().getCollection("shiku_lastChats");
                BasicDBObject base = (BasicDBObject)dbCollection.findOne((DBObject)query);
                if (base != null) {
                    lastquery.put((Object)"jid", base.get("room_jid_id"));
                }
                query.append("contentType", (Object)new BasicDBObject("$in", MsgType.FileTypeArr));
                List fileList = dbCollection.distinct("content", (DBObject)query);
                for (String url : fileList) {
                    ConstantUtil.deleteFile(url);
                }
                query.remove((Object)"contentType");
                dbCollection.remove((DBObject)query);
                query.remove((Object)"deleteTime");
                DBObject lastMsgObj = dbCollection.find((DBObject)query).sort((DBObject)new BasicDBObject("timeSend", (Object)-1)).limit(1).one();
                BasicDBObject values = new BasicDBObject();
                if (lastMsgObj != null) {
                    values.put((Object)"messageId", lastMsgObj.get("messageId"));
                    values.put((Object)"timeSend", (Object)new Double(lastMsgObj.get("timeSend").toString()).longValue());
                    values.put((Object)"content", lastMsgObj.get("content"));
                    if (lastquery.isEmpty()) continue;
                    lastdbCollection.update((DBObject)lastquery, (DBObject)new BasicDBObject("$set", (Object)values), false, true);
                    continue;
                }
                if (lastquery.isEmpty()) continue;
                lastdbCollection.remove((DBObject)lastquery);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMucHistory() {
        long start = System.currentTimeMillis();
        DBCollection collection = SKBeanUtils.getTigaseDatastore().getDB().getCollection("muc_history");
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
        BasicDBObject group = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$room_jid").append("sum", (Object)new BasicDBObject("$sum", (Object)1)));
        BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject("sum", (Object)new BasicDBObject("$gt", (Object)100)));
        pipeline.add(group);
        pipeline.add(match);
        AggregationOptions options = AggregationOptions.builder().build();
        HashSet<String> jidSet = new HashSet<String>();
        try (Cursor cursor = collection.aggregate(pipeline, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                jidSet.add(dbObject.getString("_id"));
                log.info("\u8d85\u8fc7100\u6761\u7684\u7fa4\u7ec4\u8bb0\u5f55   {}", (Object)dbObject.toString());
            }
        }
        jidSet.stream().forEach(jid -> {
            try {
                BasicDBObject query = new BasicDBObject("room_jid", jid);
                BasicDBObject projection = new BasicDBObject("timestamp", (Object)1);
                Iterator iterator = collection.find((DBObject)query, (DBObject)projection).sort((DBObject)new BasicDBObject("timestamp", (Object)-1)).skip(100).limit(1).iterator();
                if (iterator.hasNext()) {
                    Object timestamp = ((DBObject)iterator.next()).get("timestamp");
                    query.put("timestamp", (Object)new BasicDBObject("$lt", timestamp));
                    collection.remove((DBObject)query);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        log.info("timeCount  ---> " + (System.currentTimeMillis() - start));
    }

    public void deleteSysLogs() {
        long beginTime = DateUtil.getOnedayNextDay(DateUtil.currentTimeSeconds(), 15, 1);
        Datastore datastore = SKBeanUtils.getDatastore();
        Query query = datastore.createQuery(SysApiLog.class);
        query.field("time").lessThanOrEq((Object)beginTime);
        log.info("\u7d2f\u79ef\u6e05\u9664   " + DateUtil.strToDateTime(beginTime) + "  \u524d\u7684  " + query.count() + "  \u6761\u7cfb\u7edf\u65e5\u5fd7\u8bb0\u5f55");
        datastore.delete(query);
    }

    public void clearLiveRoom() {
        Query query = this.dsForRW.createQuery(LiveRoom.class);
        query.field("createTime").lessThan((Object)(DateUtil.currentTimeSeconds() - 604800L));
        log.info("=========\u5b9a\u65f6\u5220\u9664\u76f4\u64ad\u95f4========  " + query.count());
        for (LiveRoom liveRoom : query.asList()) {
            SKBeanUtils.getLiveRoomManager().deleteLiveRoom(liveRoom.getRoomId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoRefreshRedPackect() {
        long currentTime = DateUtil.currentTimeSeconds();
        BasicDBObject obj = null;
        Integer userId = 0;
        Integer toUserId = 0;
        String roomJid = "";
        ObjectId redPackectId = null;
        Double money = 0.0;
        BasicDBObject values = new BasicDBObject();
        ArrayList<BasicDBObject> objs = new ArrayList<BasicDBObject>();
        BasicDBObject q = new BasicDBObject("outTime", (Object)new BasicDBObject("$lt", (Object)currentTime));
        q.put("over", (Object)new BasicDBObject("$gt", (Object)0));
        q.put("status", (Object)1);
        DBCursor cursor = this.dsForRW.getCollection(RedPacket.class).find((DBObject)q);
        try {
            while (cursor.hasNext()) {
                obj = (BasicDBObject)cursor.next();
                objs.add(obj);
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        if (0 < objs.size()) {
            values.put("$set", (Object)new BasicDBObject("status", (Object)-1));
            this.dsForRW.getCollection(RedPacket.class).update((DBObject)q, (DBObject)values, false, true);
        }
        for (DBObject dBObject : objs) {
            userId = (Integer)dBObject.get("userId");
            money = (Double)dBObject.get("over");
            roomJid = (String)dBObject.get("roomJid");
            redPackectId = (ObjectId)dBObject.get("_id");
            toUserId = (Integer)dBObject.get("toUserId");
            this.recedeMoney(userId, toUserId, roomJid, money, redPackectId);
        }
        log.info("\u7ea2\u5305\u8d85\u65f6\u672a\u9886\u53d6\u7684\u6570\u91cf ======> " + objs.size());
    }

    private void recedeMoney(Integer userId, Integer toUserId, String roomJid, Double money, ObjectId id) {
        if (!(0.0 < money)) {
            return;
        }
        DecimalFormat df = new DecimalFormat("#.00");
        money = Double.valueOf(df.format(money));
        ConsumeRecord record = new ConsumeRecord();
        String tradeNo = StringUtil.getOutTradeNo();
        record.setTradeNo(tradeNo);
        record.setMoney(money);
        record.setUserId(userId);
        record.setToUserId(toUserId);
        record.setType(6);
        record.setPayType(3);
        record.setTime(DateUtil.currentTimeSeconds());
        record.setStatus(1);
        record.setDesc("\u7ea2\u5305\u9000\u6b3e");
        Double balance = this.userManager.rechargeUserMoeny(userId, money, 1);
        record.setRedPacketId(id);
        record.setOperationAmount(money);
        record.setCurrentBalance(balance);
        this.recordManager.saveConsumeRecord(record);
        User toUser = (User)this.userManager.get(toUserId);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(86);
        if (toUser != null) {
            messageBean.setFromUserId(toUser.getUserId().toString());
            messageBean.setFromUserName(toUser.getNickname());
        } else {
            messageBean.setFromUserId("10100");
            messageBean.setFromUserName("\u652f\u4ed8\u516c\u4f17\u53f7");
        }
        if (roomJid != null) {
            messageBean.setObjectId(roomJid);
        }
        messageBean.setContent(id.toString());
        messageBean.setToUserId(userId.toString());
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info(userId + "  \u53d1\u51fa\u7684\u7ea2\u5305,\u5269\u4f59\u91d1\u989d   " + money + "  \u672a\u9886\u53d6  \u9000\u56de\u4f59\u989d!");
    }

    public void autoRefreshTransfer() {
        long currentTime = DateUtil.currentTimeSeconds();
        BasicDBObject obj = null;
        ArrayList<BasicDBObject> objs = new ArrayList<BasicDBObject>();
        BasicDBObject values = new BasicDBObject();
        Integer userId = 0;
        Double money = 0.0;
        Integer toUserId = 0;
        ObjectId transferId = null;
        BasicDBObject q = new BasicDBObject("outTime", (Object)new BasicDBObject("$lt", (Object)currentTime));
        q.put("status", (Object)1);
        DBCursor cursor = this.dsForRW.getCollection(Transfer.class).find((DBObject)q);
        while (cursor.hasNext()) {
            obj = (BasicDBObject)cursor.next();
            objs.add(obj);
        }
        if (0 < objs.size()) {
            values.put("$set", (Object)new BasicDBObject("status", (Object)-1));
            this.dsForRW.getCollection(Transfer.class).update((DBObject)q, (DBObject)values, false, true);
        }
        for (DBObject dBObject : objs) {
            userId = (Integer)dBObject.get("userId");
            money = (Double)dBObject.get("money");
            toUserId = (Integer)dBObject.get("toUserId");
            transferId = (ObjectId)dBObject.get("_id");
            this.transferRecedeMoney(userId, toUserId, money, transferId);
        }
        log.info("\u8f6c\u8d26\u8d85\u65f6\u672a\u9886\u53d6\u7684\u6570\u91cf ======> " + objs.size());
    }

    public void transferRecedeMoney(Integer userId, Integer toUserId, double money, ObjectId transferId) {
        if (!(0.0 < money)) {
            return;
        }
        DecimalFormat df = new DecimalFormat("#.00");
        money = Double.valueOf(df.format(money));
        ConsumeRecord record = new ConsumeRecord();
        String tradeNo = StringUtil.getOutTradeNo();
        record.setTradeNo(tradeNo);
        record.setMoney(money);
        record.setUserId(userId);
        record.setToUserId(toUserId);
        record.setType(9);
        record.setPayType(3);
        record.setTime(DateUtil.currentTimeSeconds());
        record.setStatus(1);
        record.setDesc("\u8f6c\u8d26\u9000\u6b3e");
        Double balance = this.userManager.rechargeUserMoeny(userId, money, 1);
        record.setCurrentBalance(balance);
        record.setOperationAmount(money);
        this.recordManager.saveConsumeRecord(record);
        User sysUser = (User)this.userManager.get(Integer.valueOf(1100));
        Transfer transfer = (Transfer)((Query)SKBeanUtils.getDatastore().createQuery(Transfer.class).field("_id").equal((Object)transferId)).get();
        transfer.setId(null);
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        messageBean.setType(89);
        messageBean.setFromUserId(sysUser.getUserId().toString());
        messageBean.setFromUserName(sysUser.getNickname());
        messageBean.setContent(JSONObject.toJSONString((Object)transfer));
        messageBean.setToUserId(userId.toString());
        messageBean.setMsgType(0);
        messageBean.setMessageId(StringUtil.randomUUID());
        try {
            KXMPPServiceImpl.getInstance().send(messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info(userId + "  \u53d1\u51fa\u8f6c\u8d26,\u5269\u4f59\u91d1\u989d   " + money + "  \u672a\u6536\u94b1  \u9000\u56de\u4f59\u989d!");
    }
}

