/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk.entity;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Id;

@Entity(value="SkOpenCheckLog", noClassnameStored=true)
public class SkOpenCheckLog {
    @Id
    private ObjectId id;
    private String accountId;
    private String appId;
    private Long createTime;
    private Long modifyTime;
    private String operateUser;
    private Byte status = 0;
    private String reason;

    public SkOpenCheckLog() {
    }

    public SkOpenCheckLog(SkOpenCheckLog skOpenCheckLog) {
        this.accountId = skOpenCheckLog.getAccountId();
        this.appId = skOpenCheckLog.getAppId();
        this.createTime = DateUtil.currentTimeSeconds();
        this.modifyTime = DateUtil.currentTimeSeconds();
        this.operateUser = skOpenCheckLog.getOperateUser();
        if (0 != skOpenCheckLog.getStatus()) {
            this.status = skOpenCheckLog.getStatus();
        }
        if (!StringUtil.isEmpty(skOpenCheckLog.getReason())) {
            this.reason = skOpenCheckLog.getReason();
        }
    }

    public SkOpenCheckLog(String accountId, String appId, String operateUser, String status, String reason) {
        this.accountId = accountId;
        this.appId = appId;
        this.createTime = DateUtil.currentTimeSeconds();
        this.modifyTime = DateUtil.currentTimeSeconds();
        this.operateUser = operateUser;
        if (!status.equals("0")) {
            this.status = Byte.valueOf(status);
        }
        if (!StringUtil.isEmpty(reason)) {
            this.reason = reason;
        }
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public String getOperateUser() {
        return this.operateUser;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setOperateUser(String operateUser) {
        this.operateUser = operateUser;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

