/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk;

import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.opensdk.entity.SkOpenApp;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.mongo.MongoRepository;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class OpenWebManageImpl
extends MongoRepository<SkOpenApp, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<SkOpenApp> getEntityClass() {
        return SkOpenApp.class;
    }

    public void openAccess(SkOpenApp skOpenWeb) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(SkOpenApp.class).field("_id").equal((Object)skOpenWeb.getId());
        if (!StringUtil.isEmpty(skOpenWeb.getAccountId())) {
            query.field("accountId").equal((Object)skOpenWeb.getAccountId());
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (skOpenWeb.getIsAuthShare() != 0) {
            ops.set("isAuthShare", (Object)skOpenWeb.getIsAuthShare());
        }
        if (skOpenWeb.getIsAuthLogin() != 0) {
            ops.set("isAuthLogin", (Object)skOpenWeb.getIsAuthLogin());
        }
        if (skOpenWeb.getIsAuthPay() != 0) {
            ops.set("isAuthPay", (Object)skOpenWeb.getIsAuthPay());
            ops.set("payCallBackUrl", (Object)skOpenWeb.getPayCallBackUrl());
        }
        SKBeanUtils.getDatastore().update(query, ops);
    }

    public SkOpenApp checkWebAPPByAppId(String appId) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        return (SkOpenApp)query.get();
    }
}

