/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk;

import cn.xyz.commons.support.Callback;
import cn.xyz.commons.utils.ThreadUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.opensdk.entity.SkOpenCheckLog;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.mongo.MongoRepository;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.springframework.stereotype.Service;

@Service
public class OpenCheckLogManageImpl
extends MongoRepository<SkOpenCheckLog, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<SkOpenCheckLog> getEntityClass() {
        return SkOpenCheckLog.class;
    }

    public void saveOpenCheckLogs(String accountId, String appId, String operateUser, String status, String reason) {
        final SkOpenCheckLog skOpenCheckLog = new SkOpenCheckLog(accountId, appId, operateUser, status, reason);
        ThreadUtil.executeInThread(new Callback(){

            @Override
            public void execute(Object obj) {
                SKBeanUtils.getOpenCheckLogManage().save(skOpenCheckLog);
            }
        });
    }

    public PageResult<SkOpenCheckLog> getOpenCheckLogList(int pageIndex, int pageSize) {
        Query query = this.getDatastore().createQuery(SkOpenCheckLog.class);
        PageResult<SkOpenCheckLog> data = new PageResult<SkOpenCheckLog>();
        data.setCount(query.count());
        data.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return data;
    }

    public void delOpenCheckLog(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenCheckLog.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }
}

