/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.DesUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.commons.vo.JSONMessage;
import cn.xyz.mianshi.opensdk.entity.OpenLoginInfo;
import cn.xyz.mianshi.opensdk.entity.SkOpenApp;
import cn.xyz.mianshi.opensdk.until.SkOpenUtil;
import cn.xyz.mianshi.utils.KSessionUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.GroupHelper;
import cn.xyz.mianshi.vo.Helper;
import cn.xyz.mianshi.vo.Room;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import cn.xyz.service.KXMPPServiceImpl;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Service
public class OpenAppManageImpl
extends MongoRepository<SkOpenApp, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<SkOpenApp> getEntityClass() {
        return SkOpenApp.class;
    }

    public synchronized SkOpenApp createApp(SkOpenApp skOpenApp) {
        Query query = this.getDatastore().createQuery(this.getEntityClass());
        if (!StringUtil.isEmpty(skOpenApp.getAppName())) {
            query.field("appName").equal((Object)skOpenApp.getAppName());
            query.field("appType").equal((Object)skOpenApp.getAppType());
            if (null != query.get()) {
                throw new ServiceException("\u5df2\u7ecf\u5b58\u5728\u8be5\u540d\u79f0\u7684\u5e94\u7528\uff0c\u57fa\u4e8e\u5e94\u7528\u540d\u79f0\u552f\u4e00\u539f\u5219\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u4e00\u4e2a\u65b0\u540d\u79f0\u3002\u5982\u679c\u4f60\u8ba4\u4e3a\u5df2\u6709\u540d\u79f0\u4fb5\u72af\u4e86\u4f60\u7684\u5408\u6cd5\u6743\u76ca\uff0c\u53ef\u4ee5\u8fdb\u884c\u4fb5\u6743\u6295\u8bc9");
            }
        }
        SkOpenApp entity = new SkOpenApp(skOpenApp);
        this.getDatastore().save((Object)entity);
        SKBeanUtils.getOpenCheckLogManage().saveOpenCheckLogs(((SkOpenApp)query.get()).getAccountId(), null, ((SkOpenApp)query.get()).getAccountId(), String.valueOf(0), null);
        return entity;
    }

    public void deleteAppById(ObjectId id, String accountId) {
        Query query = (Query)((Query)this.getDatastore().createQuery(SkOpenApp.class).field("_id").equal((Object)id)).field("accountId").equal((Object)accountId);
        Query helQuery = (Query)this.getDatastore().createQuery(Helper.class).field("openAppId").equal((Object)id.toString());
        if (null != helQuery) {
            for (Helper heObject : helQuery.asList()) {
                Query groupHelQuery = (Query)this.getDatastore().createQuery(GroupHelper.class).field("helperId").equal((Object)heObject.getId().toString());
                this.getDatastore().delete(groupHelQuery);
            }
        }
        this.getDatastore().delete(helQuery);
        this.getDatastore().delete(query);
    }

    public List<SkOpenApp> appList(String userId, Integer type, Integer pageIndex, Integer pageSize) {
        Query query = (Query)((Query)this.getDatastore().createQuery(SkOpenApp.class).field("accountId").equal((Object)userId)).field("appType").equal((Object)type);
        return query.asList(this.pageFindOption(pageIndex, pageSize, 0));
    }

    public SkOpenApp appInfo(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("_id").equal((Object)id);
        return (SkOpenApp)query.get();
    }

    public void openAccess(SkOpenApp skOpenApp) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("_id").equal((Object)skOpenApp.getId());
        if (!StringUtil.isEmpty(skOpenApp.getAccountId())) {
            query.field("accountId").equal((Object)skOpenApp.getAccountId());
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (skOpenApp.getIsAuthShare() != 0) {
            ops.set("isAuthShare", (Object)skOpenApp.getIsAuthShare());
        }
        if (skOpenApp.getIsAuthLogin() != 0) {
            ops.set("isAuthLogin", (Object)skOpenApp.getIsAuthLogin());
        }
        if (skOpenApp.getIsAuthPay() != 0) {
            ops.set("isAuthPay", (Object)skOpenApp.getIsAuthPay());
        }
        if (skOpenApp.getIsGroupHelper() != 0) {
            ops.set("isGroupHelper", (Object)skOpenApp.getIsGroupHelper());
        }
        if (!StringUtil.isEmpty(skOpenApp.getHelperName())) {
            ops.set("helperName", (Object)skOpenApp.getHelperName());
        }
        if (!StringUtil.isEmpty(skOpenApp.getHelperDesc())) {
            ops.set("helperDesc", (Object)skOpenApp.getHelperDesc());
        }
        if (!StringUtil.isEmpty(skOpenApp.getHelperDeveloper())) {
            ops.set("helperDeveloper", (Object)skOpenApp.getHelperDeveloper());
        }
        if (!StringUtil.isEmpty(skOpenApp.getPayCallBackUrl())) {
            ops.set("payCallBackUrl", (Object)skOpenApp.getPayCallBackUrl());
        }
        this.getDatastore().update(query, ops);
    }

    public void approvedAPP(String id, Integer status, String userId, String reason) {
        Query query = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal((Object)new ObjectId(id));
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("status", (Object)status);
        String appId = null;
        if (!StringUtil.isEmpty(((SkOpenApp)query.get()).getAppId())) {
            appId = ((SkOpenApp)query.get()).getAppId();
        }
        if (1 == status) {
            appId = SkOpenUtil.getAppId();
            ops.set("appId", (Object)appId);
            ops.set("appSecret", (Object)SkOpenUtil.getAppScrect(appId));
        }
        this.getDatastore().update(query, ops);
        SKBeanUtils.getOpenCheckLogManage().saveOpenCheckLogs(((SkOpenApp)query.get()).getAccountId(), appId, userId, String.valueOf(status), reason);
    }

    public void allowAccess() {
    }

    public SkOpenApp authorization(String appId, String appSecret) {
        Query query = (Query)this.createQuery().field("appId").equal((Object)appId);
        SkOpenApp skOpenApp = (SkOpenApp)query.get();
        if (null == skOpenApp) {
            throw new ServiceException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        if (null != skOpenApp && skOpenApp.getStatus() < 1) {
            throw new ServiceException("\u5e94\u7528\u72b6\u6001\u5f02\u5e38\uff01");
        }
        if (skOpenApp.getAppSecret().equals(appSecret)) {
            return skOpenApp;
        }
        throw new ServiceException("appSercret \u9519\u8bef");
    }

    public void authInterfaceWeb(String appId, int type) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        if (null == query.get()) {
            throw new ServiceException("\u8be5\u7b2c\u4e09\u65b9\u7f51\u7ad9\u5e73\u53f0\u5c1a\u672a\u7533\u8bf7");
        }
        switch (type) {
            case 1: {
                if (((SkOpenApp)query.get()).getIsAuthLogin() == 1) break;
                throw new ServiceException("\u767b\u5f55\u6743\u9650\u672a\u5f00\u901a");
            }
            case 2: {
                if (((SkOpenApp)query.get()).getIsAuthShare() == 1) break;
                throw new ServiceException("\u5206\u4eab\u6743\u9650\u672a\u5f00\u901a");
            }
            case 3: {
                if (((SkOpenApp)query.get()).getIsAuthPay() == 1) break;
                throw new ServiceException("\u652f\u4ed8\u6743\u9650\u672a\u5f00\u901a");
            }
        }
    }

    public int authInterface(String appId, String appSecret, int type) {
        int flag = 0;
        Query query = (Query)((Query)SKBeanUtils.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId)).field("appSecret").equal((Object)appSecret);
        SkOpenApp openApp = (SkOpenApp)query.get();
        switch (type) {
            case 1: {
                if (openApp.getIsAuthLogin() != 1) {
                    throw new ServiceException("\u767b\u5f55\u6743\u9650\u672a\u5f00\u901a");
                }
                flag = 1;
                break;
            }
            case 2: {
                if (openApp.getIsAuthShare() != 1) {
                    throw new ServiceException("\u5206\u4eab\u6743\u9650\u672a\u5f00\u901a");
                }
                flag = 1;
                break;
            }
            case 3: {
                if (openApp.getIsAuthPay() != 1) {
                    throw new ServiceException("\u652f\u4ed8\u6743\u9650\u672a\u5f00\u901a");
                }
                flag = 1;
                break;
            }
        }
        return flag;
    }

    public Map<String, String> authorizeUrl(String appId, String callbackUrl) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        SkOpenApp skOpenWeb = (SkOpenApp)query.get();
        if (null == skOpenWeb) {
            throw new ServiceException("\u8be5\u7f51\u7ad9\u672a\u5728\u5f00\u653e\u5e73\u53f0\u5c1a\u672a\u7533\u8bf7");
        }
        if (!callbackUrl.equals(skOpenWeb.getCallbackUrl())) {
            throw new ServiceException("\u56de\u8c03\u5730\u5740\u548c\u7533\u8bf7\u586b\u5199\u7684\u56de\u8c03\u5730\u5740\u4e0d\u7b26\u5408");
        }
        ConcurrentMap webInfo = Maps.newConcurrentMap();
        webInfo.put("webAppName", skOpenWeb.getAppName());
        webInfo.put("webAppsmallImg", skOpenWeb.getAppsmallImg());
        return webInfo;
    }

    public String codeAuthorCheckImpl(String appId, String state) throws Exception {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        if (null == query.get()) {
            throw new ServiceException("\u8be5\u5e94\u7528\u672a\u5728\u5f00\u653e\u5e73\u53f0\u5c1a\u672a\u7533\u8bf7");
        }
        String time = String.valueOf(DateUtil.currentTimeSeconds());
        String userId = KSessionUtil.getUserIdBytoken(state);
        if (StringUtil.isEmpty(userId)) {
            throw new ServiceException("state\u65e0\u6548");
        }
        String desUserId = DesUtil.encrypt(userId, time);
        String str = appId.length() + appId + time + desUserId;
        String encodeBuffer = new BASE64Encoder().encodeBuffer(str.getBytes());
        return encodeBuffer;
    }

    public Map<String, String> codeOauthImpl(String code) throws Exception {
        long currTime = DateUtil.currentTimeSeconds();
        byte[] decodeBuffer = new BASE64Decoder().decodeBuffer(code);
        this.logger.info("=== \u89e3\u5bc6 code === : " + decodeBuffer.toString());
        String strByte = new String(decodeBuffer);
        String codeTime = strByte.substring(20, 20 + String.valueOf(currTime).length());
        Long endTime = Long.valueOf(codeTime);
        if (currTime - endTime > 180L || currTime - endTime < -180L) {
            this.logger.info(String.format("====> codeOauthImpl error server > %s client %s", currTime, endTime));
            throw new ServiceException("\u53c2\u6570 code \u5df2\u8fc7\u671f\u5931\u6548");
        }
        String appId = strByte.substring(2, 20);
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        if (null == query.get()) {
            throw new ServiceException("\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        }
        String desUserId = strByte.substring(30, strByte.length());
        User user = SKBeanUtils.getUserManager().getUser(Integer.valueOf(DesUtil.decrypt(desUserId, codeTime)));
        if (null == user) {
            throw new ServiceException("\u6682\u65e0\u6388\u6743\u7528\u6237");
        }
        Query find = (Query)this.getDatastore().createQuery(OpenLoginInfo.class).field("userId").equal((Object)user.getUserId());
        String openId = null;
        if (null == find.get()) {
            String substrAppId = appId.substring(2, appId.length());
            String openIdByte = user.getUserId().toString().length() + user.getUserId().toString() + substrAppId;
            this.logger.info("==== openId ====  length: " + user.getUserId().toString().length() + " userId : " + user.getUserId().toString() + "  subSK: " + substrAppId);
            this.logger.info("==== base64 ====  " + openIdByte);
            openId = new BASE64Encoder().encodeBuffer(openIdByte.getBytes());
            OpenLoginInfo loginInfo = new OpenLoginInfo(user.getUserId(), openId, appId, ((SkOpenApp)query.get()).getAppName(), 1);
            this.getDatastore().save((Object)loginInfo);
        } else {
            openId = ((OpenLoginInfo)find.get()).getOpenId();
        }
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put("nickName", user.getNickname());
        map.put("sex", user.getSex().toString());
        map.put("birthday", user.getBirthday().toString());
        map.put("provinceId", user.getProvinceId().toString());
        map.put("cityId", user.getCityId().toString());
        String imgUrl = SKBeanUtils.getAdminManager().getClientConfig().getDownloadAvatarUrl();
        String userImgUrl = imgUrl + "avatar/o/" + user.getUserId() % 10000 + "/" + user.getUserId() + ".jpg";
        map.put("image", userImgUrl);
        map.put("openId", openId);
        return map;
    }

    public SkOpenApp getOpenAppByAppId(String appId) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenApp.class).field("appId").equal((Object)appId);
        return (SkOpenApp)query.get();
    }

    public void addHelper(Helper entity) {
        entity.setCreateTime(DateUtil.currentTimeSeconds());
        SKBeanUtils.getDatastore().save((Object)entity);
    }

    public List<Helper> getHelperList(String openAppId, Integer pageIndex, Integer pageSize) {
        Query query = SKBeanUtils.getDatastore().createQuery(Helper.class);
        if (!StringUtil.isEmpty(openAppId)) {
            query.field("openAppId").equal((Object)openAppId);
        }
        return query.asList(this.pageFindOption(pageIndex, pageSize, 0));
    }

    public void updateHelper(Helper entity) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(Helper.class).field("_id").equal((Object)entity.getId());
        UpdateOperations ops = SKBeanUtils.getDatastore().createUpdateOperations(Helper.class);
        if (!StringUtil.isEmpty(entity.getName())) {
            ops.set("name", (Object)entity.getName());
        }
        if (!StringUtil.isEmpty(entity.getDesc())) {
            ops.set("desc", (Object)entity.getDesc());
        }
        if (!StringUtil.isEmpty(entity.getDeveloper())) {
            ops.set("developer", (Object)entity.getDeveloper());
        }
        if (!StringUtil.isEmpty(entity.getIconUrl())) {
            ops.set("iconUrl", (Object)entity.getIconUrl());
        }
        if (!StringUtil.isEmpty(entity.getLink())) {
            ops.set("link", (Object)entity.getLink());
        }
        if (!StringUtil.isEmpty(entity.getAppPackName())) {
            ops.set("appPackName", (Object)entity.getAppPackName());
        }
        if (!StringUtil.isEmpty(entity.getCallBackClassName())) {
            ops.set("callBackClassName", (Object)entity.getCallBackClassName());
        }
        if (null != entity.getOther()) {
            ops.set("other", (Object)entity.getOther());
        }
        ops.set("type", (Object)entity.getType());
        SKBeanUtils.getDatastore().update(query, ops);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteHelper(Integer userId, ObjectId id) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(Helper.class).field("_id").equal((Object)id);
        if (null == query.get()) throw new ServiceException("\u7fa4\u52a9\u624b\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
        System.out.println(((Helper)query.get()).getOpenAppId());
        Query queryOpenApp = (Query)SKBeanUtils.getDatastore().createQuery(SkOpenApp.class).field("_id").equal((Object)new ObjectId(((Helper)query.get()).getOpenAppId()));
        if (queryOpenApp.get() == null) throw new ServiceException("\u5e94\u7528\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
        if (!Integer.valueOf(((SkOpenApp)queryOpenApp.get()).getAccountId()).equals(userId)) return;
        Query groupHelQuery = (Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("helperId").equal((Object)((Helper)query.get()).getId().toString());
        SKBeanUtils.getDatastore().delete(groupHelQuery);
        SKBeanUtils.getDatastore().delete(query);
    }

    public JSONMessage sendMsgByGroupHelper(String roomId, Integer userId, @RequestParam(defaultValue="") String title, @RequestParam(defaultValue="") String desc, String imgUrl, Integer type, @RequestParam(defaultValue="") String url, String appId) {
        Query query = (Query)SKBeanUtils.getDatastore().createQuery(GroupHelper.class).field("roomId").equal((Object)roomId);
        GroupHelper groupHelper = null;
        if (null == query.get()) {
            return JSONMessage.failure("\u7fa4\u52a9\u624b\u4e0d\u5b58\u5728");
        }
        groupHelper = (GroupHelper)query.get();
        Room room = (Room)SKBeanUtils.getRoomManager().get((Serializable)new ObjectId(roomId));
        if (null == room) {
            return JSONMessage.failure("\u623f\u95f4\u4e0d\u5b58\u5728");
        }
        User user = (User)SKBeanUtils.getUserManager().get(userId);
        if (user == null) {
            return JSONMessage.failure("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SkOpenApp openApp = SKBeanUtils.getOpenAppManage().getOpenAppByAppId(appId);
        if (openApp == null) {
            return JSONMessage.failure("\u8be5\u5e94\u7528\u672a\u5728\u7b2c\u4e09\u65b9\u5e73\u53f0\u6ce8\u518c");
        }
        JSONObject body = new JSONObject();
        KXMPPServiceImpl.MessageBean messageBean = new KXMPPServiceImpl.MessageBean();
        if (type == 1) {
            body.put("appName", (Object)openApp.getAppName());
            body.put("appIcon", (Object)openApp.getAppImg());
            body.put("title", (Object)title);
            body.put("subTitle", (Object)desc);
            body.put("imageUrl", (Object)imgUrl);
            body.put("url", (Object)url);
            messageBean.setObjectId(body.toString());
            messageBean.setType(87);
        } else if (type == 2) {
            messageBean.setContent(imgUrl);
            messageBean.setType(2);
        }
        messageBean.setFromUserId(user.getUserId().toString());
        messageBean.setFromUserName(user.getNickname());
        messageBean.setRoomJid(groupHelper.getRoomJid());
        try {
            KXMPPServiceImpl.getInstance().sendMsgToGroupByJid(groupHelper.getRoomJid(), messageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSONMessage.success();
    }
}

