/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.LoginPassword;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.opensdk.entity.SkOpenAccount;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.User;
import cn.xyz.repository.mongo.MongoRepository;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service(value="openAccountManage")
public class OpenAccountManageImpl
extends MongoRepository<SkOpenAccount, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<SkOpenAccount> getEntityClass() {
        return SkOpenAccount.class;
    }

    public SkOpenAccount loginUserAccount(String telephone, String password, HttpServletRequest request, HttpServletResponse response) {
        SkOpenAccount account = null;
        User user = null;
        try {
            account = (SkOpenAccount)this.queryOne("telephone", telephone);
            if (null == account) {
                user = SKBeanUtils.getUserManager().getUser(telephone);
                request.getSession().setAttribute("openadmin", (Object)user);
                account = (SkOpenAccount)this.queryOne("userId", user.getUserId());
                account = new SkOpenAccount();
                account.setUserId(user.getUserId());
                account.setCreateTime(DateUtil.currentTimeSeconds());
                account.setTelephone(user.getTelephone());
                account.setPassword(user.getPassword());
                account.setId(new ObjectId());
                this.save(account);
            }
            if (null != account.getStatus() && account.getStatus() == -1) {
                throw new ServiceException("\u8be5\u8d26\u53f7\u5df2\u88ab\u7981\u7528");
            }
            if (!password.equals(account.getPassword()) && !(password = LoginPassword.encodeFromOldPassword(password)).equals(account.getPassword())) {
                throw new ServiceException(1040102);
            }
            return account;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return account;
        }
    }

    public void perfectUserInfo(SkOpenAccount skOpenAccount) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("userId").equal((Object)skOpenAccount.getUserId());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(SkOpenAccount.class);
        if (!StringUtil.isEmpty(skOpenAccount.getMail())) {
            ops.set("mail", (Object)skOpenAccount.getMail());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getIdCard())) {
            ops.set("idCard", (Object)skOpenAccount.getIdCard());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getTelephone())) {
            ops.set("telephone", (Object)skOpenAccount.getTelephone());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getAddress())) {
            ops.set("address", (Object)skOpenAccount.getAddress());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getRealName())) {
            ops.set("realName", (Object)skOpenAccount.getRealName());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getCompanyName())) {
            ops.set("companyName", (Object)skOpenAccount.getCompanyName());
        }
        if (!StringUtil.isEmpty(skOpenAccount.getBusinessLicense())) {
            ops.set("businessLicense", (Object)skOpenAccount.getBusinessLicense());
        }
        this.getDatastore().update(query, ops);
    }

    public void updatePassword(Integer userId, String oldPassword, String newPassword) throws Exception {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("userId").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(SkOpenAccount.class);
        if (!((SkOpenAccount)query.get()).getPassword().equals(oldPassword)) {
            throw new Exception("\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        ops.set("password", (Object)newPassword);
        this.getDatastore().update(query, ops);
    }

    public SkOpenAccount ckeckOpenAccount(String telephone, String password) {
        Query query = (Query)((Query)this.getDatastore().createQuery(SkOpenAccount.class).field("telephone").equal((Object)telephone)).field("password").equal((Object)password);
        return (SkOpenAccount)query.get();
    }

    public SkOpenAccount getOpenAccount(Integer userId) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("userId").equal((Object)userId);
        return (SkOpenAccount)query.get();
    }

    public void applyDeveloper(Integer userId, int status) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("userId").equal((Object)userId);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(SkOpenAccount.class);
        ops.set("status", (Object)status);
        ops.set("modifyTime", (Object)DateUtil.currentTimeSeconds());
        this.getDatastore().update(query, ops);
    }

    public PageResult<SkOpenAccount> developerList(int pageIndex, int pageSize, int status, String keyWorld) {
        Query query = this.getDatastore().createQuery(SkOpenAccount.class);
        if (status != -2) {
            query.field("status").equal((Object)status);
        }
        if (!StringUtil.isEmpty(keyWorld)) {
            query.or(new Criteria[]{(Criteria)query.criteria("userId").contains(keyWorld), (Criteria)query.criteria("telephone").contains(keyWorld)});
        }
        PageResult<SkOpenAccount> data = new PageResult<SkOpenAccount>();
        data.setCount(query.count());
        data.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return data;
    }

    public void deleteDeveloper(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    public void checkDeveloper(ObjectId id, int status) {
        Query query = (Query)this.getDatastore().createQuery(SkOpenAccount.class).field("_id").equal((Object)id);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(SkOpenAccount.class);
        ops.set("status", (Object)status);
        ops.set("verifyTime", (Object)DateUtil.currentTimeSeconds());
        this.getDatastore().update(query, ops);
    }
}

