/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.opensdk;

import cn.xyz.mianshi.model.OfficialInfo;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.mongo.MongoRepository;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class OfficialInfoCheckImpl
extends MongoRepository<OfficialInfo, ObjectId> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<OfficialInfo> getEntityClass() {
        return OfficialInfo.class;
    }

    public PageResult<OfficialInfo> getOfficialInfoList(int pageIndex, int pageSize) {
        Query query = this.getDatastore().createQuery(OfficialInfo.class);
        PageResult<OfficialInfo> data = new PageResult<OfficialInfo>();
        data.setCount(query.count());
        data.setData(query.asList(this.pageFindOption(pageIndex, pageSize, 1)));
        return data;
    }

    public void delOfficialInfoLog(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(OfficialInfo.class).field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }

    public OfficialInfo getOfficialInfo(ObjectId id) {
        Query query = (Query)this.getDatastore().createQuery(OfficialInfo.class).field("_id").equal((Object)id);
        return (OfficialInfo)query.get();
    }

    public OfficialInfo getOfficialInfo(String telephone) {
        Query query = (Query)this.getDatastore().createQuery(OfficialInfo.class).field("telephone").equal((Object)telephone);
        return (OfficialInfo)query.get();
    }

    public OfficialInfo updateOfficialInfo(ObjectId id, int verify, String feedback) {
        Query q = (Query)this.getDatastore().createQuery(OfficialInfo.class).field("_id").equal((Object)id);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("verify", (Object)verify);
        ops.set("feedback", (Object)feedback);
        return (OfficialInfo)this.getDatastore().findAndModify(q, ops);
    }

    public OfficialInfo updateOfficialInfoByTel(OfficialInfo info) {
        Query q = (Query)this.getDatastore().createQuery(OfficialInfo.class).field("telephone").equal((Object)info.getTelephone());
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set("verify", (Object)0);
        ops.set("feedback", (Object)"");
        ops.set("adminID", (Object)info.getFeedback());
        ops.set("adminName", (Object)info.getAdminName());
        ops.set("adminTelephone", (Object)info.getAdminTelephone());
        ops.set("companyBusinessLicense", (Object)info.getCompanyBusinessLicense());
        ops.set("companyName", (Object)info.getCompanyName());
        ops.set("companyType", (Object)info.getCompanyType());
        ops.set("desc", (Object)info.getDesc());
        return (OfficialInfo)this.getDatastore().findAndModify(q, ops);
    }
}

