/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.model;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PressureParam;
import cn.xyz.mianshi.utils.SKBeanUtils;
import com.alibaba.fastjson.JSON;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PressureThread
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(PressureThread.class);
    private PressureParam param;
    private String jid;
    private String roomName;
    private AtomicInteger mySendCount;
    private List<MultiUserChat> mucChats = Collections.synchronizedList(new ArrayList());

    public PressureThread() {
    }

    public PressureThread(String jid, PressureParam param, List<MultiUserChat> mucChats) {
        this.jid = jid;
        this.param = param;
        this.mucChats = mucChats;
        this.mySendCount = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.param.getAtomic().get() >= this.param.getSendAllCount()) {
            return;
        }
        int i = this.mySendCount.get();
        if (i >= this.param.getSendMsgNum()) {
            return;
        }
        this.roomName = SKBeanUtils.getRoomManager().getRoomName(this.jid);
        String content = "=== ";
        MultiUserChat muc = null;
        MessageBean messageBean = null;
        String userId = null;
        long timeSend = 0L;
        int nextInt = new Random().nextInt(this.mucChats.size());
        muc = this.mucChats.get(nextInt);
        messageBean = new MessageBean();
        userId = muc.getNickname().toString();
        messageBean.setFromUserId(userId);
        messageBean.setFromUserName(userId);
        messageBean.setToUserId(this.jid);
        messageBean.setType(1);
        timeSend = DateUtil.getSysCurrentTimeMillis_sync() + (long)i;
        messageBean.setTimeSend(this.getTimeSend(timeSend));
        messageBean.setMessageId(StringUtil.randomUUID());
        messageBean.setContent(this.param.getTimeStr() + " " + userId + " " + content + i);
        try {
            muc.sendMessage(messageBean.toString());
            logger.info(" timeStr {}  {}  === {}  sendMsg muc  {} count {}  {}  time {}", new Object[]{this.param.getTimeStr(), userId, this.roomName, i, this.param.getAtomic().incrementAndGet(), messageBean.getTimeSend()});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            this.mySendCount.incrementAndGet();
        }
    }

    public String getMucChatServiceName(XMPPTCPConnection conn) {
        return "@muc." + conn.getXMPPServiceDomain();
    }

    private double getTimeSend(long ts) {
        double time = ts;
        DecimalFormat dFormat = new DecimalFormat("#.000");
        return new Double(dFormat.format(time / 1000.0));
    }

    public static String getFullString() {
        return new SimpleDateFormat("MM-dd HH:mm").format(PressureThread.currentTimeSeconds());
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis();
    }

    public static class MessageBean {
        private Object content;
        private String fileName;
        private String fromUserId = "10005";
        private String fromUserName = "10005";
        private Object objectId;
        private double timeSend;
        private String toUserId;
        private String toUserName;
        private int fileSize;
        private int type;
        private String messageId;
        private String other;

        public Object getContent() {
            return this.content;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFromUserId() {
            return this.fromUserId;
        }

        public String getFromUserName() {
            return this.fromUserName;
        }

        public Object getObjectId() {
            return this.objectId;
        }

        public double getTimeSend() {
            return this.timeSend;
        }

        public String getToUserId() {
            return this.toUserId;
        }

        public String getToUserName() {
            return this.toUserName;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        public int getType() {
            return this.type;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFromUserId(String fromUserId) {
            this.fromUserId = fromUserId;
        }

        public void setFromUserName(String fromUserName) {
            this.fromUserName = fromUserName;
        }

        public void setObjectId(Object objectId) {
            this.objectId = objectId;
        }

        public void setTimeSend(double timeSend) {
            this.timeSend = timeSend;
        }

        public void setToUserId(String toUserId) {
            this.toUserId = toUserId;
        }

        public void setToUserName(String toUserName) {
            this.toUserName = toUserName;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }
    }
}

