/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.lable;

import cn.xyz.mianshi.lable.Label;
import cn.xyz.mianshi.lable.LabelRepository;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Service;

@Service
public class LabelRepositoryImpl
extends MongoRepository<Label, ObjectId>
implements LabelRepository {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<Label> getEntityClass() {
        return Label.class;
    }

    @Override
    public Object createLabel(Label label) {
        return this.getDatastore().save((Object)label);
    }

    @Override
    public List<Label> getLabelList(Integer userId) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("userId").equal((Object)userId);
        return q.asList();
    }

    @Override
    public Label getLabel(ObjectId labelId) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("id").equal((Object)labelId);
        return (Label)q.get();
    }

    @Override
    public Label getLabelByCode(String code) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("code").equal((Object)code);
        return (Label)q.get();
    }

    @Override
    public Label updateLabel(Label label) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("code").equal((Object)label.getCode());
        if (q.get() == null) {
            return null;
        }
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != label.getName()) {
            ops.set("name", (Object)label.getName());
        }
        if (null != label.getLogo()) {
            ops.set("logo", (Object)label.getLogo());
        }
        if (null != label.getMark()) {
            ops.set("mark", (Object)label.getMark());
        }
        return (Label)this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public Object saveLabel(ObjectId id, String logo, String name) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("id").equal((Object)id);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        if (null != name) {
            ops.set("name", (Object)name);
        }
        if (null != logo) {
            ops.set("logo", (Object)logo);
        }
        return this.getDatastore().findAndModify(q, ops);
    }

    @Override
    public Label queryLabelByName(String name) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("name").equal((Object)name);
        return (Label)q.get();
    }
}

