/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.lable;

import cn.xyz.mianshi.lable.Label;
import cn.xyz.mianshi.lable.LabelManager;
import cn.xyz.mianshi.lable.LabelRepositoryImpl;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.repository.mongo.MongoRepository;
import java.util.List;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelManagerImpl
extends MongoRepository<Label, Integer>
implements LabelManager {
    @Autowired
    LabelRepositoryImpl repository;

    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getLocalSpringBeanManager().getDatastore();
    }

    @Override
    public Class<Label> getEntityClass() {
        return Label.class;
    }

    @Override
    public Label createLabel(Integer userId) {
        Label label = new Label();
        label.setId(new ObjectId());
        label.setUserId(userId);
        String code = UUID.randomUUID().toString().replace("-", "");
        label.setCode(code);
        this.repository.createLabel(label);
        return label;
    }

    @Override
    public Label createLabelByParams(Integer userId, String logo, String name) {
        Label label = new Label();
        label.setId(new ObjectId());
        label.setUserId(userId);
        String code = UUID.randomUUID().toString().replace("-", "");
        label.setCode(code);
        label.setLogo(logo);
        label.setName(name);
        Object object = this.repository.createLabel(label);
        return label;
    }

    @Override
    public Label getLabel(ObjectId labelId) {
        return this.repository.getLabel(labelId);
    }

    @Override
    public Label getLabelByCode(String code) {
        return this.repository.getLabelByCode(code);
    }

    @Override
    public List<Label> getLabelList(Integer userId) {
        return this.repository.getLabelList(userId);
    }

    @Override
    public Label updateLabel(Label label) {
        return this.repository.updateLabel(label);
    }

    @Override
    public Object saveLabel(ObjectId id, String logo, String name) {
        return this.repository.saveLabel(id, logo, name);
    }

    @Override
    public Label queryLabelByName(String name) {
        return this.repository.queryLabelByName(name);
    }
}

