/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.mianshi.dao;

import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.utils.SKBeanUtils;
import cn.xyz.mianshi.vo.KeyWord;
import cn.xyz.mianshi.vo.MsgIntercept;
import cn.xyz.repository.mongo.MongoRepository;
import java.io.Serializable;
import java.util.List;
import org.apache.poi.hssf.record.formula.functions.T;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.springframework.stereotype.Repository;

@Repository
public class MsgInferceptDAO
extends MongoRepository<T, Serializable> {
    @Override
    public Datastore getDatastore() {
        return SKBeanUtils.getDatastore();
    }

    @Override
    public Class<T> getEntityClass() {
        return null;
    }

    public void saveKeyword(KeyWord keyWord) {
        this.getDatastore().save((Object)keyWord);
    }

    public void updateKeyword(String word, ObjectId id) {
        Query query = this.getDatastore().createQuery(KeyWord.class);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(KeyWord.class);
        ops.set("word", (Object)word);
        ops.set("createTime", (Object)DateUtil.currentTimeSeconds());
        this.getDatastore().update(query, ops);
    }

    public void deleteKeyword(ObjectId id) {
        Query query = this.getDatastore().createQuery(KeyWord.class);
        query.field("_id").equal((Object)id);
        this.getDatastore().delete(query.get());
    }

    public List<KeyWord> queryKeywordList(String word, int pageIndex, int pageSize) {
        Query query = this.getDatastore().createQuery(KeyWord.class);
        if (!StringUtil.isEmpty(word)) {
            query.filter("word", (Object)word);
        }
        List list = null;
        list = query.order("-createTime").asList(new FindOptions().skip(pageIndex * pageSize).limit(pageSize));
        return list;
    }

    public List<MsgIntercept> queryMsgInerceptList(Integer userId, String toUserId, int pageIndex, int pageSize, int type, String content) {
        Query query = this.getDatastore().createQuery(MsgIntercept.class);
        if (!StringUtil.isEmpty(content)) {
            query.filter("content", (Object)content);
        }
        if (null != userId) {
            query.filter("sender", (Object)userId);
        }
        if (type == 0) {
            if (!StringUtil.isEmpty(toUserId)) {
                query.filter("receiver", (Object)Integer.valueOf(toUserId));
            }
            query.field("roomJid").equal(null);
        } else if (type == 1) {
            if (!StringUtil.isEmpty(toUserId)) {
                query.filter("roomJid", (Object)toUserId);
            }
            query.field("roomJid").notEqual(null);
        }
        List data = query.offset(pageSize * pageIndex).limit(pageSize).asList();
        return data;
    }

    public void deleteMsgIntercept(ObjectId id) {
        Query query = this.getDatastore().createQuery(MsgIntercept.class);
        query.field("_id").equal((Object)id);
        this.getDatastore().delete(query);
    }
}

