/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.vo;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.DateUtil;
import cn.xyz.commons.utils.ReqUtil;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.model.PageResult;
import cn.xyz.mianshi.utils.ConstantUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessage
extends JSONObject {
    private static final long serialVersionUID = 1L;
    public static final Object EMPTY_OBJECT = new Object();
    private static Logger logger = LoggerFactory.getLogger(JSONMessage.class);

    public static JSONMessage success(String resultMsg, Object data) {
        return new JSONMessage(1, resultMsg, data);
    }

    public static JSONMessage success() {
        return new JSONMessage(1, null);
    }

    public static JSONMessage success(Object data) {
        return new JSONMessage(1, null, data);
    }

    public static JSONMessage success(int resultCode, Object data) {
        String msg = ConstantUtil.getMsgByCode(String.valueOf(resultCode), ReqUtil.getRequestLanguage());
        return new JSONMessage(1, msg, data);
    }

    public static JSONMessage failure(String resultMsg) {
        return new JSONMessage(0, resultMsg);
    }

    public static JSONMessage success(PageResult result) {
        JSONMessage success = JSONMessage.success(null, result.getData());
        success.put("count", result.getCount());
        success.put("total", result.getTotal());
        success.put("totalVo", result.getTotalVo());
        return success;
    }

    public static JSONMessage error(Exception e) {
        return JSONMessage.failureByException(e);
    }

    public static JSONMessage failureByErrCode(Integer errCode, Object data) {
        String msg = ConstantUtil.getMsgByCode(errCode.toString(), ReqUtil.getRequestLanguage());
        if (null != msg) {
            return new JSONMessage((int)errCode, msg, data);
        }
        return new JSONMessage(1020101, "");
    }

    public static JSONMessage failureByErrCode(Integer errCode) {
        return JSONMessage.failureByErrCode(errCode, ReqUtil.getRequestLanguage());
    }

    public static JSONMessage failureByException(Exception e) {
        if (e instanceof ServiceException) {
            ServiceException s = (ServiceException)e;
            if (0 == s.getResultCode() && !StringUtil.isEmpty(s.getMessage())) {
                return JSONMessage.failure(s.getMessage());
            }
            return JSONMessage.failureByErrCode((Integer)s.getResultCode(), ReqUtil.getRequestLanguage());
        }
        logger.error(e.getMessage(), (Throwable)e);
        return JSONMessage.failureByErrCode((Integer)1020101, ReqUtil.getRequestLanguage());
    }

    public static JSONMessage failureByErrCode(Integer errCode, String language) {
        String msg;
        if (StringUtil.isEmpty(language)) {
            language = "zh";
        }
        if (null != (msg = ConstantUtil.getMsgByCode(String.valueOf(errCode), language))) {
            logger.info("===     {}     =======>", (Object)msg);
            return new JSONMessage(errCode, msg);
        }
        return new JSONMessage(1020101, "");
    }

    public static JSONMessage failureByErr(ServiceException e, String language, Object data) {
        if (0 != e.getResultCode()) {
            String msg;
            if (1040106 == e.getResultCode()) {
                return new JSONMessage(1040106, e.getMessage(), data);
            }
            if (!StringUtil.isEmpty(e.getLanguage())) {
                language = e.getLanguage();
            }
            if (null != (msg = ConstantUtil.getMsgByCode(e.getResultCode() + "", language))) {
                logger.info("===     {}     =======>", (Object)msg);
                return new JSONMessage(e.getResultCode(), msg, data);
            }
        } else if (null != e.getResultMap()) {
            return new JSONMessage(e.getErrCode(), e.getResultMap().get(language));
        }
        return new JSONMessage(1020101, "");
    }

    public static JSONMessage failureByErr(ServiceException e, String language) {
        if (0 != e.getResultCode()) {
            String msg;
            if (1040106 == e.getResultCode()) {
                return new JSONMessage(1040106, e.getMessage());
            }
            if (!StringUtil.isEmpty(e.getLanguage())) {
                language = e.getLanguage();
            }
            if (null != (msg = ConstantUtil.getMsgByCode(e.getResultCode() + "", language))) {
                logger.info("===     {}     =======>", (Object)msg);
                return new JSONMessage(e.getResultCode(), msg);
            }
        } else if (null != e.getResultMap()) {
            return new JSONMessage(e.getErrCode(), e.getResultMap().get(language));
        }
        return new JSONMessage(1020101, "");
    }

    public JSONMessage() {
    }

    public JSONMessage(String errCode, String resultMsg, Object data) {
        this.setResultCode(errCode);
        this.setErrCode(errCode);
        this.setResultMsg(resultMsg);
        this.setDetailMsg(resultMsg);
        this.setData(data);
        this.setCurrentTime(DateUtil.currentTimeMilliSeconds() + "");
    }

    public JSONMessage(int resultCode, String resultMsg) {
        this.setResultCode(resultCode);
        if (0 == resultCode && StringUtil.isEmpty(resultMsg)) {
            this.setResultMsg(ConstantUtil.getMsgByCode(resultCode + "", ReqUtil.getRequestLanguage()));
        } else {
            this.setResultMsg(resultMsg);
        }
        this.setCurrentTime(DateUtil.currentTimeMilliSeconds());
    }

    public JSONMessage(int resultCode, String resultMsg, String detailMsg) {
        this.setResultCode(resultCode);
        this.setResultMsg(resultMsg);
        this.setDetailMsg(detailMsg);
        this.setCurrentTime(DateUtil.currentTimeMilliSeconds());
    }

    public static JSONMessage failureByErrCodeAndData(Integer errCode, Object data) {
        String msg = ConstantUtil.getMsgByCode(String.valueOf(errCode), ReqUtil.getRequestLanguage());
        if (null != msg) {
            return new JSONMessage((int)errCode, msg, data);
        }
        return new JSONMessage((int)errCode, "", data);
    }

    public JSONMessage(int resultCode, String resultMsg, Object data) {
        this.setResultCode(resultCode);
        this.setResultMsg(resultMsg);
        this.setData(data);
        this.setCurrentTime(DateUtil.currentTimeMilliSeconds());
    }

    public JSONMessage(String groupCode, String serviceCode, String nodeCode, String resultMsg) {
        this.setResultCode(new StringBuffer().append(groupCode).append(serviceCode).append(nodeCode).toString());
        this.setResultMsg(resultMsg);
    }

    public JSONMessage(String errCode, String resultMsg) {
        this.setResultCode(errCode);
        this.setErrCode(errCode);
        this.setResultMsg(resultMsg);
        this.setDetailMsg(resultMsg);
        this.setData(new Object());
        this.setCurrentTime(DateUtil.currentTimeMilliSeconds() + "");
    }

    public Object getCurrentTime() {
        return this.get("currentTime");
    }

    public void setCurrentTime(Object currentTime) {
        this.put("currentTime", currentTime);
    }

    public Object getErrCode() {
        return this.get("errCode");
    }

    public void setErrCode(Object errCode) {
        this.put("errCode", errCode);
    }

    public Object getResultCode() {
        return this.get("resultCode");
    }

    public void setResultCode(Object resultCode) {
        this.put("resultCode", resultCode);
    }

    public String getResultMsg() {
        return this.getString("resultMsg");
    }

    public void setResultMsg(String resultMsg) {
        this.put("resultMsg", resultMsg);
    }

    public String getDetailMsg() {
        return this.getString("detailMsg");
    }

    public void setDetailMsg(String detailMsg) {
        this.put("detailMsg", detailMsg);
    }

    public Object getData() {
        return this.get("data");
    }

    public void setData(Object data) {
        this.put("data", data);
    }

    public String toString() {
        return JSON.toJSONString((Object)((Object)this));
    }
}

