/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import cn.xyz.commons.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.bson.types.ObjectId;

public final class ReflectionUtils {
    public static <T> T deepCopy(Object obj, Class<?> clazz) throws Exception {
        Object newInstance = clazz.newInstance();
        for (Field field : obj.getClass().getDeclaredFields()) {
            String propName = ReflectionUtils.getPropName(field);
            Object value = ReflectionUtils.getValue(obj, propName);
            if (null == value) continue;
            ReflectionUtils.setValue(newInstance, field, propName, value);
        }
        return (T)newInstance;
    }

    public static String getPropName(Field field) {
        return new StringBuffer().append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1)).toString();
    }

    public static Object getValue(Object obj, String propName) {
        Object value = null;
        String name = new StringBuffer().append("get").append(propName).toString();
        try {
            Method method = obj.getClass().getDeclaredMethod(name, new Class[0]);
            value = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static <T> T mapToBean(Map<String, String> mapSrc, Class<?> clazz) {
        try {
            Object objTo = clazz.newInstance();
            for (String key : mapSrc.keySet()) {
                String value = mapSrc.get(key);
                ReflectionUtils.setValue(objTo, clazz, "_id".equals(key) ? "userId" : key, value);
            }
            return (T)objTo;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
    }

    public static <T> T parse(HttpServletRequest request, Class<?> cls) {
        T obj = null;
        try {
            obj = (T)cls.newInstance();
            for (Field field : cls.getDeclaredFields()) {
                String s = request.getParameter(field.getName());
                if (StringUtil.isEmpty(s)) continue;
                Object value = null;
                switch (field.getType().getTypeName()) {
                    case "java.lang.Object": {
                        break;
                    }
                    case "int": 
                    case "java.lang.Integer": {
                        value = Integer.parseInt(s);
                        break;
                    }
                    case "long": 
                    case "java.lang.Long": {
                        value = Long.parseLong(s);
                        break;
                    }
                    case "java.lang.String": {
                        value = s;
                        break;
                    }
                    case "org.bson.types.ObjectId": {
                        value = new ObjectId(s);
                        break;
                    }
                    case "java.util.List": {
                        if (!(field.getGenericType() instanceof ParameterizedType)) break;
                        ParameterizedType pt = (ParameterizedType)field.getGenericType();
                        Class clazz = (Class)pt.getActualTypeArguments()[0];
                        value = JSON.parseArray((String)s, (Class)clazz);
                    }
                }
                if (null == value) continue;
                ReflectionUtils.setValue(cls, obj, field, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570\u89e3\u6790\u5931\u8d25");
        }
        return null == obj ? null : obj;
    }

    public static void setValue(Class<?> cls, Object obj, Field field, Object value) throws Exception {
        String name = MessageFormat.format("set{0}{1}", field.getName().substring(0, 1).toUpperCase(), field.getName().substring(1));
        Method method = cls.getDeclaredMethod(name, field.getType());
        method.invoke(obj, value);
    }

    public static void setValue(Object obj, Class<?> clazz, String key, String value) {
        try {
            Field field = clazz.getDeclaredField(key);
            field.setAccessible(true);
            switch (field.getType().getTypeName()) {
                case "java.lang.Byte": {
                    field.set(obj, Byte.parseByte(value));
                    break;
                }
                case "java.lang.Integer": {
                    field.set(obj, Integer.parseInt(value));
                    break;
                }
                case "java.util.Date": {
                    break;
                }
                default: {
                    field.set(obj, value);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setValue(Object obj, Field field, String propName, Object value) {
        String name = new StringBuffer().append("set").append(propName).toString();
        try {
            Method method = obj.getClass().getDeclaredMethod(name, field.getType());
            method.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

