/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import com.shiku.utils.encrypt.MAC;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class OtpHelper {
    private static long sTimeMinute = 0L;
    private static byte sRandByte = 0;

    public static long otp(String apiKey, int userId, long timeMinute, byte[] key, byte randByte) {
        String content = apiKey + userId + (randByte & 0xFF) + timeMinute;
        byte[] hash = MAC.encode((byte[])content.getBytes(), (byte[])key);
        return OtpHelper.byteArrayToLong(hash, randByte);
    }

    public static QrCode parse(long qrCode) {
        int userId = (int)(qrCode >> 32);
        long otp = qrCode & 0xFFFFFFFFL;
        return new QrCode(userId, otp);
    }

    public static QrCode parse(String qrCode) {
        return OtpHelper.parse(Long.valueOf(qrCode));
    }

    public static long byteArrayToLong(byte[] hash, byte randByte) {
        if (hash.length != 4) {
            hash = Arrays.copyOf(hash, 4);
        }
        hash[3] = randByte;
        int i = ByteBuffer.wrap(hash).order(ByteOrder.LITTLE_ENDIAN).getInt();
        return (long)i & 0xFFFFFFFFL;
    }

    public static class QrCode {
        private int userId;
        private long otp;
        private byte randByte;

        public QrCode(int userId, long otp) {
            this.userId = userId;
            this.otp = otp;
            this.randByte = (byte)(otp >> 24);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QrCode qrCode = (QrCode)o;
            return this.userId == qrCode.userId && this.otp == qrCode.otp && this.randByte == qrCode.randByte;
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.otp, this.randByte);
        }

        public long getQrCode() {
            return ((long)this.userId << 32) + this.otp;
        }

        public String getQrCodeString() {
            return String.format(Locale.ENGLISH, "%019d", this.getQrCode());
        }

        public int getUserId() {
            return this.userId;
        }

        public long getOtp() {
            return this.otp;
        }

        public byte getRandByte() {
            return this.randByte;
        }
    }
}

