/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;

public class NumberUtil {
    private static int ROUND_HALF_UP = 4;

    public static void main(String[] args) {
        double d = 0.001;
        System.out.println(NumberUtil.getCeil(d, 2));
    }

    public static double getCeil(double d, int n) {
        BigDecimal b = new BigDecimal(String.valueOf(d));
        b = b.divide(BigDecimal.ONE, n, 2);
        return b.doubleValue();
    }

    public static int getRandomByMinAndMax(int min, int max) {
        Random rand = new Random();
        int randNum = 0;
        randNum = min == 0 ? rand.nextInt(max + 1) : rand.nextInt(max) + min;
        return randNum;
    }

    public static int getNum(int start, int end) {
        return (int)(Math.random() * (double)(end - start + 1) + (double)start);
    }

    public static int rounding(int num) {
        int n = (num + 5) / 10 * 10;
        return n;
    }

    public static String percentage(long current, long all, int num) {
        NumberFormat nt = NumberFormat.getPercentInstance();
        nt.setMinimumFractionDigits(num);
        double baifen = (double)current / (double)all;
        return nt.format(baifen);
    }

    public static BigDecimal getBigDecimalForStr(String str) {
        return new BigDecimal(str);
    }

    public static double getBigDecimalForStrReturnDouble(String str, Integer scale) {
        BigDecimal one = NumberUtil.getBigDecimalForStr(str);
        if (null != scale) {
            return one.setScale((int)scale, ROUND_HALF_UP).doubleValue();
        }
        return one.doubleValue();
    }

    public static BigDecimal getBigDecimalForDouble(double one) {
        return NumberUtil.getBigDecimalForStr(one + "");
    }

    public static double getScaleDouble(double one, Integer scale) {
        return NumberUtil.getBigDecimalForStrReturnDouble(one + "", scale);
    }

    public static double getScaleDouble(double one) {
        return NumberUtil.getScaleDouble(one, 2);
    }

    public static String getCurrencyFormat(BigDecimal one) {
        NumberFormat currency = NumberFormat.getCurrencyInstance();
        return currency.format(one);
    }

    public static String getCurrencyFormat(double one) {
        return NumberUtil.getCurrencyFormat(NumberUtil.getBigDecimalForStr(one + ""));
    }

    public static BigDecimal add(BigDecimal one, BigDecimal two) {
        return one.add(two);
    }

    public static BigDecimal add(String oneNumber, String twoNumber) {
        BigDecimal one = new BigDecimal(oneNumber);
        BigDecimal two = new BigDecimal(twoNumber);
        return NumberUtil.add(one, two);
    }

    public static BigDecimal add(double oneNumber, double twoNumber) {
        return NumberUtil.add(oneNumber + "", twoNumber + "");
    }

    public static double add(double one, double two, Integer scale) {
        BigDecimal b = NumberUtil.add(one, two);
        if (null != scale) {
            return b.setScale((int)scale, ROUND_HALF_UP).doubleValue();
        }
        return b.doubleValue();
    }

    public static double addReturnDouble(String oneNumber, String twoNumber, Integer scale) {
        BigDecimal b = NumberUtil.add(oneNumber, twoNumber);
        if (null != scale) {
            return b.setScale((int)scale, ROUND_HALF_UP).doubleValue();
        }
        return b.doubleValue();
    }

    public static BigDecimal subtract(BigDecimal one, BigDecimal two) {
        return one.subtract(two);
    }

    public static double subtractReturnDouble(BigDecimal one, BigDecimal two, Integer scale) {
        BigDecimal b = NumberUtil.subtract(one, two);
        if (null != scale) {
            return b.setScale((int)scale, ROUND_HALF_UP).doubleValue();
        }
        return b.doubleValue();
    }

    public static BigDecimal subtract(String oneNumber, String twoNumber) {
        BigDecimal one = new BigDecimal(oneNumber);
        BigDecimal two = new BigDecimal(twoNumber);
        return NumberUtil.subtract(one, two);
    }

    public static double subtractReturnDouble(double oneNumber, double twoNumber, Integer scale) {
        BigDecimal one = new BigDecimal(oneNumber + "");
        BigDecimal two = new BigDecimal(twoNumber + "");
        return NumberUtil.subtractReturnDouble(one, two, scale);
    }

    public static synchronized String get16UUID() {
        UUID id = UUID.randomUUID();
        String[] idd = id.toString().split("-");
        return idd[0] + idd[1] + idd[2];
    }

    public static boolean isNum(String str) {
        Pattern pattern = Pattern.compile("^-?[0-9]+");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String string) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(string).matches();
    }
}

