/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import cn.xyz.commons.utils.StringUtil;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public enum MongoDBUtil {
    instance;

    private static MongoClient mongoClient;

    public static MongoClient getMongoClient(String host, int port) {
        MongoClient mongoClient = new MongoClient(host, port);
        MongoClientOptions.Builder options = new MongoClientOptions.Builder();
        options.connectionsPerHost(300);
        options.connectTimeout(200000);
        options.maxWaitTime(200000);
        options.socketTimeout(200000);
        options.threadsAllowedToBlockForConnectionMultiplier(5000);
        options.writeConcern(WriteConcern.SAFE);
        options.build();
        return mongoClient;
    }

    public static MongoClient getMongoClient(String urIStr) {
        MongoClientURI uri = new MongoClientURI(urIStr);
        MongoClient mongoClient = new MongoClient(uri);
        MongoClientOptions.Builder options = new MongoClientOptions.Builder();
        options.connectionsPerHost(300);
        options.connectTimeout(200000);
        options.maxWaitTime(200000);
        options.socketTimeout(200000);
        options.threadsAllowedToBlockForConnectionMultiplier(5000);
        options.writeConcern(WriteConcern.SAFE);
        options.build();
        return mongoClient;
    }

    public static MongoDatabase getDB(String dbName) {
        if (dbName != null && !"".equals(dbName)) {
            MongoDatabase database = mongoClient.getDatabase(dbName);
            return database;
        }
        return null;
    }

    public static MongoDatabase getDB(MongoClient mongoClient, String dbName) {
        if (dbName != null && !"".equals(dbName)) {
            MongoDatabase database = mongoClient.getDatabase(dbName);
            return database;
        }
        return null;
    }

    public static DBCollection getDB(MongoClient mongoClient, String dbName, String tbName) {
        if (dbName != null && !"".equals(dbName)) {
            DB database = mongoClient.getDB(dbName);
            if (!StringUtil.isEmpty(tbName) && null != database) {
                return database.getCollection(tbName);
            }
        }
        return null;
    }

    public static MongoCollection<Document> getCollection(MongoClient mongoClient, String dbName, String collName) {
        if (null == collName || "".equals(collName)) {
            return null;
        }
        if (null == dbName || "".equals(dbName)) {
            return null;
        }
        MongoCollection collection = mongoClient.getDatabase(dbName).getCollection(collName);
        return collection;
    }

    public static MongoCollection<Document> getCollection(String dbName, String collName) {
        if (null == collName || "".equals(collName)) {
            return null;
        }
        if (null == dbName || "".equals(dbName)) {
            return null;
        }
        MongoCollection collection = mongoClient.getDatabase(dbName).getCollection(collName);
        return collection;
    }

    public static List<String> getAllCollections(String dbName) {
        MongoIterable colls = MongoDBUtil.getDB(dbName).listCollectionNames();
        ArrayList<String> _list = new ArrayList<String>();
        for (String s : colls) {
            _list.add(s);
        }
        return _list;
    }

    public static MongoIterable<String> getAllDBNames() {
        MongoIterable s = mongoClient.listDatabaseNames();
        return s;
    }

    public static void dropDB(String dbName) {
        MongoDBUtil.getDB(dbName).drop();
    }

    public static Document findById(MongoCollection<Document> coll, String id) {
        ObjectId _idobj = null;
        try {
            _idobj = new ObjectId(id);
        }
        catch (Exception e) {
            return null;
        }
        Document myDoc = (Document)coll.find(Filters.eq((String)"_id", (Object)_idobj)).first();
        return myDoc;
    }

    public static int getCount(MongoCollection<Document> coll) {
        int count = (int)coll.count();
        return count;
    }

    public static MongoCursor<Document> find(MongoCollection<Document> coll, Bson filter) {
        return coll.find(filter).iterator();
    }

    public MongoCursor<Document> findByPage(MongoCollection<Document> coll, Bson filter, int pageNo, int pageSize) {
        BasicDBObject orderBy = new BasicDBObject("_id", (Object)1);
        return coll.find(filter).sort((Bson)orderBy).skip((pageNo - 1) * pageSize).limit(pageSize).iterator();
    }

    public static int deleteById(MongoCollection<Document> coll, String id) {
        int count = 0;
        ObjectId _id = null;
        try {
            _id = new ObjectId(id);
        }
        catch (Exception e) {
            return 0;
        }
        Bson filter = Filters.eq((String)"_id", (Object)_id);
        DeleteResult deleteResult = coll.deleteOne(filter);
        count = (int)deleteResult.getDeletedCount();
        return count;
    }

    public static Document updateById(MongoCollection<Document> coll, String id, Document newdoc) {
        ObjectId _idobj = null;
        try {
            _idobj = new ObjectId(id);
        }
        catch (Exception e) {
            return null;
        }
        Bson filter = Filters.eq((String)"_id", (Object)_idobj);
        coll.updateOne(filter, (Bson)new Document("$set", (Object)newdoc));
        return newdoc;
    }

    public static void dropCollection(String dbName, String collName) {
        MongoDBUtil.getDB(dbName).getCollection(collName).drop();
    }

    public void close() {
        if (mongoClient != null) {
            mongoClient.close();
            mongoClient = null;
        }
    }

    public static void main(String[] args) {
        String dbName = "GC_MAP_DISPLAY_DB";
        String collName = "COMMUNITY_BJ";
        MongoCollection<Document> coll = MongoDBUtil.getCollection(dbName, collName);
        Bson filter = Filters.eq((String)"count", (Object)0);
        MongoDBUtil.find(coll, filter);
    }
}

