/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import cn.xyz.commons.ex.ServiceException;
import cn.xyz.commons.utils.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HttpUtil {
    private static Log log = LogFactory.getLog(HttpUtil.class);
    public static final String URL_PARAM_DECODECHARSET_UTF8 = "UTF-8";
    public static final String URL_PARAM_DECODECHARSET_GBK = "GBK";
    private static final String URL_PARAM_CONNECT_FLAG = "&";
    private static final String EMPTY = "";
    private static MultiThreadedHttpConnectionManager connectionManager = null;
    private static int connectionTimeOut = 25000;
    private static int socketTimeOut = 25000;
    private static int maxConnectionPerHost = 20;
    private static int maxTotalConnections = 20;
    private static HttpClient client;

    private static byte[] getBytes(Map<String, Object> data) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String key : data.keySet()) {
            sb.append(key).append('=').append(data.get(key)).append('&');
        }
        return sb.substring(0, sb.length() - 1).toString().getBytes(URL_PARAM_DECODECHARSET_UTF8);
    }

    public static String get(Request request) throws Exception {
        URL url = new URL(HttpUtil.buildSpec(request));
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setRequestMethod("GET");
        return FileUtil.readAll(urlConn.getInputStream());
    }

    private static String buildSpec(Request request) {
        Map<String, Object> params = request.getData();
        StringBuffer sb = new StringBuffer();
        sb.append(request.getSpec());
        if (!params.isEmpty()) {
            sb.append("?");
        }
        for (String key : params.keySet()) {
            sb.append(key).append('=').append(params.get(key)).append('&');
        }
        String spec = sb.substring(0, sb.length() - 1);
        System.out.println(spec);
        return spec;
    }

    public static String asString(Request request) throws Exception {
        URL url = new URL(request.getSpec());
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConn.setUseCaches(false);
        urlConn.setInstanceFollowRedirects(true);
        if (null != request.getData()) {
            OutputStream out = urlConn.getOutputStream();
            out.write(HttpUtil.getBytes(request.getData()));
            out.flush();
            out.close();
        }
        return FileUtil.readAll(urlConn.getInputStream());
    }

    public static String asBean(Request request) throws Exception {
        return HttpUtil.asString(request);
    }

    public static <T> T asBean(Request request, Class<?> clazz) throws Exception {
        String text = HttpUtil.asString(request);
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> T asBean(Map<String, Object> data, String spec, Class<?> clazz) throws Exception {
        return HttpUtil.asBean(new Request(data, spec), clazz);
    }

    public static byte[] getBytes(Object object) {
        SerializeWriter out = new SerializeWriter();
        JSONSerializer.write((SerializeWriter)out, (Object)object);
        return out.toBytes(URL_PARAM_DECODECHARSET_UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLPost(String url, Map<String, Object> params) {
        String enc = URL_PARAM_DECODECHARSET_UTF8;
        String response = EMPTY;
        PostMethod postMethod = null;
        try {
            int statusCode;
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            if (null != params) {
                Set<String> keySet = params.keySet();
                for (String key : keySet) {
                    Object value = params.get(key);
                    postMethod.addParameter(key, value.toString());
                }
            }
            if ((statusCode = client.executeMethod((HttpMethod)postMethod)) == 200) {
                response = postMethod.getResponseBodyAsString();
                System.out.println("result:" + response);
            } else {
                log.error((Object)("\u8bf7\u6c42\u5931\u8d25 = " + postMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            log.error((Object)"HttpException", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error((Object)"IOException", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLGet(String url, Map<String, String> params) {
        String enc = URL_PARAM_DECODECHARSET_UTF8;
        String response = EMPTY;
        GetMethod getMethod = null;
        StringBuffer strtTotalURL = new StringBuffer(EMPTY);
        if (strtTotalURL.indexOf("?") == -1) {
            strtTotalURL.append(url).append("?").append(HttpUtil.getUrl(params, enc));
        } else {
            strtTotalURL.append(url).append(URL_PARAM_CONNECT_FLAG).append(HttpUtil.getUrl(params, enc));
        }
        log.debug((Object)("GETURL = \n" + strtTotalURL.toString()));
        try {
            getMethod = new GetMethod(strtTotalURL.toString());
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            int statusCode = client.executeMethod((HttpMethod)getMethod);
            if (statusCode == 200) {
                response = getMethod.getResponseBodyAsString();
                System.out.println("result:" + response);
            } else {
                log.debug((Object)(" = " + getMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            log.error((Object)"HttpException", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error((Object)"IOException", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
                getMethod = null;
            }
        }
        return response;
    }

    private static String getUrl(Map<String, String> map, String valueEnc) {
        if (null == map || map.keySet().size() == 0) {
            return EMPTY;
        }
        StringBuffer url = new StringBuffer();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            String val = map.get(key);
            String str = val != null ? val : EMPTY;
            try {
                str = URLEncoder.encode(str, valueEnc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            url.append(key).append("=").append(str).append(URL_PARAM_CONNECT_FLAG);
        }
        String strURL = EMPTY;
        strURL = url.toString();
        if (URL_PARAM_CONNECT_FLAG.equals(EMPTY + strURL.charAt(strURL.length() - 1))) {
            strURL = strURL.substring(0, strURL.length() - 1);
        }
        return strURL;
    }

    public static String testWsdlConnection(String address, String spareAddress) throws Exception {
        int status = 404;
        try {
            URL urlObj = new URL(address);
            HttpURLConnection oc = (HttpURLConnection)urlObj.openConnection();
            oc.setUseCaches(false);
            oc.setConnectTimeout(100);
            status = oc.getResponseCode();
            if (404 == status) {
                return spareAddress;
            }
            return address;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return spareAddress;
        }
        catch (UnknownHostException e) {
            return spareAddress;
        }
        catch (SSLHandshakeException e) {
            return spareAddress;
        }
    }

    static {
        connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setConnectionTimeout(connectionTimeOut);
        connectionManager.getParams().setSoTimeout(socketTimeOut);
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnectionPerHost);
        connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
        client = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public static enum RequestMethod {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        PATCH,
        POST,
        PUT,
        TRACE;

    }

    public static class Request {
        private Map<String, Object> data = Maps.newHashMap();
        private RequestMethod method;
        private String spec;

        public Request() {
        }

        public Request(Map<String, Object> data, String spec) {
            this.data = data;
            this.spec = spec;
        }

        public Request(Map<String, Object> data, RequestMethod method, String spec) {
            this.data = data;
            this.method = method;
            this.spec = spec;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public RequestMethod getMethod() {
            return this.method;
        }

        public String getSpec() {
            return this.spec;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public void setMethod(RequestMethod method) {
            this.method = method;
        }

        public void setSpec(String spec) {
            this.spec = spec;
        }
    }
}

