/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.utils;

import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExcelUtil.class.getName());

    public static boolean writeExcel(HttpServletResponse response, String fileName, String[] title, List<String[]> dataList) throws Exception {
        boolean flag = false;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle hssfTitleCellStyle = ExcelUtil.getHSSFTitleStyle(wb);
        int pageSize = 65535;
        int listSize = dataList.size();
        int sheetSize = 0;
        sheetSize = listSize % pageSize == 0 ? listSize / pageSize : listSize / pageSize + 1;
        if (sheetSize == 0) {
            HSSFSheet sheet = wb.createSheet();
            HSSFRow row = sheet.createRow(0);
            row.setHeight((short)600);
            row.setRowStyle(hssfTitleCellStyle);
            sheet.setDefaultColumnWidth(20);
            sheet.setDefaultRowHeightInPoints(20.0f);
            for (int i = 0; i < title.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellType(1);
                cell.setCellStyle(hssfTitleCellStyle);
                cell.setCellValue(title[i]);
            }
        } else {
            int start = 0;
            int end = 0;
            for (int s = 0; s < sheetSize; ++s) {
                start = s * pageSize;
                end = s == sheetSize - 1 ? listSize : (s + 1) * pageSize;
                HSSFSheet sheet = wb.createSheet();
                HSSFRow row = sheet.createRow(0);
                row.setHeight((short)600);
                row.setRowStyle(hssfTitleCellStyle);
                sheet.setDefaultColumnWidth(20);
                sheet.setDefaultRowHeightInPoints(20.0f);
                for (int i = 0; i < title.length; ++i) {
                    HSSFCell cell = row.createCell(i);
                    cell.setCellType(1);
                    cell.setCellStyle(hssfTitleCellStyle);
                    cell.setCellValue(title[i]);
                }
                HSSFCellStyle hssfCellStyle = ExcelUtil.getHSSFCellStyle(wb);
                int row_index = 1;
                for (int j = start; j < end; ++j) {
                    HSSFRow data_row = sheet.createRow(row_index);
                    ++row_index;
                    String[] cellList = dataList.get(j);
                    int len = cellList.length;
                    for (int k = 0; k < len; ++k) {
                        HSSFCell cell = data_row.createCell(k);
                        String value = cellList[k];
                        cell.setCellType(1);
                        cell.setCellStyle(hssfCellStyle);
                        cell.setCellValue(value);
                    }
                }
            }
        }
        response.reset();
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "iso8859-1"));
        ServletOutputStream out = response.getOutputStream();
        wb.write((OutputStream)out);
        out.close();
        flag = true;
        return flag;
    }

    private static HSSFCellStyle getHSSFCellStyle(HSSFWorkbook wb) {
        return null;
    }

    private static HSSFCellStyle getHSSFTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        titleStyle.setLocked(true);
        titleStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        HSSFFont titleFont = wb.createFont();
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        titleStyle.setFont((Font)titleFont);
        return titleStyle;
    }

    public static Workbook generateWorkbook(String name, String style, List<String> titles, List<Map<String, Object>> values) {
        LOGGER.info("file style : {}", (Object)style);
        Object workbook = "XLS".equals(style.toUpperCase()) ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = null == name || "".equals(name) ? workbook.createSheet() : workbook.createSheet(name);
        sheet.setDefaultColumnWidth(15);
        Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)workbook);
        Row row = sheet.createRow(0);
        HashMap titleOrder = Maps.newHashMap();
        for (int i = 0; i < titles.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(styles.get("header"));
            String title = titles.get(i);
            cell.setCellValue(title);
            titleOrder.put(title, i);
        }
        Iterator<Map<String, Object>> iterator = values.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            row = sheet.createRow(++index);
            Map<String, Object> value = iterator.next();
            for (Map.Entry<String, Object> map : value.entrySet()) {
                String title = map.getKey();
                int i = (Integer)titleOrder.get(title);
                Cell cell = row.createCell(i);
                if (index % 2 == 1) {
                    cell.setCellStyle(styles.get("cellA"));
                } else {
                    cell.setCellStyle(styles.get("cellA"));
                }
                Object object = map.getValue();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (object instanceof Double) {
                    cell.setCellValue(((Double)object).doubleValue());
                    continue;
                }
                if (object instanceof Date) {
                    String time = simpleDateFormat.format((Date)object);
                    cell.setCellValue(time);
                    continue;
                }
                if (object instanceof Calendar) {
                    Calendar calendar = (Calendar)object;
                    String time = simpleDateFormat.format(calendar.getTime());
                    cell.setCellValue(time);
                    continue;
                }
                if (object instanceof Boolean) {
                    cell.setCellValue(((Boolean)object).booleanValue());
                    continue;
                }
                if (null == object) continue;
                cell.setCellValue(object.toString());
            }
        }
        return workbook;
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap styles = Maps.newHashMap();
        CellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        titleStyle.setLocked(true);
        titleStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        Font titleFont = wb.createFont();
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        titleStyle.setFont(titleFont);
        styles.put("title", titleStyle);
        CellStyle headerStyle = wb.createCellStyle();
        headerStyle.setAlignment((short)2);
        headerStyle.setVerticalAlignment((short)1);
        headerStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        headerStyle.setFillPattern((short)1);
        headerStyle.setWrapText(true);
        headerStyle.setBorderRight((short)1);
        headerStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setBorderLeft((short)1);
        headerStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setBorderTop((short)1);
        headerStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setBorderBottom((short)1);
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        Font headerFont = wb.createFont();
        headerFont.setFontHeightInPoints((short)12);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        headerStyle.setFont(headerFont);
        styles.put("header", headerStyle);
        Font cellStyleFont = wb.createFont();
        cellStyleFont.setFontHeightInPoints((short)12);
        cellStyleFont.setColor(IndexedColors.BLUE_GREY.getIndex());
        cellStyleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        CellStyle cellStyleA = wb.createCellStyle();
        cellStyleA.setAlignment((short)2);
        cellStyleA.setVerticalAlignment((short)1);
        cellStyleA.setWrapText(true);
        cellStyleA.setBorderRight((short)1);
        cellStyleA.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleA.setBorderLeft((short)1);
        cellStyleA.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleA.setBorderTop((short)1);
        cellStyleA.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleA.setBorderBottom((short)1);
        cellStyleA.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleA.setFont(cellStyleFont);
        styles.put("cellA", cellStyleA);
        CellStyle cellStyleB = wb.createCellStyle();
        cellStyleB.setAlignment((short)2);
        cellStyleB.setVerticalAlignment((short)1);
        cellStyleB.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        cellStyleB.setFillPattern((short)1);
        cellStyleB.setWrapText(true);
        cellStyleB.setBorderRight((short)1);
        cellStyleB.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleB.setBorderLeft((short)1);
        cellStyleB.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleB.setBorderTop((short)1);
        cellStyleB.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleB.setBorderBottom((short)1);
        cellStyleB.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleB.setFont(cellStyleFont);
        styles.put("cellB", cellStyleB);
        return styles;
    }
}

