/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.support.jedis;

import cn.xyz.commons.support.jedis.RedisCRUD;
import cn.xyz.mianshi.utils.SKBeanUtils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@ConditionalOnClass(value={RedissonClient.class})
@Component
public class RedissonClientImpl
implements RedisCRUD {
    @Autowired
    private RedissonClient redissonClient;

    private RBucket<Object> getRedisBucket(String key) {
        return this.redissonClient.getBucket(key);
    }

    @Override
    public void set(String key, String value) {
        this.redissonClient.getBucket(key).set((Object)value);
    }

    @Override
    public void set(String key, String value, String nxxx, String expx, int time) {
    }

    @Override
    public void setObject(String key, Object obj, int expireTime) {
        this.redissonClient.getBucket(key).set(obj, (long)expireTime, TimeUnit.SECONDS);
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        return null;
    }

    @Override
    public boolean hasKey(String key) {
        return false;
    }

    @Override
    public void setWithExpireTime(String key, String value, int expireTime) {
        this.redissonClient.getBucket(key).set((Object)value, (long)expireTime, TimeUnit.SECONDS);
    }

    @Override
    public String get(String key) {
        RBucket bucket = this.redissonClient.getBucket(key);
        return (String)bucket.get();
    }

    @Override
    public void delete(String key) {
        this.redissonClient.getBucket(key).delete();
    }

    @Override
    public void delete(String ... keys) {
        for (String str : keys) {
            this.redissonClient.getBucket(str).delete();
        }
    }

    @Override
    public void del(String ... keys) {
        for (String str : keys) {
            this.redissonClient.getBucket(str).delete();
        }
    }

    @Override
    public void deleteKeysByPattern(String pattern) {
        Iterable<String> keys = this.keys(pattern);
        for (String key : keys) {
            SKBeanUtils.getRedisCRUD().delete(key);
        }
    }

    @Override
    public long ttl(String key) {
        long ttl;
        RBucket bucket = this.redissonClient.getBucket(key);
        if (bucket.isExists() && (ttl = bucket.remainTimeToLive()) > 0L) {
            return ttl / 1000L;
        }
        return 0L;
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return null;
    }

    @Override
    public Long lpush(String key, String ... strings) {
        return null;
    }

    @Override
    public Long lpush(String key, int seconds, String ... strings) {
        return null;
    }

    @Override
    public void expire(String key, int seconds) {
        this.redissonClient.getBucket(key).expire((long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return null;
    }

    @Override
    public Iterable<String> keys(String pattern) {
        return this.redissonClient.getKeys().getKeysByPattern(pattern);
    }

    @Override
    public Long zcard(String key) {
        return null;
    }

    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        return null;
    }

    @Override
    public Long hset(String key, String field, String value) {
        return null;
    }

    @Override
    public Long llen(String key) {
        return null;
    }

    @Override
    public Long zrank(String key, String member) {
        return null;
    }

    @Override
    public String hget(String key, String field) {
        return null;
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        return null;
    }

    @Override
    public Long zrem(String key, String ... members) {
        return null;
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return null;
    }

    @Override
    public Double zscore(String key, String member) {
        return null;
    }

    @Override
    public String rpop(String key) {
        return null;
    }

    @Override
    public void ltrim(String key, int start, int end) {
        this.redissonClient.getList(key).trim(start, end);
    }

    @Override
    public Boolean keyExists(String key) {
        return this.redissonClient.getBucket(key).isExists();
    }

    @Override
    public Set<String> hkeys(String key) {
        return null;
    }
}

