/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.autoconfigure;

import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.utils.StringUtil;
import cn.xyz.mianshi.vo.Room;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.shiku.mongodb.morphia.MongoConfig;
import com.shiku.mongodb.morphia.MorphiaAutoConfiguration;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KMongoAutoConfiguration
extends MorphiaAutoConfiguration {
    private Morphia morphiaForTigase;
    private Datastore dsForTigase;
    private Morphia morphiaForIMRoom;
    private Datastore dsForRoom;
    private MongoClient tigMongoClient;
    private MongoClient imRoomMongoClient;
    @Autowired(required=false)
    private MongoConfig mongoConfig;
    @Autowired(required=false)
    private KApplicationProperties.XMPPConfig xmppConfig;
    private MongoClientOptions options = null;

    public MongoClientOptions getMongoClientOptions() {
        if (null == this.options) {
            MongoClientOptions.Builder builder = MongoClientOptions.builder();
            builder.socketKeepAlive(true);
            builder.connectTimeout(this.mongoConfig.getConnectTimeout());
            builder.socketTimeout(this.mongoConfig.getSocketTimeout());
            builder.maxWaitTime(this.mongoConfig.getMaxWaitTime());
            builder.heartbeatFrequency(10000);
            builder.readPreference(ReadPreference.nearest());
            this.options = builder.build();
        }
        return this.options;
    }

    @Bean(name={"imRoomMongoClient"}, destroyMethod="close")
    public MongoClient getImRoomMongoClient() {
        try {
            MongoCredential credential = null;
            if (!StringUtil.isEmpty(this.mongoConfig.getUsername()) && !StringUtil.isEmpty(this.mongoConfig.getPassword())) {
                credential = MongoCredential.createScramSha1Credential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getRoomDbName(), (char[])this.mongoConfig.getPassword().toCharArray());
            }
            MongoClientURI mongoClientURI = new MongoClientURI(this.mongoConfig.getUri());
            this.imRoomMongoClient = new MongoClient(mongoClientURI);
            return this.imRoomMongoClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.imRoomMongoClient;
        }
    }

    @Bean(name={"morphiaForTigase"})
    public Morphia morphiaForTigase() {
        this.morphiaForTigase = new Morphia();
        return this.morphiaForTigase;
    }

    @Bean(name={"morphiaForIMRoom"})
    public Morphia morphiaForIMRoom() {
        this.morphiaForIMRoom = new Morphia();
        this.morphiaForIMRoom.map(new Class[]{Room.class});
        this.morphiaForIMRoom.map(new Class[]{Room.Member.class});
        this.morphiaForIMRoom.map(new Class[]{Room.Notice.class});
        return this.morphiaForIMRoom;
    }

    @Bean(name={"dsForRoom"})
    public Datastore dsForRoom() throws Exception {
        MongoClient imRoomMongoClient2 = this.getImRoomMongoClient();
        if (null != imRoomMongoClient2) {
            this.dsForRoom = this.morphiaForIMRoom().createDatastore(imRoomMongoClient2, "imRoom");
            this.dsForRoom.ensureIndexes();
            this.dsForRoom.ensureCaps();
        }
        return this.dsForRoom;
    }

    @Bean(name={"dsForTigase"})
    public Datastore dsForTigase() throws Exception {
        MongoClient tigMongoClient2;
        String dbname = "tigase";
        if (null != this.xmppConfig && StringUtil.isEmpty(this.xmppConfig.getDbName())) {
            dbname = this.xmppConfig.getDbName();
        }
        if (null != (tigMongoClient2 = this.getTigMongoClient())) {
            this.dsForTigase = this.morphiaForTigase().createDatastore(tigMongoClient2, dbname);
            this.dsForTigase.ensureIndexes();
            this.dsForTigase.ensureCaps();
        }
        return this.dsForTigase;
    }

    @Bean(name={"tigMongoClient"}, destroyMethod="close")
    public MongoClient getTigMongoClient() {
        try {
            if (null == this.tigMongoClient) {
                String dbUri = null;
                String dbName = null;
                String dbUserName = null;
                String dbPwd = null;
                if (null == this.xmppConfig) {
                    dbUri = this.mongoConfig.getUri();
                    dbName = "tigase";
                    dbUserName = this.mongoConfig.getUsername();
                    dbPwd = this.mongoConfig.getPassword();
                } else {
                    dbUri = this.xmppConfig.getDbUri();
                    dbName = this.xmppConfig.getDbName();
                    dbUserName = this.xmppConfig.getDbUsername();
                    dbPwd = this.xmppConfig.getDbPassword();
                }
                MongoClientURI mongoClientURI = new MongoClientURI(dbUri);
                MongoCredential credential = null;
                if (!StringUtil.isEmpty(dbUserName) && !StringUtil.isEmpty(dbPwd)) {
                    credential = MongoCredential.createScramSha1Credential((String)dbUserName, (String)dbName, (char[])dbPwd.toCharArray());
                }
                this.tigMongoClient = new MongoClient(mongoClientURI);
                return this.tigMongoClient;
            }
            return this.tigMongoClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.tigMongoClient;
        }
    }
}

