/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.autoconfigure;

import cn.xyz.commons.utils.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class IpSearch {
    private int[] prefStart = new int[256];
    private int[] prefEnd = new int[256];
    private long[] endArr;
    private String[] addrArr;
    private static IpSearch instance = null;
    private static String pathUrl = null;

    private IpSearch(String url) {
        int i;
        pathUrl = url;
        if (null == pathUrl) {
            return;
        }
        Path path = Paths.get(pathUrl, new String[0]);
        byte[] data = null;
        try {
            data = Files.readAllBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (null == data) {
            return;
        }
        for (int k = 0; k < 256; ++k) {
            i = k * 8 + 4;
            this.prefStart[k] = (int)this.BytesToLong(data[i], data[i + 1], data[i + 2], data[i + 3]);
            this.prefEnd[k] = (int)this.BytesToLong(data[i + 4], data[i + 5], data[i + 6], data[i + 7]);
        }
        int RecordSize = (int)this.BytesToLong(data[0], data[1], data[2], data[3]);
        this.endArr = new long[RecordSize];
        this.addrArr = new String[RecordSize];
        for (i = 0; i < RecordSize; ++i) {
            int p = 2052 + i * 8;
            long endipnum = this.BytesToLong(data[p], data[1 + p], data[2 + p], data[3 + p]);
            int offset = (int)this.BytesToLong3(data[4 + p], data[5 + p], data[6 + p]);
            int length = data[7 + p] & 0xFF;
            this.endArr[i] = endipnum;
            this.addrArr[i] = new String(Arrays.copyOfRange(data, offset, offset + length));
        }
    }

    public static synchronized IpSearch getInstance() {
        if (instance == null && !StringUtil.isEmpty(pathUrl)) {
            instance = new IpSearch(pathUrl);
        }
        return instance;
    }

    public static synchronized IpSearch getInstance(String url) {
        if (instance == null) {
            instance = new IpSearch(url);
        }
        if (null == IpSearch.instance.endArr || null == IpSearch.instance.addrArr) {
            instance = null;
        }
        return instance;
    }

    public static String getArea(String ip) {
        String area = "CN";
        if (null == instance) {
            return area;
        }
        String result = instance.Get(ip);
        String[] split = result.split("\\|");
        if (8 < split.length) {
            area = split[8];
        }
        return area;
    }

    public String Get(String ip) {
        String[] ips = ip.split("\\.");
        int pref = Integer.valueOf(ips[0]);
        long val = this.ipToLong(ip);
        int low = this.prefStart[pref];
        int high = this.prefEnd[pref];
        long cur = low == high ? (long)low : (long)this.BinarySearch(low, high, val);
        return this.addrArr[(int)cur];
    }

    private int BinarySearch(int low, int high, long k) {
        int M = 0;
        while (low <= high) {
            int mid = (low + high) / 2;
            long endipNum = this.endArr[mid];
            if (endipNum >= k) {
                M = mid;
                if (mid == 0) break;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return M;
    }

    private long BytesToLong(byte a, byte b, byte c, byte d) {
        return (long)a & 0xFFL | (long)(b << 8) & 0xFF00L | (long)(c << 16) & 0xFF0000L | (long)(d << 24) & 0xFF000000L;
    }

    private long BytesToLong3(byte a, byte b, byte c) {
        return (long)a & 0xFFL | (long)(b << 8) & 0xFF00L | (long)(c << 16) & 0xFF0000L;
    }

    private long ipToLong(String ip) {
        String[] d;
        long result = 0L;
        for (String b : d = ip.split("\\.")) {
            result <<= 8;
            result |= Long.parseLong(b) & 0xFFL;
        }
        return result;
    }

    public static void main(String[] args) {
        IpSearch finder = IpSearch.getInstance();
        String ip = "133.1.16.172";
        String result = finder.Get(ip);
        System.out.println(ip);
        System.out.println(result);
        Object[] split = result.split("\\|");
        System.out.println(Arrays.toString(split));
        System.out.println("\u56fd\u5bb6==>  " + (String)split[7] + "   \u4ee3\u7801 ==>   " + (String)split[8]);
        System.out.println("\u7701\u4efd==>  " + (String)split[2] + "   \u57ce\u5e02 ==>   " + (String)split[3]);
    }
}

