/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.commons.autoconfigure;

import cn.xyz.commons.autoconfigure.IpSearch;
import cn.xyz.commons.autoconfigure.KApplicationProperties;
import cn.xyz.commons.support.spring.converter.MappingFastjsonHttpMessageConverter;
import cn.xyz.commons.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
public class CommAutoConfiguration {
    @Autowired
    private KApplicationProperties config;

    @Bean
    public HttpMessageConverters customConverters() {
        return new HttpMessageConverters(new HttpMessageConverter[]{new MappingFastjsonHttpMessageConverter()});
    }

    @Bean(name={"appConfig"})
    public KApplicationProperties.AppConfig appConfig() {
        KApplicationProperties.AppConfig appConfig = this.config.getAppConfig();
        System.out.println("appConfig  ----" + JSONObject.toJSONString((Object)appConfig));
        if (!StringUtil.isEmpty(appConfig.getQqzengPath())) {
            IpSearch.getInstance(appConfig.getQqzengPath());
        }
        return appConfig;
    }

    @Bean(name={"smsConfig"})
    public KApplicationProperties.SmsConfig smsConfig() {
        KApplicationProperties.SmsConfig smsConfig = this.config.getSmsConfig();
        return smsConfig;
    }

    @Bean(name={"xmppConfig"})
    public KApplicationProperties.XMPPConfig xmppConfig() {
        KApplicationProperties.XMPPConfig xmppConfig = this.config.getXmppConfig();
        return xmppConfig;
    }

    @Bean(name={"wxConfig"})
    public KApplicationProperties.WXConfig wxConfig() {
        KApplicationProperties.WXConfig wxConfig = this.config.getWxConfig();
        return wxConfig;
    }

    @Bean(name={"wxPublicConfig"})
    public KApplicationProperties.WXPublicConfig wxPublicConfig() {
        KApplicationProperties.WXPublicConfig wxPublicConfig = this.config.getWxPublicConfig();
        return wxPublicConfig;
    }

    @Bean(name={"mqConfig"})
    public KApplicationProperties.MQConfig mqConfig() {
        KApplicationProperties.MQConfig mqConfig = this.config.getMqConfig();
        System.out.println("mqConfig  ----" + JSONObject.toJSONString((Object)mqConfig));
        return mqConfig;
    }
}

