/*
 * Decompiled with CFR 0.152.
 */
package cn.xyz.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisServiceAspect {
    private Logger logger = LoggerFactory.getLogger(RedisServiceAspect.class);
    @Autowired
    private RedissonClient redissonClient;

    @Pointcut(value="execution(* cn.xyz.service.RedisServiceImpl.* (..)) || execution(* cn.xyz.commons.support.jedis.RedissonClientImpl.* (..))")
    public void redisServiceAspect() {
    }

    @Around(value="redisServiceAspect()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = null;
        try {
            result = joinPoint.proceed();
        }
        catch (RedisException e) {
            this.logger.error("{} ==> {}", (Object)joinPoint.getSignature().getName(), (Object)e.getMessage());
            this.restartRedissonClient();
            throw e;
        }
        catch (Exception e) {
            this.logger.error("{} ==> {}", (Object)joinPoint.getSignature().getName(), (Object)e.getMessage());
            throw e;
        }
        return result;
    }

    public void restartRedissonClient() {
        try {
            this.logger.info("restart redis redissonClient ====>");
            Config redissonConfig = this.redissonClient.getConfig();
            this.redissonClient = Redisson.create((Config)redissonConfig);
        }
        catch (Exception e) {
            this.logger.error("restartRedissonClient Exception {}", (Object)e.getMessage());
        }
    }
}

