/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.multicast;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import com.thoughtworks.proxy.toys.multicast.Multicast;
import com.thoughtworks.proxy.toys.multicast.MulticastingInvoker;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multicasting<T> {
    private Class<?>[] types;
    private Object[] delegates;

    private Multicasting(Object ... delegates) {
        this.delegates = delegates;
    }

    private Multicasting(Class<?> primaryType, Class<?> ... types) {
        this.types = ReflectionUtils.makeTypesArray(primaryType, types);
    }

    public static <T> MulticastingWith<T> proxy(Class<T> primaryType, Class<?> ... types) {
        return new MulticastingWith(primaryType, types);
    }

    public static MulticastingBuild<Multicast> proxy(Object ... targets) {
        return new MulticastingBuild<Multicast>(targets);
    }

    private T build() {
        return this.build(new StandardProxyFactory());
    }

    private T build(ProxyFactory factory) {
        if (this.types == null) {
            return this.buildWithNoTypesInput(factory);
        }
        if (this.delegates.length == 1) {
            int i;
            for (i = 0; i < this.types.length && (this.types[i] == Multicast.class || this.types[i].isAssignableFrom(this.delegates[0].getClass())); ++i) {
            }
            if (i == this.types.length) {
                Object instance = this.delegates[0];
                return (T)instance;
            }
        }
        return new MulticastingInvoker(this.types, factory, this.delegates).proxy();
    }

    private T buildWithNoTypesInput(ProxyFactory factory) {
        if (this.delegates.length > 1) {
            Class<?> superclass = ReflectionUtils.getMostCommonSuperclass(this.delegates);
            Set<Class<?>> interfaces = ReflectionUtils.getAllInterfaces(this.delegates);
            ReflectionUtils.addIfClassProxyingSupportedAndNotObject(superclass, interfaces, factory);
            this.types = interfaces.toArray(new Class[interfaces.size()]);
            return new MulticastingInvoker(this.types, factory, this.delegates).proxy();
        }
        Object instance = this.delegates[0];
        return (T)instance;
    }

    static /* synthetic */ Object[] access$302(Multicasting x0, Object[] x1) {
        x0.delegates = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MulticastingBuild<T> {
        private final Multicasting<T> multicasting;

        private MulticastingBuild(Object[] targets) {
            this.multicasting = new Multicasting(targets);
        }

        private MulticastingBuild(Multicasting<T> multicasting) {
            this.multicasting = multicasting;
        }

        public T build() {
            return (T)((Multicasting)this.multicasting).build();
        }

        public T build(ProxyFactory factory) {
            return (T)((Multicasting)this.multicasting).build(factory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MulticastingWith<T> {
        Multicasting<T> multicasting;

        private MulticastingWith(Class<T> primaryType, Class<?>[] types) {
            this.multicasting = new Multicasting((Class)primaryType, (Class[])types);
        }

        public MulticastingBuild<T> with(Object ... targets) {
            Multicasting.access$302(this.multicasting, targets);
            return new MulticastingBuild(this.multicasting);
        }
    }
}

