/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.failover;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.kit.SimpleReference;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import com.thoughtworks.proxy.toys.hotswap.HotSwappingInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailoverInvoker<T>
extends HotSwappingInvoker<T> {
    private static final long serialVersionUID = -8289095570093619184L;
    private T[] delegates;
    private Class<? extends Throwable> exceptionClass;
    private int current;

    public FailoverInvoker(Class<?>[] types, ProxyFactory proxyFactory, T[] delegates, Class<? extends Throwable> exceptionClass) {
        super(types, proxyFactory, new SimpleReference<Object>(delegates[0]), DelegationMode.DIRECT);
        this.delegates = delegates;
        this.exceptionClass = exceptionClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeOnDelegate(Method method, Object[] args) throws InvocationTargetException {
        Object result = null;
        int original = this.current;
        while (result == null) {
            try {
                result = super.invokeOnDelegate(method, args);
                break;
            }
            catch (InvocationTargetException e) {
                if (this.exceptionClass.isInstance(e.getTargetException())) {
                    FailoverInvoker failoverInvoker = this;
                    synchronized (failoverInvoker) {
                        ++this.current;
                        this.current %= this.delegates.length;
                        if (original == this.current) {
                            throw e;
                        }
                        this.hotswap(this.delegates[this.current]);
                        continue;
                    }
                }
                throw e;
            }
        }
        return result;
    }
}

