/*
 * Decompiled with CFR 0.152.
 */
package com.shiku.redisson;

import com.shiku.redisson.RedissonConfig;
import com.shiku.utils.StringUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RedissonConfig.class})
public class RedissonConfiguration {
    @Autowired
    private RedissonConfig redissonConfig;

    @Bean(destroyMethod="shutdown")
    public RedissonClient initRedissonClient() {
        RedissonClient redissonClient = null;
        try {
            Config config = new Config();
            config.setCodec((Codec)new JsonJacksonCodec());
            if (this.redissonConfig.getIsCluster() == 1) {
                System.out.println("redisson Cluster start ");
                String[] nodes = this.redissonConfig.getAddress().split(",");
                ClusterServersConfig serverConfig = config.useClusterServers();
                serverConfig.addNodeAddress(nodes);
                serverConfig.setKeepAlive(true);
                serverConfig.setPingConnectionInterval(this.redissonConfig.getPingConnectionInterval());
                serverConfig.setPingTimeout(this.redissonConfig.getPingTimeout());
                serverConfig.setTimeout(this.redissonConfig.getTimeout());
                serverConfig.setConnectTimeout(this.redissonConfig.getConnectTimeout());
                if (!StringUtil.isEmpty((String)this.redissonConfig.getPassword())) {
                    serverConfig.setPassword(this.redissonConfig.getPassword());
                }
            } else {
                System.out.println("redisson Single start ");
                SingleServerConfig serverConfig = config.useSingleServer().setAddress(this.redissonConfig.getAddress()).setDatabase(this.redissonConfig.getDatabase());
                serverConfig.setKeepAlive(true);
                serverConfig.setPingConnectionInterval(this.redissonConfig.getPingConnectionInterval());
                serverConfig.setPingTimeout(this.redissonConfig.getPingTimeout());
                serverConfig.setTimeout(this.redissonConfig.getTimeout());
                serverConfig.setConnectTimeout(this.redissonConfig.getConnectTimeout());
                serverConfig.setConnectionMinimumIdleSize(this.redissonConfig.getConnectionMinimumIdleSize());
                serverConfig.setConnectionPoolSize(this.redissonConfig.getConnectionPoolSize());
                if (!StringUtil.isEmpty((String)this.redissonConfig.getPassword())) {
                    serverConfig.setPassword(this.redissonConfig.getPassword());
                }
            }
            redissonClient = Redisson.create((Config)config);
            System.out.println("redisson create end ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return redissonClient;
    }
}

