/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.redisson.RedissonShutdownException;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.AsyncDetails;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.CountableListener;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.AsyncSemaphore;

public class CommandBatchService
extends CommandAsyncService {
    private AtomicInteger index = new AtomicInteger();
    private ConcurrentMap<MasterSlaveEntry, Entry> commands = new ConcurrentHashMap<MasterSlaveEntry, Entry>();
    private ConcurrentMap<MasterSlaveEntry, ConnectionEntry> connections = new ConcurrentHashMap<MasterSlaveEntry, ConnectionEntry>();
    private BatchOptions options;
    private Map<RFuture<?>, List<CommandBatchService>> nestedServices = new ConcurrentHashMap();
    private AtomicBoolean executed = new AtomicBoolean();
    AsyncSemaphore semaphore = new AsyncSemaphore(0);

    public CommandBatchService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    public CommandBatchService(ConnectionManager connectionManager, BatchOptions options) {
        super(connectionManager);
        this.options = options;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public void add(RFuture<?> future, List<CommandBatchService> services) {
        this.nestedServices.put(future, services);
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt, boolean ignoreRedirect) {
        if (nodeSource.getEntry() != null) {
            Entry entry = (Entry)this.commands.get(nodeSource.getEntry());
            if (entry == null) {
                entry = new Entry();
                Entry oldEntry = this.commands.putIfAbsent(nodeSource.getEntry(), entry);
                if (oldEntry != null) {
                    entry = oldEntry;
                }
            }
            if (!readOnlyMode) {
                entry.setReadOnlyMode(false);
            }
            Object[] batchParams = null;
            if (!this.isRedisBasedQueue()) {
                batchParams = params;
            }
            Codec codecToUse = this.getCodec(codec);
            BatchCommandData<V, R> commandData = new BatchCommandData<V, R>(mainPromise, codecToUse, command, batchParams, this.index.incrementAndGet());
            entry.getCommands().add(commandData);
        }
        if (!this.isRedisBasedQueue()) {
            return;
        }
        if (!readOnlyMode && this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC) {
            throw new IllegalStateException("Data modification commands can't be used with queueStore=REDIS_READ_ATOMIC");
        }
        super.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, attempt, true);
    }

    @Override
    public <R> RPromise<R> createPromise() {
        if (this.isRedisBasedQueue()) {
            return new BatchPromise(this.executed);
        }
        return super.createPromise();
    }

    @Override
    protected <V, R> void releaseConnection(NodeSource source, RFuture<RedisConnection> connectionFuture, boolean isReadOnly, RPromise<R> attemptPromise, AsyncDetails<V, R> details) {
        if (!this.isRedisBasedQueue() || RedisCommands.EXEC.getName().equals(details.getCommand().getName())) {
            super.releaseConnection(source, connectionFuture, isReadOnly, attemptPromise, details);
        }
    }

    @Override
    protected <V, R> void handleSuccess(AsyncDetails<V, R> details, RPromise<R> promise, RedisCommand<?> command, R res) {
        if (RedisCommands.EXEC.getName().equals(command.getName())) {
            super.handleSuccess(details, promise, command, res);
            return;
        }
        if (RedisCommands.DISCARD.getName().equals(command.getName())) {
            super.handleSuccess(details, promise, command, null);
            if (this.executed.compareAndSet(false, true)) {
                details.getConnectionFuture().getNow().forceFastReconnectAsync().onComplete((r, e) -> CommandBatchService.super.releaseConnection(details.getSource(), details.getConnectionFuture(), details.isReadOnlyMode(), details.getAttemptPromise(), details));
            }
            return;
        }
        if (this.isRedisBasedQueue()) {
            BatchPromise batchPromise = (BatchPromise)promise;
            RPromise sentPromise = (RPromise)batchPromise.getSentPromise();
            super.handleSuccess(details, sentPromise, command, null);
            this.semaphore.release();
        }
    }

    @Override
    protected <V, R> void handleError(AsyncDetails<V, R> details, RPromise<R> promise, Throwable cause) {
        if (this.isRedisBasedQueue() && promise instanceof BatchPromise) {
            BatchPromise batchPromise = (BatchPromise)promise;
            RPromise sentPromise = (RPromise)batchPromise.getSentPromise();
            sentPromise.tryFailure(cause);
            promise.tryFailure(cause);
            if (this.executed.compareAndSet(false, true)) {
                details.getConnectionFuture().getNow().forceFastReconnectAsync().onComplete((res, e) -> CommandBatchService.super.releaseConnection(details.getSource(), details.getConnectionFuture(), details.isReadOnlyMode(), details.getAttemptPromise(), details));
            }
            this.semaphore.release();
            return;
        }
        super.handleError(details, promise, cause);
    }

    @Override
    protected <R, V> void sendCommand(AsyncDetails<V, R> details, RedisConnection connection) {
        if (!this.isRedisBasedQueue()) {
            super.sendCommand(details, connection);
            return;
        }
        ConnectionEntry connectionEntry = (ConnectionEntry)this.connections.get(details.getSource().getEntry());
        if (details.getSource().getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            RedissonPromise promise = new RedissonPromise();
            list.add(new CommandData(promise, details.getCodec(), RedisCommands.ASKING, new Object[0]));
            if (connectionEntry.isFirstCommand()) {
                list.add(new CommandData(promise, details.getCodec(), RedisCommands.MULTI, new Object[0]));
                connectionEntry.setFirstCommand(false);
            }
            list.add(new CommandData<V, R>(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
            RedissonPromise<Void> main = new RedissonPromise<Void>();
            ChannelFuture future = connection.send(new CommandsData(main, list, true));
            details.setWriteFuture(future);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("acquired connection for command {} and params {} from slot {} using node {}... {}", new Object[]{details.getCommand(), LogHelper.toString(details.getParams()), details.getSource(), connection.getRedisClient().getAddr(), connection});
            }
            if (connectionEntry.isFirstCommand()) {
                ArrayList list = new ArrayList(2);
                list.add(new CommandData(new RedissonPromise(), details.getCodec(), RedisCommands.MULTI, new Object[0]));
                list.add(new CommandData<V, R>(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                ChannelFuture future = connection.send(new CommandsData(main, list, true));
                connectionEntry.setFirstCommand(false);
                details.setWriteFuture(future);
            } else if (RedisCommands.EXEC.getName().equals(details.getCommand().getName())) {
                Entry entry = (Entry)this.commands.get(details.getSource().getEntry());
                ArrayList list = new ArrayList();
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new RedissonPromise(), details.getCodec(), RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}));
                }
                list.add(new CommandData<V, R>(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                if (this.options.isSkipResult()) {
                    list.add(new CommandData(new RedissonPromise(), details.getCodec(), RedisCommands.CLIENT_REPLY, new Object[]{"ON"}));
                }
                if (this.options.getSyncSlaves() > 0) {
                    BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                    list.add(waitCommand);
                    entry.getCommands().add(waitCommand);
                }
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                ChannelFuture future = connection.send(new CommandsData(main, list, new ArrayList(entry.getCommands()), this.options.isSkipResult(), false, true));
                details.setWriteFuture(future);
            } else {
                RedissonPromise<Void> main = new RedissonPromise<Void>();
                ArrayList list = new ArrayList();
                list.add(new CommandData<V, R>(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                ChannelFuture future = connection.send(new CommandsData(main, list, true));
                details.setWriteFuture(future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V> RFuture<RedisConnection> getConnection(boolean readOnlyMode, NodeSource source, RedisCommand<V> command) {
        if (!this.isRedisBasedQueue()) {
            return super.getConnection(readOnlyMode, source, command);
        }
        ConnectionEntry entry = (ConnectionEntry)this.connections.get(source.getEntry());
        if (entry == null) {
            entry = new ConnectionEntry();
            ConnectionEntry oldEntry = this.connections.putIfAbsent(source.getEntry(), entry);
            if (oldEntry != null) {
                entry = oldEntry;
            }
        }
        if (entry.getConnectionFuture() != null) {
            return entry.getConnectionFuture();
        }
        CommandBatchService commandBatchService = this;
        synchronized (commandBatchService) {
            if (entry.getConnectionFuture() != null) {
                return entry.getConnectionFuture();
            }
            RFuture<RedisConnection> connectionFuture = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC ? this.connectionManager.connectionWriteOp(source, null) : this.connectionManager.connectionReadOp(source, null);
            connectionFuture.syncUninterruptibly();
            entry.setConnectionFuture(connectionFuture);
            return connectionFuture;
        }
    }

    public BatchResult<?> execute() {
        RFuture f = this.executeAsync(BatchOptions.defaults());
        return (BatchResult)this.get(f);
    }

    public BatchResult<?> execute(BatchOptions options) {
        RFuture f = this.executeAsync(options);
        return (BatchResult)this.get(f);
    }

    public RFuture<Void> executeAsyncVoid() {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        RFuture resFuture = this.executeAsync(BatchOptions.defaults());
        resFuture.onComplete((res, e) -> {
            if (e == null) {
                promise.trySuccess(null);
            } else {
                promise.tryFailure((Throwable)e);
            }
        });
        return promise;
    }

    public RFuture<List<?>> executeAsync() {
        return this.executeAsync(BatchOptions.defaults());
    }

    public <R> RFuture<R> executeAsync(BatchOptions options) {
        RedissonPromise<Void> resultPromise;
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            this.executed.set(true);
            BatchResult result = new BatchResult(Collections.emptyList(), 0);
            return RedissonPromise.newSucceededFuture(result);
        }
        if (this.options == null) {
            this.options = options;
        }
        if (this.isRedisBasedQueue()) {
            int permits = 0;
            for (Entry entry : this.commands.values()) {
                permits += entry.getCommands().size();
            }
            final RedissonPromise resultPromise2 = new RedissonPromise();
            this.semaphore.acquire(new Runnable(){

                @Override
                public void run() {
                    block0: for (Entry entry : CommandBatchService.this.commands.values()) {
                        for (BatchCommandData<?, ?> command : entry.getCommands()) {
                            if (!command.getPromise().isDone() || command.getPromise().isSuccess()) continue;
                            resultPromise2.tryFailure(command.getPromise().cause());
                            continue block0;
                        }
                    }
                    if (resultPromise2.isDone()) {
                        return;
                    }
                    RedissonPromise mainPromise = new RedissonPromise();
                    ConcurrentHashMap result = new ConcurrentHashMap();
                    CountableListener listener = new CountableListener(mainPromise, result);
                    listener.setCounter(CommandBatchService.this.connections.size());
                    for (Map.Entry entry : CommandBatchService.this.commands.entrySet()) {
                        RedissonPromise execPromise = new RedissonPromise();
                        CommandBatchService.this.async(((Entry)entry.getValue()).isReadOnlyMode(), new NodeSource((MasterSlaveEntry)entry.getKey()), CommandBatchService.this.connectionManager.getCodec(), RedisCommands.EXEC, new Object[0], execPromise, 0, false);
                        execPromise.onComplete((r, ex) -> {
                            if (ex != null) {
                                mainPromise.tryFailure((Throwable)ex);
                                return;
                            }
                            BatchCommandData<?, ?> lastCommand = ((Entry)entry.getValue()).getCommands().peekLast();
                            result.put(entry.getKey(), r);
                            if (RedisCommands.WAIT.getName().equals(lastCommand.getCommand().getName())) {
                                lastCommand.getPromise().onComplete((res, e) -> {
                                    if (e != null) {
                                        mainPromise.tryFailure((Throwable)e);
                                        return;
                                    }
                                    execPromise.onComplete(listener);
                                });
                            } else {
                                execPromise.onComplete(listener);
                            }
                        });
                    }
                    mainPromise.onComplete((res, ex) -> {
                        CommandBatchService.this.executed.set(true);
                        if (ex != null) {
                            resultPromise2.tryFailure((Throwable)ex);
                            return;
                        }
                        try {
                            for (Map.Entry entry : res.entrySet()) {
                                Entry commandEntry = (Entry)CommandBatchService.this.commands.get(entry.getKey());
                                Iterator resultIter = ((List)entry.getValue()).iterator();
                                for (BatchCommandData<?, ?> data : commandEntry.getCommands()) {
                                    if (data.getCommand().getName().equals(RedisCommands.EXEC.getName())) break;
                                    RPromise promise = data.getPromise();
                                    promise.trySuccess(resultIter.next());
                                }
                            }
                            ArrayList entries = new ArrayList();
                            for (Entry e : CommandBatchService.this.commands.values()) {
                                entries.addAll(e.getCommands());
                            }
                            Collections.sort(entries);
                            ArrayList arrayList = new ArrayList(entries.size());
                            int syncedSlaves = 0;
                            for (BatchCommandData batchCommandData : entries) {
                                if (CommandBatchService.this.isWaitCommand(batchCommandData)) {
                                    syncedSlaves += ((Integer)batchCommandData.getPromise().getNow()).intValue();
                                    continue;
                                }
                                if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName())) continue;
                                Object entryResult = batchCommandData.getPromise().getNow();
                                entryResult = CommandBatchService.this.tryHandleReference(entryResult);
                                arrayList.add(entryResult);
                            }
                            BatchResult r = new BatchResult(arrayList, syncedSlaves);
                            resultPromise2.trySuccess(r);
                        }
                        catch (Exception e) {
                            resultPromise2.tryFailure(e);
                        }
                        CommandBatchService.this.commands = null;
                    });
                }
            }, permits);
            return resultPromise2;
        }
        if (this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData multiCommand = new BatchCommandData(RedisCommands.MULTI, new Object[0], this.index.incrementAndGet());
                entry.getCommands().addFirst(multiCommand);
                BatchCommandData execCommand = new BatchCommandData(RedisCommands.EXEC, new Object[0], this.index.incrementAndGet());
                entry.getCommands().add(execCommand);
            }
        }
        if (this.options.isSkipResult()) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData offCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                entry.getCommands().addFirst(offCommand);
                BatchCommandData onCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                entry.getCommands().add(onCommand);
            }
        }
        if (this.options.getSyncSlaves() > 0) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                entry.getCommands().add(waitCommand);
            }
        }
        RedissonPromise<Void> voidPromise = new RedissonPromise<Void>();
        if (this.options.isSkipResult()) {
            voidPromise.onComplete((res, e) -> {
                this.executed.set(true);
                this.nestedServices.clear();
            });
            resultPromise = voidPromise;
        } else {
            RedissonPromise promise = new RedissonPromise();
            voidPromise.onComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    promise.tryFailure((Throwable)ex);
                    this.commands = null;
                    this.nestedServices.clear();
                    return;
                }
                ArrayList entries = new ArrayList();
                for (Entry e : this.commands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList responses = new ArrayList(entries.size());
                int syncedSlaves = 0;
                for (BatchCommandData batchCommandData : entries) {
                    if (this.isWaitCommand(batchCommandData)) {
                        syncedSlaves = (Integer)batchCommandData.getPromise().getNow();
                        continue;
                    }
                    if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName())) continue;
                    Object entryResult = batchCommandData.getPromise().getNow();
                    entryResult = this.tryHandleReference(entryResult);
                    responses.add(entryResult);
                }
                BatchResult result = new BatchResult(responses, syncedSlaves);
                promise.trySuccess(result);
                this.commands = null;
                this.nestedServices.clear();
            });
            resultPromise = promise;
        }
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry<RFuture<?>, List<CommandBatchService>> entry : this.nestedServices.entrySet()) {
            slots.incrementAndGet();
            for (CommandBatchService service : entry.getValue()) {
                service.executeAsync();
            }
            entry.getKey().onComplete((res, e) -> this.handle(voidPromise, slots, (RFuture)entry.getKey()));
        }
        for (Map.Entry<RFuture<Object>, List<CommandBatchService>> entry : this.commands.entrySet()) {
            this.execute((Entry)((Object)entry.getValue()), new NodeSource((MasterSlaveEntry)((Object)entry.getKey())), voidPromise, slots, 0, this.options);
        }
        return resultPromise;
    }

    protected boolean isRedisBasedQueue() {
        return this.options != null && (this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
    }

    private void execute(final Entry entry, final NodeSource source, final RPromise<Void> mainPromise, final AtomicInteger slots, final int attempt, final BatchOptions options) {
        if (mainPromise.isCancelled()) {
            this.free(entry);
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            this.free(entry);
            mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        final RedissonPromise attemptPromise = new RedissonPromise();
        final AsyncDetails details = new AsyncDetails();
        details.init(null, attemptPromise, entry.isReadOnlyMode(), source, null, null, null, mainPromise, attempt);
        final RFuture<RedisConnection> connectionFuture = entry.isReadOnlyMode() ? this.connectionManager.connectionReadOp(source, null) : this.connectionManager.connectionWriteOp(source, null);
        final int attempts = options.getRetryAttempts() > 0 ? options.getRetryAttempts() : this.connectionManager.getConfig().getRetryAttempts();
        final long interval = options.getRetryInterval() > 0L ? options.getRetryInterval() : (long)this.connectionManager.getConfig().getRetryInterval();
        final AtomicBoolean skip = new AtomicBoolean();
        BiConsumer<Void, Throwable> mainPromiseListener = new BiConsumer<Void, Throwable>(){

            @Override
            public void accept(Void t, Throwable u) {
                if (!skip.get() && mainPromise.isCancelled() && connectionFuture.cancel(false)) {
                    CommandAsyncService.log.debug("Connection obtaining canceled for batch");
                    details.getTimeout().cancel();
                    if (attemptPromise.cancel(false)) {
                        CommandBatchService.this.free(entry);
                    }
                }
            }
        };
        TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout t) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Unable to get connection! Try to increase 'nettyThreads' and 'connection pool' settings or set decodeInExecutor = true and increase 'threads' settingNode source: " + source + " after " + attempts + " retry attempts"));
                    }
                } else if (connectionFuture.isSuccess()) {
                    if (details.getWriteFuture() == null || !details.getWriteFuture().isDone()) {
                        if (details.getAttempt() == attempts) {
                            if (details.getWriteFuture() != null && details.getWriteFuture().cancel(false)) {
                                if (details.getException() == null) {
                                    details.setException(new RedisTimeoutException("Unable to send batch after " + attempts + " retry attempts"));
                                }
                                attemptPromise.tryFailure(details.getException());
                            }
                            return;
                        }
                        details.incAttempt();
                        Timeout timeout = CommandBatchService.this.connectionManager.newTimeout(this, interval, TimeUnit.MILLISECONDS);
                        details.setTimeout(timeout);
                        return;
                    }
                    if (details.getWriteFuture().isDone() && details.getWriteFuture().isSuccess()) {
                        return;
                    }
                }
                if (mainPromise.isCancelled()) {
                    if (attemptPromise.cancel(false)) {
                        CommandBatchService.this.free(entry);
                    }
                    return;
                }
                if (attempt == attempts) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Batch command execution timeout"));
                    }
                    attemptPromise.tryFailure(details.getException());
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                int count = attempt + 1;
                skip.set(true);
                CommandBatchService.this.execute(entry, source, mainPromise, slots, count, options);
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, interval, TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        mainPromise.onComplete(mainPromiseListener);
        connectionFuture.onComplete((res, e) -> this.checkConnectionFuture(entry, source, mainPromise, attemptPromise, details, connectionFuture, options.isSkipResult(), options.getResponseTimeout(), attempts, options.getExecutionMode(), slots));
        attemptPromise.onComplete((res, e) -> {
            details.getTimeout().cancel();
            if (attemptPromise.isCancelled()) {
                return;
            }
            skip.set(true);
            if (e instanceof RedisMovedException) {
                RedisMovedException ex = (RedisMovedException)e;
                entry.clearErrors();
                NodeSource nodeSource = new NodeSource(ex.getSlot(), this.connectionManager.applyNatMap(ex.getUrl()), NodeSource.Redirect.MOVED);
                this.execute(entry, nodeSource, mainPromise, slots, attempt, options);
                return;
            }
            if (e instanceof RedisAskException) {
                RedisAskException ex = (RedisAskException)e;
                entry.clearErrors();
                NodeSource nodeSource = new NodeSource(ex.getSlot(), this.connectionManager.applyNatMap(ex.getUrl()), NodeSource.Redirect.ASK);
                this.execute(entry, nodeSource, mainPromise, slots, attempt, options);
                return;
            }
            if ((e instanceof RedisLoadingException || e instanceof RedisTryAgainException) && details.getAttempt() < this.connectionManager.getConfig().getRetryAttempts()) {
                entry.clearErrors();
                this.connectionManager.newTimeout(new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        CommandBatchService.this.execute(entry, source, mainPromise, slots, attempt + 1, options);
                    }
                }, Math.min(this.connectionManager.getConfig().getTimeout(), 1000), TimeUnit.MILLISECONDS);
                return;
            }
            this.free(entry);
            this.handle(mainPromise, slots, attemptPromise);
        });
    }

    protected void free(Entry entry) {
        for (BatchCommandData<?, ?> command : entry.getCommands()) {
            this.free(command.getParams());
        }
    }

    private void checkWriteFuture(final Entry entry, final RPromise<Void> attemptPromise, final AsyncDetails details, final RedisConnection connection, ChannelFuture future, long responseTimeout, int attempts, final AtomicInteger slots, final RPromise<Void> mainPromise) {
        if (future.isCancelled() || attemptPromise.isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            details.setException(new WriteRedisConnectionException("Can't write command batch to channel: " + future.channel(), future.cause()));
            if (details.getAttempt() == attempts && !attemptPromise.tryFailure(details.getException())) {
                log.error(details.getException().getMessage());
            }
            return;
        }
        details.getTimeout().cancel();
        TimerTask timerTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (details.getAttempt() < CommandBatchService.this.connectionManager.getConfig().getRetryAttempts()) {
                    if (!details.getAttemptPromise().cancel(false)) {
                        return;
                    }
                    int count = details.getAttempt() + 1;
                    if (CommandAsyncService.log.isDebugEnabled()) {
                        CommandAsyncService.log.debug("attempt {} for command {} and params {}", new Object[]{count, details.getCommand(), LogHelper.toString(details.getParams())});
                    }
                    details.removeMainPromiseListener();
                    CommandBatchService.this.execute(entry, details.getSource(), mainPromise, slots, count, CommandBatchService.this.options);
                    return;
                }
                attemptPromise.tryFailure(new RedisResponseTimeoutException("Redis server response timeout during command batch execution. Channel: " + connection.getChannel()));
            }
        };
        long timeout = this.connectionManager.getConfig().getTimeout();
        if (responseTimeout > 0L) {
            timeout = responseTimeout;
        }
        Timeout timeoutTask = this.connectionManager.newTimeout(timerTask, timeout, TimeUnit.MILLISECONDS);
        details.setTimeout(timeoutTask);
    }

    private void checkConnectionFuture(final Entry entry, NodeSource source, final RPromise<Void> mainPromise, final RPromise<Void> attemptPromise, final AsyncDetails details, RFuture<RedisConnection> connFuture, boolean noResult, final long responseTimeout, final int attempts, BatchOptions.ExecutionMode executionMode, final AtomicInteger slots) {
        if (connFuture.isCancelled()) {
            this.connectionManager.getShutdownLatch().release();
            return;
        }
        if (!connFuture.isSuccess()) {
            this.connectionManager.getShutdownLatch().release();
            details.setException(this.convertException(connFuture));
            return;
        }
        if (attemptPromise.isDone() || mainPromise.isDone()) {
            this.releaseConnection(source, connFuture, details.isReadOnlyMode(), attemptPromise, details);
            return;
        }
        final RedisConnection connection = connFuture.getNow();
        boolean isAtomic = executionMode != BatchOptions.ExecutionMode.IN_MEMORY;
        boolean isQueued = executionMode == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || executionMode == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        ArrayList list = new ArrayList(entry.getCommands().size());
        if (source.getRedirect() == NodeSource.Redirect.ASK) {
            RedissonPromise promise = new RedissonPromise();
            list.add(new CommandData(promise, StringCodec.INSTANCE, RedisCommands.ASKING, new Object[0]));
        }
        for (BatchCommandData batchCommandData : entry.getCommands()) {
            if (batchCommandData.getPromise().isSuccess() && !this.isWaitCommand(batchCommandData) && !isAtomic) continue;
            list.add(batchCommandData);
        }
        ChannelFuture future = connection.send(new CommandsData(attemptPromise, list, noResult, isAtomic, isQueued));
        details.setWriteFuture(future);
        details.getWriteFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                CommandBatchService.this.checkWriteFuture(entry, attemptPromise, details, connection, future, responseTimeout, attempts, slots, mainPromise);
            }
        });
        this.releaseConnection(source, connFuture, entry.isReadOnlyMode(), attemptPromise, details);
    }

    protected boolean isWaitCommand(BatchCommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName());
    }

    protected void handle(RPromise<Void> mainPromise, AtomicInteger slots, RFuture<?> future) {
        if (future.isSuccess()) {
            if (slots.decrementAndGet() == 0) {
                mainPromise.trySuccess(null);
            }
        } else {
            mainPromise.tryFailure(future.cause());
        }
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    public static class Entry {
        Deque<BatchCommandData<?, ?>> commands = new LinkedBlockingDeque();
        volatile boolean readOnlyMode = true;

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }

    public static class ConnectionEntry {
        boolean firstCommand = true;
        RFuture<RedisConnection> connectionFuture;

        public RFuture<RedisConnection> getConnectionFuture() {
            return this.connectionFuture;
        }

        public void setConnectionFuture(RFuture<RedisConnection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public boolean isFirstCommand() {
            return this.firstCommand;
        }

        public void setFirstCommand(boolean firstCommand) {
            this.firstCommand = firstCommand;
        }
    }
}

