/*
 * Decompiled with CFR 0.152.
 */
package com.shiku.mongodb.morphia;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.shiku.common.core.Callback;
import com.shiku.mongodb.morphia.IMorphiaDAO;
import com.shiku.utils.StringUtil;
import com.shiku.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryResults;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class MorphiaRepository<T, ID extends Serializable>
implements IMorphiaDAO<T, ID> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected Morphia morphia;
    @Resource(name="dsForRW")
    private Datastore dsForRW;
    @Resource(name="mongoClient")
    private MongoClient mongoClient;

    @Override
    @Qualifier(value="morphia")
    public Morphia getMorphia() {
        return this.morphia;
    }

    @Override
    @Qualifier(value="dsForRW")
    public Datastore getDatastore() {
        return this.dsForRW;
    }

    @Override
    @Qualifier(value="mongoClient")
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Override
    public abstract Class<T> getEntityClass();

    @Override
    public String getCollectionName(long userId) {
        int remainder = 0;
        if (userId > 100000L) {
            remainder = (int)(userId / 10000L);
        }
        return String.valueOf(remainder);
    }

    @Override
    public MongoCollection getCollection(long userId) {
        String collectionName = this.getCollectionName(userId);
        MongoDatabase database = this.getMongoClient().getDatabase(this.getCollectionName());
        return database.getCollection(collectionName);
    }

    @Override
    public MongoCollection getMongoCollection(String dbName) {
        MongoDatabase database = this.getMongoClient().getDatabase(this.getCollectionName());
        return database.getCollection(dbName);
    }

    @Override
    public MongoCollection<DBObject> getDBObjectCollection(int userId) {
        String collectionName = this.getCollectionName(userId);
        MongoDatabase database = this.getMongoClient().getDatabase(this.getCollectionName());
        return database.getCollection(collectionName, DBObject.class);
    }

    @Override
    public String getCollectionName(int userId, int remainder) {
        Object collectionName = null;
        if (userId > 100000) {
            remainder = userId / remainder;
        }
        return String.valueOf(remainder);
    }

    @Override
    public String getCollectionName() {
        MappedClass mappedClass = this.morphia.getMapper().getMappedClass(this.getEntityClass());
        if (null == mappedClass) {
            return null;
        }
        return mappedClass.getCollectionName();
    }

    public String getCollectionName(ObjectId id) {
        if (null == id) {
            this.logger.info(" ====  getCollectionName ObjectId is null  ====");
            throw new RuntimeException("ObjectId  is  null !");
        }
        int remainder = 0;
        int counter = id.getCounter();
        remainder = counter / 100000;
        return String.valueOf(remainder);
    }

    public MongoCollection<Document> getCollection(ObjectId id) {
        String collectionName = this.getCollectionName(id);
        MongoDatabase database = this.getMongoClient().getDatabase(this.getCollectionName());
        return database.getCollection(collectionName);
    }

    public MongoCollection<DBObject> getDBObjectCollection(ObjectId id) {
        String collectionName = this.getCollectionName(id);
        return this.getMongoClient().getDatabase(this.getCollectionName()).getCollection(collectionName, DBObject.class);
    }

    @Override
    public List<String> getCollectionList() {
        ArrayList<String> list = new ArrayList<String>();
        MongoIterable collectionNames = this.getMongoClient().getDatabase(this.getCollectionName()).listCollectionNames();
        for (String s : collectionNames) {
            list.add(s);
        }
        list.remove("system.indexes");
        return list;
    }

    @Override
    public DBObject objectToDBObject(Object entity) {
        return this.morphia.toDBObject(entity);
    }

    @Override
    public void updateAttribute(ID id, T entity) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal(id);
        DBObject dbObject = this.getMorphia().toDBObject(entity);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        dbObject.keySet().forEach(key -> {
            if ("_id".equals(key) || "createTime".equals(key)) {
                return;
            }
            ops.set(key, dbObject.get(key));
        });
        this.getDatastore().update(q, ops);
    }

    @Override
    public void updateAttributeByIdAndKey(ID id, String key, Object value) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal(id);
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set(key, value);
        this.getDatastore().update(q, ops);
    }

    @Override
    public void updateAttributeByIdAndKey(Class<?> clazz, ID id, String key, Object value) {
        BasicDBObject query = new BasicDBObject("_id", id);
        BasicDBObject values = new BasicDBObject(key, value);
        this.getDatastore().getCollection(clazz).update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)values));
    }

    @Override
    public boolean updateAttributeByOps(ID id, UpdateOperations<T> ops) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal(id);
        UpdateResults updateResults = this.getDatastore().update(q, ops);
        return 0 < updateResults.getUpdatedCount();
    }

    @Override
    public boolean updateAttribute(String queryStr, Object queryValue, String key, Object value) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field(queryStr).equal(queryValue);
        q.disableValidation();
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set(key, value);
        UpdateResults updateResults = this.getDatastore().update(q, ops);
        return 0 < updateResults.getUpdatedCount();
    }

    @Override
    public void updateAttribute(String tbName, String queryStr, Object queryValue, String key, Object value) {
        BasicDBObject query = new BasicDBObject(queryStr, queryValue);
        BasicDBObject values = new BasicDBObject("$set", (Object)new BasicDBObject(key, value));
        this.getDatastore().getDB().getCollection(tbName).update((DBObject)query, (DBObject)values, false, true);
    }

    @Override
    public void updateAttributeSet(String tbName, String queryStr, Object queryValue, BasicDBObject value) {
        BasicDBObject query = new BasicDBObject(queryStr, queryValue);
        BasicDBObject values = new BasicDBObject("$set", (Object)value);
        this.getDatastore().getDB().getCollection(tbName).update((DBObject)query, (DBObject)values, false, true);
    }

    @Override
    public void updateAttribute(String tbName, String queryStr, Object queryValue, BasicDBObject update) {
        BasicDBObject query = new BasicDBObject(queryStr, queryValue);
        this.getDatastore().getDB().getCollection(tbName).update((DBObject)query, (DBObject)update, false, true);
    }

    @Override
    public void updateAttribute(ID id, String key, Object value) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field("_id").equal(id);
        q.disableValidation();
        UpdateOperations ops = this.getDatastore().createUpdateOperations(this.getEntityClass());
        ops.set(key, value);
        this.getDatastore().update(q, ops);
    }

    @Override
    public T queryOne(String key, Object value) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field(key).equal(value);
        return (T)q.get();
    }

    @Override
    public List<T> getEntityListsByKey(String key, Object value) {
        Query q = (Query)this.getDatastore().createQuery(this.getEntityClass()).field(key).equal(value);
        return q.asList();
    }

    public List<T> getEntityListsByQuery(Query<T> q) {
        return q.asList();
    }

    @Override
    public List<?> getEntityListsByKey(Class<?> clazz, String key, Object value, String sort) {
        Query q = (Query)this.getDatastore().createQuery(clazz).field(key).equal(value);
        if (!StringUtil.isEmpty((String)sort)) {
            q.order(sort);
        }
        return q.asList();
    }

    @Override
    public List<?> getEntityListsByKey(Class<?> clazz, String key, Object value, String sort, int pageIndex, int pageSize) {
        Query q = (Query)this.getDatastore().createQuery(clazz).field(key).equal(value);
        if (!StringUtils.isEmpty((String)sort)) {
            q.order(sort);
        }
        return q.offset(pageIndex * pageSize).limit(pageSize).asList();
    }

    @Override
    public Object saveEntity(Object entity) {
        return this.getDatastore().save(entity);
    }

    @Override
    public Object update(ID id, T entity) {
        T dest = this.get(id);
        try {
            BeanUtils.copyProperties(dest, entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.save(dest);
    }

    @Override
    public Object updateEntity(Class<?> clazz, ID id, Object entity) {
        Object dest = this.getDatastore().get(clazz, id);
        try {
            BeanUtils.copyProperties((Object)dest, (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getDatastore().save(dest);
    }

    @Override
    public List<Object> findAndDelete(String name, DBObject q) {
        List<Object> idList = this.selectId(name, q);
        this.getDatastore().getDB().getCollection(name).remove(q);
        return idList;
    }

    @Override
    public List distinct(String name, String key, DBObject q) {
        return this.getDatastore().getDB().getCollection(name).distinct(key, q);
    }

    @Override
    public List distinct(String key, DBObject q) {
        return this.getDatastore().getCollection(this.getEntityClass()).distinct(key, q);
    }

    public List distinct(Class classz, String key, String queryKey, String queryValue) {
        BasicDBObject query = new BasicDBObject(queryKey, (Object)queryValue);
        return this.getDatastore().getCollection(classz).distinct(key, (DBObject)query);
    }

    @Override
    public Object queryOneField(String key, DBObject query) {
        BasicDBObject projection = new BasicDBObject(key, (Object)1);
        DBObject dbObj = this.getDatastore().getCollection(this.getEntityClass()).findOne(query, (DBObject)projection);
        if (null == dbObj) {
            return null;
        }
        return dbObj.get(key);
    }

    @Override
    public Object queryOneField(Class<T> entityClass, String key, DBObject query) {
        BasicDBObject projection = new BasicDBObject(key, (Object)1);
        DBObject dbObj = this.getDatastore().getCollection(entityClass).findOne(query, (DBObject)projection);
        if (null == dbObj) {
            return null;
        }
        return dbObj.get(key);
    }

    @Override
    public Object queryOneField(Class<T> entityClass, String key, String queryStr, Object queryValue) {
        BasicDBObject query = new BasicDBObject(queryStr, queryValue);
        return this.queryOneField(entityClass, key, (DBObject)query);
    }

    @Override
    public Object queryOneField(String dbName, String key, DBObject query) {
        BasicDBObject projection = new BasicDBObject(key, (Object)1);
        DBObject dbObj = this.getDatastore().getDB().getCollection(dbName).findOne(query, (DBObject)projection);
        if (null == dbObj) {
            return null;
        }
        return dbObj.get(key);
    }

    @Override
    public Object queryOneFieldById(String key, ID id) {
        BasicDBObject query = new BasicDBObject("_id", id);
        BasicDBObject projection = new BasicDBObject(key, (Object)1);
        DBObject dbObj = this.getDatastore().getCollection(this.getEntityClass()).findOne((DBObject)query, (DBObject)projection);
        if (null == dbObj) {
            return null;
        }
        return dbObj.get(key);
    }

    public BasicDBObject queryOneFields(DBObject query, String ... keys) {
        BasicDBObject projection = new BasicDBObject();
        for (String str : keys) {
            projection.put(str, (Object)1);
        }
        BasicDBObject dbObj = (BasicDBObject)this.getDatastore().getCollection(this.getEntityClass()).findOne(query, (DBObject)projection);
        return dbObj;
    }

    public BasicDBObject queryOneFieldsById(ID id, String ... keys) {
        BasicDBObject projection = new BasicDBObject();
        BasicDBObject query = new BasicDBObject("_id", id);
        for (String str : keys) {
            projection.put(str, (Object)1);
        }
        BasicDBObject dbObj = (BasicDBObject)this.getDatastore().getCollection(this.getEntityClass()).findOne((DBObject)query, (DBObject)projection);
        return dbObj;
    }

    public List<BasicDBObject> queryListFields(DBObject query, String ... keys) {
        BasicDBObject projection = new BasicDBObject();
        for (String str : keys) {
            projection.put(str, (Object)1);
        }
        ArrayList<BasicDBObject> results = new ArrayList<BasicDBObject>();
        DBCursor dbCursor = this.getDatastore().getCollection(this.getEntityClass()).find(query, (DBObject)projection);
        while (dbCursor.hasNext()) {
            results.add((BasicDBObject)dbCursor.next());
        }
        dbCursor.close();
        return results;
    }

    @Override
    public BasicDBObject findAndModify(String name, DBObject query, DBObject update) {
        return (BasicDBObject)this.getDatastore().getDB().getCollection(name).findAndModify(query, update);
    }

    public <T> List<Object> findAndUpdate(Query<T> q, UpdateOperations<T> ops, DBObject keys, Callback callback) {
        ArrayList<Object> idList = new ArrayList<Object>();
        DBCursor cursor = this.getCollection(q).find(q.getQueryObject(), keys);
        while (cursor.hasNext()) {
            DBObject dbObj = cursor.next();
            callback.execute((Object)dbObj);
            idList.add(dbObj.get("_id").toString());
        }
        cursor.close();
        this.getDatastore().update(q, ops);
        return idList;
    }

    @Override
    public List<Object> findAndUpdate(String name, DBObject q, DBObject ops, DBObject keys, Callback callback) {
        DBCursor cursor;
        ArrayList<Object> idList = new ArrayList<Object>();
        DBCollection dbColl = this.getDatastore().getDB().getCollection(name);
        DBCursor dBCursor = cursor = null == keys ? dbColl.find(q) : dbColl.find(q, keys);
        while (cursor.hasNext()) {
            BasicDBObject dbObj = (BasicDBObject)cursor.next();
            callback.execute((Object)dbObj);
            idList.add(dbObj.get("_id").toString());
        }
        cursor.close();
        dbColl.update(q, ops, false, true);
        return idList;
    }

    @Override
    public <T> DBCollection getCollection(Query<T> q) {
        DBCollection dbColl = q.getCollection();
        if (dbColl == null) {
            dbColl = this.getDatastore().getCollection(q.getEntityClass());
        }
        return dbColl;
    }

    public List<Object> handlerAndReturnId(String name, DBObject q, DBObject keys, Callback callback) {
        ArrayList<Object> idList = new ArrayList<Object>();
        DBCursor cursor = this.getDatastore().getDB().getCollection(name).find(q, keys);
        while (cursor.hasNext()) {
            DBObject dbObj = cursor.next();
            callback.execute((Object)dbObj);
            idList.add(dbObj.get("_id").toString());
        }
        cursor.close();
        return idList;
    }

    public void insert(String name, DBObject ... arr) {
        this.getDatastore().getDB().getCollection(name).insert(arr);
    }

    public List<Object> selectId(String name, DBObject q) {
        ArrayList<Object> idList = new ArrayList<Object>();
        DBCursor cursor = this.getDatastore().getDB().getCollection(name).find(q, (DBObject)new BasicDBObject("_id", (Object)1));
        while (cursor.hasNext()) {
            DBObject dbObj = cursor.next();
            idList.add(dbObj.get("_id").toString());
        }
        cursor.close();
        return idList;
    }

    @Override
    public List<Object> selectId(String name, QueryBuilder qb) {
        return this.selectId(name, qb.get());
    }

    @Override
    public List<?> keysToIds(List<Key<T>> keys) {
        ArrayList<Object> ids = new ArrayList<Object>(keys.size() * 2);
        for (Key<T> key : keys) {
            ids.add(key.getId());
        }
        return ids;
    }

    @Override
    public Query<T> createQuery() {
        return this.getDatastore().createQuery(this.getEntityClass());
    }

    @Override
    public FindOptions pageFindOption(int page, int limit, int start) {
        FindOptions findOptions = new FindOptions();
        if (start == 1 && page > 0) {
            findOptions.skip((page - 1) * limit).limit(limit);
        } else {
            findOptions.skip(page * limit).limit(limit);
        }
        return findOptions;
    }

    @Override
    public UpdateOperations<T> createUpdateOperations() {
        return this.getDatastore().createUpdateOperations(this.getEntityClass());
    }

    public Iterable<Key<T>> save(Iterable<T> entities) {
        return this.getDatastore().save(entities);
    }

    public Key<T> save(T entity) {
        return this.getDatastore().save(entity);
    }

    public Key<T> save(T entity, WriteConcern wc) {
        return this.getDatastore().save(entity, wc);
    }

    public UpdateResults updateFirst(Query<T> q, UpdateOperations<T> ops) {
        return this.getDatastore().updateFirst(q, ops);
    }

    public UpdateResults update(Query<T> q, UpdateOperations<T> ops) {
        return this.getDatastore().update(q, ops);
    }

    public WriteResult delete(T entity) {
        return this.getDatastore().delete(entity);
    }

    public WriteResult delete(T entity, WriteConcern wc) {
        return this.getDatastore().delete(entity, wc);
    }

    public WriteResult deleteById(ID id) {
        return this.getDatastore().delete(this.getEntityClass(), id);
    }

    public WriteResult deleteByQuery(Query<T> q) {
        return this.getDatastore().delete(q);
    }

    public T get(ID id) {
        return (T)this.getDatastore().get(this.getEntityClass(), id);
    }

    public Object getEntityById(Class<?> clazz, ID id) {
        return this.getDatastore().get(clazz, id);
    }

    public List<ID> findIds() {
        return this.keysToIds(this.getDatastore().find(this.getEntityClass()).asKeyList());
    }

    public List<ID> findIds(String key, Object value) {
        return this.keysToIds(this.getDatastore().find(this.getEntityClass(), key, value).asKeyList());
    }

    public List<ID> findIds(Query<T> q) {
        return this.keysToIds(q.asKeyList());
    }

    public Key<T> findOneId() {
        return this.findOneId(this.getDatastore().find(this.getEntityClass()));
    }

    public Key<T> findOneId(String key, Object value) {
        return this.findOneId(this.getDatastore().find(this.getEntityClass(), key, value));
    }

    public Key<T> findOneId(Query<T> q) {
        Iterator keys = q.fetchKeys().iterator();
        return keys.hasNext() ? (Key)keys.next() : null;
    }

    public boolean exists(String key, Object value) {
        return this.exists(this.getDatastore().find(this.getEntityClass(), key, value));
    }

    public boolean exists(Query<T> q) {
        return this.getDatastore().getCount(q) > 0L;
    }

    public long count() {
        return this.getDatastore().getCount(this.getEntityClass());
    }

    public long count(String key, Object value) {
        return this.count(this.getDatastore().find(this.getEntityClass(), key, value));
    }

    public long count(Query<T> q) {
        return this.getDatastore().getCount(q);
    }

    public Object findOne(DBObject query) {
        return this.getDatastore().getCollection(this.getEntityClass()).findOne(query);
    }

    public T findOne(String key, Object value) {
        return (T)this.getDatastore().find(this.getEntityClass(), key, value).get();
    }

    @Override
    public <V> V findOne(Class<V> tClass, String key, Object value) {
        return (V)this.getDatastore().find(tClass, key, value).get();
    }

    public T findOne(Query<T> q) {
        return (T)q.get();
    }

    public QueryResults<T> find() {
        return this.createQuery();
    }

    public QueryResults<T> find(Query<T> q) {
        return q;
    }

    public void ensureIndexes() {
        this.getDatastore().ensureIndexes(this.getEntityClass());
    }

    public DBCollection getCollection() {
        return this.getDatastore().getCollection(this.getEntityClass());
    }
}

