/*
 * Decompiled with CFR 0.152.
 */
package com.shiku.mongodb.morphia;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.shiku.mongodb.morphia.MongoConfig;
import com.shiku.utils.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.annotations.Entity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MongoConfig.class})
public class MorphiaAutoConfiguration {
    @Autowired
    private MongoConfig mongoConfig;

    public MongoClientOptions getMongoClientOptions(MongoConfig mongoConfig) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.socketKeepAlive(true);
        builder.connectTimeout(mongoConfig.getConnectTimeout());
        builder.socketTimeout(mongoConfig.getSocketTimeout());
        builder.maxWaitTime(mongoConfig.getMaxWaitTime());
        builder.heartbeatFrequency(10000);
        builder.readPreference(ReadPreference.nearest());
        return builder.build();
    }

    @Bean(name={"morphia"})
    public Morphia initMorphia() {
        Morphia morphia = new Morphia();
        if (!StringUtil.isEmpty((String)this.mongoConfig.getMapPackage())) {
            morphia.mapPackage(this.mongoConfig.getMapPackage());
        }
        return morphia;
    }

    @Bean(name={"mongoClient"}, destroyMethod="close")
    public MongoClient initMongoClient() {
        MongoClient mongoClient = null;
        try {
            MongoClientURI mongoClientURI = new MongoClientURI(this.mongoConfig.getUri());
            MongoCredential credential = null;
            if (!StringUtil.isEmpty((String)this.mongoConfig.getUsername()) && !StringUtil.isEmpty((String)this.mongoConfig.getPassword())) {
                credential = MongoCredential.createScramSha1Credential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getDbName(), (char[])this.mongoConfig.getPassword().toCharArray());
            }
            mongoClient = new MongoClient(mongoClientURI);
            return mongoClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean(name={"dsForRW"})
    public Datastore dsForRW(MongoClient mongoClient, Morphia morphia) {
        try {
            Datastore datastore = morphia.createDatastore(mongoClient, this.mongoConfig.getDbName());
            datastore.ensureIndexes();
            datastore.ensureCaps();
            return datastore;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void mapPackage(String packageName, Morphia morphia) {
        try {
            String name = packageName.replace('.', '/');
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            String[] names = url.toString().split("!");
            if (1 == names.length) {
                File packagePath = new File(names[0].replace("file:/", ""));
                if (packagePath.isDirectory()) {
                    File[] files;
                    for (File file : files = packagePath.listFiles()) {
                        String className;
                        Class<?> cls;
                        if (!file.getName().endsWith(".class") || -1 != file.getName().indexOf("$") || null == (cls = Class.forName(className = packageName + "." + file.getName().replace('/', '.').replace(".class", ""))).getAnnotation(Entity.class)) continue;
                        morphia.map(new Class[]{Class.forName(className)});
                        System.out.println("mapPackage\uff1a" + className);
                    }
                }
            } else if (3 == names.length) {
                JarEntry je;
                String warName = names[0].replace("jar:file:", "");
                String jarName = names[1].substring(1);
                String packagePath = names[2].substring(1);
                JarFile jarFile = new JarFile(new File(warName));
                JarEntry ze = jarFile.getJarEntry(jarName);
                InputStream in = jarFile.getInputStream(ze);
                JarInputStream is = new JarInputStream(in);
                while (null != (je = is.getNextJarEntry())) {
                    String className;
                    Class<?> cls;
                    if (!je.getName().startsWith(packagePath) || !je.getName().endsWith(".class") || -1 != je.getName().indexOf("$") || null == (cls = Class.forName(className = je.getName().replace('/', '.').replace(".class", ""))).getAnnotation(Entity.class)) continue;
                    morphia.map(new Class[]{Class.forName(className)});
                    System.out.println("mapPackage\uff1a" + className);
                }
                is.closeEntry();
                is.close();
                jarFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

