/*
 * Decompiled with CFR 0.152.
 */
package com.shiku.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ImageHelper {
    public static final String path = System.getProperty("user.dir");

    public static BufferedImage thumb(BufferedImage source, int width, int height, boolean b) {
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)width / (double)source.getWidth();
        double sy = (double)height / (double)source.getHeight();
        if (b) {
            if (sx > sy) {
                sx = sy;
                width = (int)(sx * (double)source.getWidth());
            } else {
                sy = sx;
                height = (int)(sy * (double)source.getHeight());
            }
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(width, height, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    public static int rgbToGray(int pixels) {
        int _red = pixels >> 16 & 0xFF;
        int _green = pixels >> 8 & 0xFF;
        int _blue = pixels & 0xFF;
        return (int)(0.3 * (double)_red + 0.59 * (double)_green + 0.11 * (double)_blue);
    }

    public static int average(int[] pixels) {
        float m = 0.0f;
        for (int i = 0; i < pixels.length; ++i) {
            m += (float)pixels[i];
        }
        return (int)(m /= (float)pixels.length);
    }

    public static int hammingDistance(String sourceHashCode, String hashCode) {
        int difference = 0;
        int len = sourceHashCode.length();
        for (int i = 0; i < len; ++i) {
            if (sourceHashCode.charAt(i) == hashCode.charAt(i)) continue;
            ++difference;
        }
        return difference;
    }

    public static String produceFingerPrint(String filename) {
        BufferedImage source = null;
        int width = 8;
        int height = 8;
        BufferedImage thumb = ImageHelper.thumb(source, width, height, false);
        int[] pixels = new int[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                pixels[i * height + j] = ImageHelper.rgbToGray(thumb.getRGB(i, j));
            }
        }
        int avgPixel = ImageHelper.average(pixels);
        int[] comps = new int[width * height];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = pixels[i] >= avgPixel ? 1 : 0;
        }
        StringBuffer hashCode = new StringBuffer();
        for (int i = 0; i < comps.length; i += 4) {
            int result = comps[i] * (int)Math.pow(2.0, 3.0) + comps[i + 1] * (int)Math.pow(2.0, 2.0) + comps[i + 2] * (int)Math.pow(2.0, 1.0) + comps[i + 2];
            hashCode.append(ImageHelper.binaryToHex(result));
        }
        return hashCode.toString();
    }

    private static char binaryToHex(int binary) {
        char ch = ' ';
        switch (binary) {
            case 0: {
                ch = '0';
                break;
            }
            case 1: {
                ch = '1';
                break;
            }
            case 2: {
                ch = '2';
                break;
            }
            case 3: {
                ch = '3';
                break;
            }
            case 4: {
                ch = '4';
                break;
            }
            case 5: {
                ch = '5';
                break;
            }
            case 6: {
                ch = '6';
                break;
            }
            case 7: {
                ch = '7';
                break;
            }
            case 8: {
                ch = '8';
                break;
            }
            case 9: {
                ch = '9';
                break;
            }
            case 10: {
                ch = 'a';
                break;
            }
            case 11: {
                ch = 'b';
                break;
            }
            case 12: {
                ch = 'c';
                break;
            }
            case 13: {
                ch = 'd';
                break;
            }
            case 14: {
                ch = 'e';
                break;
            }
            case 15: {
                ch = 'f';
                break;
            }
            default: {
                ch = ' ';
            }
        }
        return ch;
    }
}

