/*
 * Decompiled with CFR 0.152.
 */
package com.shiku.commons.thread.pool;

import com.shiku.commons.thread.pool.AbstractSynRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class SynThreadPoolExecutor
extends ThreadPoolExecutor {
    private String name = null;

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBeforeExecute(Runnable runnable) {
        if (runnable instanceof AbstractSynRunnable) {
            AbstractSynRunnable synRunnable = (AbstractSynRunnable)runnable;
            if (synRunnable.isExecuted()) {
                return false;
            }
            ReadWriteLock runningLock = synRunnable.runningLock();
            Lock writeLock = runningLock.writeLock();
            boolean tryLock = writeLock.tryLock();
            try {
                if (tryLock) {
                    if (synRunnable.isExecuted()) {
                        boolean bl = false;
                        return bl;
                    }
                    synRunnable.executeCount.incrementAndGet();
                    synRunnable.setExecuted(true);
                }
                boolean bl = tryLock;
                return bl;
            }
            finally {
                if (tryLock) {
                    writeLock.unlock();
                }
            }
        }
        return true;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.checkBeforeExecute(runnable)) {
            this.execute1(runnable);
        }
    }

    private void execute1(Runnable runnable) {
        super.execute(runnable);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public <R> Future<R> submit(Runnable runnable, R result) {
        if (this.checkBeforeExecute(runnable)) {
            Future<R> ret = super.submit(runnable, result);
            return ret;
        }
        return null;
    }
}

